/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.InputStream;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.impl.LargeMapImpl;
import org.gvsig.fmap.dal.impl.LargeSetImpl;
import org.gvsig.fmap.dal.impl.SpatialIndexFactoryMVRTree;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorerFactory;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorerParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialNewStoreParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialStoreParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialStoreProviderFactory;
import org.gvsig.fmap.dal.store.jdbc2.JDBCLibrary;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.json.Json;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class H2SpatialLibrary
extends AbstractLibrary {
    public static final String NAME = "H2Spatial";

    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(JDBCLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        LibraryException ex = null;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            Class.forName("org.h2.Driver");
        }
        catch (Throwable th) {
            H2SpatialHelper.LOGGER.warn("Can't load H2Spatial JDBC Driver.", th);
        }
        DBHelper.registerParametersDefinition((String)"H2SpatialStoreParameters", H2SpatialStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "H2SpatialParameters.xml"));
        DBHelper.registerParametersDefinition((String)"H2SpatialNewStoreParameters", H2SpatialNewStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "H2SpatialParameters.xml"));
        DBHelper.registerParametersDefinition((String)"H2SpatialServerExplorerParameters", H2SpatialExplorerParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "H2SpatialParameters.xml"));
        try {
            DBHelper.registerMetadataDefinition((String)NAME, JDBCStoreProviderBase.class, (InputStream)dataman.getResourceAsStream((Object)this, "H2SpatialMetadata.xml"));
        }
        catch (MetadataException e) {
            ex = new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        if (!dataman.getStoreProviderRegister().exits(NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new H2SpatialStoreProviderFactory());
        }
        if (!dataman.getServerExplorerRegister().exits(NAME)) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new H2SpatialExplorerFactory());
        }
        LargeMapImpl.selfRegister();
        LargeSetImpl.selfRegister();
        Json.registerSerializer(H2SpatialExplorerParameters.class);
        SpatialIndexFactoryMVRTree.selfRegister();
        if (ex != null) {
            throw ex;
        }
    }
}

