/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.expressionbuilderformatter.H2SpatialFormatter;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;

public class H2SpatialSQLBuilder
extends JDBCSQLBuilderBase {
    protected Formatter formatter = null;

    public H2SpatialSQLBuilder(H2SpatialHelper helper) {
        super((JDBCHelper)helper);
        this.defaultSchema = "PUBLIC";
        this.supportSchemas = true;
        this.allowAutomaticValues = true;
        this.geometrySupportType = this.helper.getGeometrySupportType();
        this.hasSpatialFunctions = this.helper.hasSpatialFunctions();
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table = null;
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table = null;
        this.STMT_UPDATE_TABLE_STATISTICS_table = "ANALYZE SAMPLE_SIZE 0";
        this.type_boolean = "BOOLEAN";
        this.type_byte = "TINYINT";
        this.type_bytearray = "BLOB";
        this.type_geometry = "GEOMETRY";
        this.type_char = "CHAR";
        this.type_date = "DATE";
        this.type_double = "DOUBLE";
        this.type_decimal_ps = "DECIMAL({0,Number,##########},{1,Number,##########})";
        this.type_decimal_p = "DECIMAL({0,Number,##########})";
        this.type_float = "REAL";
        this.type_int = "INTEGER";
        this.type_long = "BIGINT";
        this.type_string = "CLOB";
        this.type_string_0 = "VARCHAR";
        this.type_string_p = "VARCHAR({0,Number,##########})";
        this.type_time = "TIME";
        this.type_timestamp = "TIMESTAMP";
        this.type_version = "VARCHAR";
        this.type_URI = "VARCHAR";
        this.type_URL = "VARCHAR";
        this.type_FILE = "VARCHAR";
        this.type_FOLDER = "VARCHAR";
    }

    public Formatter formatter() {
        if (this.formatter == null) {
            this.formatter = new H2SpatialFormatter((SQLBuilder)this);
        }
        return this.formatter;
    }

    public Object sqlgeometrydimension(int type, int subtype) {
        switch (subtype) {
            default: {
                return "XY";
            }
            case 2: {
                return "XYM";
            }
            case 1: {
                return "XYZ";
            }
            case 3: 
        }
        return "XYZM";
    }

    public String sqltype(int type, int size, int precision, int scale, int geomtype, int geomSubtype) {
        if (type != 66) {
            return super.sqltype(type, size, precision, scale, geomtype, geomSubtype);
        }
        return "GEOMETRY(" + this.sqlgeometrytype(geomtype, geomSubtype) + ")";
    }

    public Object sqlgeometrytype(int geomtype, int geomsubtype) {
        switch (geomtype) {
            case 1: {
                return 1;
            }
            case 7: {
                return 4;
            }
            case 18: {
                return 2;
            }
            case 21: {
                return 5;
            }
            case 19: {
                return 3;
            }
            case 22: {
                return 6;
            }
        }
        return 0;
    }

    public Object sqlgeometrynumdimension(int type, int subtype) {
        int dimensions = 2;
        switch (subtype) {
            case 1: {
                dimensions = 3;
                break;
            }
            case 0: {
                dimensions = 2;
                break;
            }
            case 2: {
                dimensions = 2;
                break;
            }
            case 3: {
                dimensions = 3;
            }
        }
        return dimensions;
    }

    public H2SpatialHelper getHelper() {
        return (H2SpatialHelper)this.helper;
    }

    public Disposable setParameters(PreparedStatement st, FeatureProvider feature) {
        String name = null;
        try {
            FeatureType featureType = feature.getType();
            ArrayList<Object> values = new ArrayList<Object>();
            block8: for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                if (parameter.is_constant()) {
                    values.add(parameter.value());
                    continue;
                }
                name = parameter.name();
                FeatureAttributeDescriptor descriptor = featureType.getAttributeDescriptor(name);
                switch (descriptor.getType()) {
                    case 9: {
                        java.util.Date value = (java.util.Date)feature.get(name);
                        if (value == null) {
                            values.add(null);
                            continue block8;
                        }
                        values.add(new Date(value.getTime()));
                        continue block8;
                    }
                    case 66: {
                        org.gvsig.fmap.geom.Geometry geom = this.forceGeometryType(descriptor.getGeomType(), (org.gvsig.fmap.geom.Geometry)feature.get(name));
                        values.add(geom);
                        continue block8;
                    }
                }
                values.add(feature.get(name));
            }
            return this.setStatementParameters(st, values, this.geometry_support_type());
        }
        catch (Exception ex) {
            String f = "unknow";
            try {
                f = feature.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't set parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    protected SQLBuilder.AlterTableBuilder createAlterTableBuilder() {
        return new H2SpatialAlterTableBuilderBase((SQLBuilderBase)this);
    }

    public SQLBuilder.TableNameBuilder createTableNameBuilder() {
        return new H2SpatialTableNameBuilderBase();
    }

    protected SQLBuilder.CreateTableBuilder createCreateTableBuilder() {
        return new H2SpatialCreateTableBuilder();
    }

    public SQLBuilder.SelectBuilder createSelectBuilder() {
        return new H2SpatialSelectBuilderBase();
    }

    public SQLBuilder.CreateIndexBuilder createCreateIndexBuilder() {
        return new H2SpatialCreateIndexBuilder();
    }

    public Disposable setStatementParameters(PreparedStatement st, List values, List<Integer> types, GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) throws SQLException {
        if (values == null) {
            return new Disposable(){

                public void dispose() {
                }
            };
        }
        if (LOGGER.isDebugEnabled()) {
            this.debug_setStatementParameters(st, values, types, geometrySupportType);
        }
        int columnIndex = 1;
        try {
            for (Object value : values) {
                if (value instanceof org.gvsig.fmap.geom.Geometry) {
                    switch (geometrySupportType) {
                        case WKT: {
                            value = ((org.gvsig.fmap.geom.Geometry)value).convertToWKT();
                            st.setObject(columnIndex, value);
                            break;
                        }
                        case NATIVE: 
                        case WKB: {
                            byte[] bytes = this.toWKB((org.gvsig.fmap.geom.Geometry)value);
                            st.setBytes(columnIndex, bytes);
                            break;
                        }
                        case EWKB: {
                            byte[] bytes = ((org.gvsig.fmap.geom.Geometry)value).convertToEWKB();
                            st.setBytes(columnIndex, bytes);
                        }
                    }
                } else if (types == null) {
                    st.setObject(columnIndex, value);
                } else {
                    this.setStatementValue(st, columnIndex, types.get(columnIndex - 1), value);
                }
                ++columnIndex;
            }
            return new Disposable(){

                public void dispose() {
                }
            };
        }
        catch (Exception ex) {
            throw new SQLException("Can't set values for the prepared statement.", ex);
        }
    }

    private byte[] toWKB(org.gvsig.fmap.geom.Geometry geom) throws Exception {
        GeometryType geomtype = geom.getGeometryType();
        if (!geomtype.hasM() && !geomtype.hasZ()) {
            return geom.convertToWKB();
        }
        Geometry geom_jts = (Geometry)geom.convertTo("jts", new Object[0]);
        IProjection proj = geom.getProjection();
        if (proj != null) {
            geom_jts.setSRID(((Integer)this.srs_id(proj)).intValue());
        }
        WKBWriter writer = new WKBWriter(geomtype.hasZ() ? 3 : 2, true);
        byte[] bytes = writer.write(geom_jts);
        return bytes;
    }

    public int getMaxRecomendedSQLLength() {
        return 10240;
    }

    public class H2SpatialSelectBuilderBase
    extends SQLBuilderBase.SelectBuilderBase {
        public H2SpatialSelectBuilderBase() {
            super((SQLBuilderBase)H2SpatialSQLBuilder.this);
        }

        public String toString(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            if (!this.isValid(builder)) {
                throw new IllegalStateException(builder.toString());
            }
            builder.append("SELECT ");
            if (this.distinct) {
                builder.append("DISTINCT ");
            }
            boolean first = true;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column.toString(formatter));
            }
            if (this.has_from()) {
                builder.append(" FROM ");
                builder.append(this.from.toString(formatter));
            }
            if (this.has_where()) {
                builder.append(" WHERE ");
                builder.append(this.where.toString(formatter));
            }
            if (this.has_group_by()) {
                builder.append(" GROUP BY ");
                builder.append(((ExpressionBuilder.Value)this.groupColumn.get(0)).toString(formatter));
                for (int i = 1; i < this.groupColumn.size(); ++i) {
                    builder.append(", ");
                    builder.append(((ExpressionBuilder.Value)this.groupColumn.get(i)).toString(formatter));
                }
            }
            if (this.has_order_by()) {
                builder.append(" ORDER BY ");
                first = true;
                for (SQLBuilder.OrderByBuilder item : this.order_by) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(item.toString(formatter));
                }
            }
            if (this.has_limit() && this.has_offset()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
                builder.append(" OFFSET ");
                builder.append(this.offset);
            } else if (this.has_limit()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
            } else if (this.has_offset()) {
                builder.append(" LIMIT -1 OFFSET ");
                builder.append(this.offset);
            }
            return builder.toString();
        }
    }

    protected class H2SpatialCreateTableBuilder
    extends SQLBuilderBase.CreateTableBuilderBase {
        protected H2SpatialCreateTableBuilder() {
            super((SQLBuilderBase)H2SpatialSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" (");
            boolean first = true;
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(H2SpatialSQLBuilder.this.as_identifier(column.getName()));
                builder.append(" ");
                builder.append(H2SpatialSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                if (column.isGeometry()) {
                    if (column.getGeometrySRSId() == null) {
                        if ((Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()) == 0) {
                            builder.append(MessageFormat.format(" CHECK NVL2(\"{0}\", ST_CoordDim(\"{0}\") = {1}, TRUE)", column.getName(), H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype())));
                        } else {
                            builder.append(MessageFormat.format(" CHECK NVL2(\"{0}\", ST_GeometryTypeCode(\"{0}\") = {1} AND ST_CoordDim(\"{0}\") = {2}, TRUE)", column.getName(), H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()), H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype())));
                        }
                    } else if ((Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()) == 0) {
                        builder.append(MessageFormat.format(" CHECK NVL2(\"{0}\", ST_CoordDim(\"{0}\") = {1,number,###} AND ST_SRID(\"{0}\") = {2,number,#####}, TRUE)", column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype()), (Integer)column.getGeometrySRSId()));
                    } else {
                        builder.append(MessageFormat.format(" CHECK NVL2(\"{0}\", ST_GeometryTypeCode(\"{0}\") = {1,number,###} AND ST_CoordDim(\"{0}\") = {2,number,###} AND ST_SRID(\"{0}\") = {3,number,#####}, TRUE)", column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype()), (Integer)column.getGeometrySRSId()));
                    }
                } else if (column.isPrimaryKey()) {
                    builder.append(" PRIMARY KEY");
                    if (column.isAutomatic()) {
                        builder.append(" AUTO_INCREMENT");
                    }
                } else {
                    if (column.isAutomatic()) {
                        builder.append(" AUTO_INCREMENT");
                    }
                    if (column.getDefaultValue() == null || ExpressionUtils.isDynamicText((String)Objects.toString(column.getDefaultValue(), null))) {
                        if (column.allowNulls()) {
                            builder.append(" DEFAULT NULL");
                        }
                    } else {
                        switch (column.getType()) {
                            case 11: {
                                builder.append(" DEFAULT ( TIMESTAMP '");
                                Timestamp dtimestamp = DataTypeUtils.toTimestamp((Object)column.getDefaultValue());
                                builder.append(MessageFormat.format("{0,date,yyyy-MM-dd HH:mm:ss.S}", dtimestamp));
                                builder.append("' )");
                                break;
                            }
                            case 10: {
                                builder.append(" DEFAULT ( TIME '");
                                Time dtime = DataTypeUtils.toTime((Object)column.getDefaultValue());
                                builder.append(MessageFormat.format("{0,date,HH:mm:ss}", dtime));
                                builder.append("' )");
                                break;
                            }
                            case 9: {
                                builder.append(" DEFAULT ( DATE '");
                                Date ddate = DataTypeUtils.toDate((Object)column.getDefaultValue());
                                builder.append(MessageFormat.format("{0,date,yyyy-MM-dd}", ddate));
                                builder.append("' )");
                                break;
                            }
                            default: {
                                builder.append(" DEFAULT '");
                                builder.append(Objects.toString(column.getDefaultValue(), ""));
                                builder.append("'");
                            }
                        }
                    }
                }
                if (!column.allowNulls()) {
                    builder.append(" NOT NULL");
                }
                if (StringUtils.isNotBlank((CharSequence)column.getForeignkeyTableName())) {
                    if (column.isCategorized()) {
                        builder.append(" /* DICCIONARIO: ");
                        builder.append(H2SpatialSQLBuilder.this.expression().identifier(column.getForeignkeyTableName()));
                        builder.append(" */");
                    } else {
                        builder.append(" /* ENTIDAD: ");
                        builder.append(H2SpatialSQLBuilder.this.expression().identifier(column.getForeignkeyTableName()));
                        builder.append(" */");
                    }
                }
                if (!column.isForeignKey()) continue;
                builder.append(", ");
                builder.append("FOREIGN KEY (");
                builder.append(column.getName());
                builder.append(") REFERENCES ");
                builder.append(H2SpatialSQLBuilder.this.expression().identifier(column.getForeignkeyTableName()));
                builder.append("(");
                builder.append(H2SpatialSQLBuilder.this.expression().identifier(column.getForeignkeyFieldName()));
                builder.append(")");
            }
            builder.append(" )");
            sqls.add(builder.toString());
            return sqls;
        }
    }

    protected class H2SpatialAlterTableBuilderBase
    extends SQLBuilderBase.AlterTableBuilderBase {
        public H2SpatialAlterTableBuilderBase(SQLBuilderBase sqlbuilder) {
            super((SQLBuilderBase)H2SpatialSQLBuilder.this, sqlbuilder);
        }

        protected List<String> alter_column_add_geometry_constraint_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            String constraint_name = this.getConstrainName("GEOM", column.getName());
            String sql = column.getGeometrySRSId() == null ? ((Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()) == 0 ? MessageFormat.format("ALTER TABLE \"{0}\".\"{1}\" ADD CONSTRAINT IF NOT EXISTS \"{2}\" CHECK NVL2(\"{3}\", ST_CoordDim(\"{3}\") = {4,number,###}, TRUE)", this.table().getSchema(), this.table().getName(), constraint_name, column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype())) : MessageFormat.format("ALTER TABLE \"{0}\".\"{1}\" ADD CONSTRAINT IF NOT EXISTS \"{2}\" CHECK NVL2(\"{3}\", ST_GeometryTypeCode(\"{3}\") = {4,number,###} AND ST_CoordDim(\"{3}\") = {5,number,###}, TRUE)", this.table().getSchema(), this.table().getName(), constraint_name, column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype()))) : ((Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()) == 0 ? MessageFormat.format("ALTER TABLE \"{0}\".\"{1}\" ADD CONSTRAINT IF NOT EXISTS \"{2}\" CHECK NVL2(\"{3}\", ST_CoordDim(\"{3}\") = {4,number,###} AND ST_SRID(\"{3}\") = {5,number,#####}, TRUE)", this.table().getSchema(), this.table().getName(), constraint_name, column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype()), (Integer)column.getGeometrySRSId()) : MessageFormat.format("ALTER TABLE \"{0}\".\"{1}\" ADD CONSTRAINT IF NOT EXISTS \"{2}\" CHECK NVL2(\"{3}\", ST_GeometryTypeCode(\"{3}\") = {4,number,###} AND ST_CoordDim(\"{3}\") = {5,number,###} AND ST_SRID(\"{3}\") = {6,number,#####}, TRUE)", this.table().getSchema(), this.table().getName(), constraint_name, column.getName(), (Integer)H2SpatialSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype()), (Integer)H2SpatialSQLBuilder.this.sqlgeometrynumdimension(column.getGeometryType(), column.getGeometrySubtype()), (Integer)column.getGeometrySRSId()));
            return Collections.singletonList(sql);
        }
    }

    public class H2SpatialCreateIndexBuilder
    extends SQLBuilderBase.CreateIndexBuilderBase {
        public H2SpatialCreateIndexBuilder() {
            super((SQLBuilderBase)H2SpatialSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE ");
            if (this.isUnique) {
                builder.append("UNIQUE ");
            }
            if (this.isSpatial) {
                builder.append("SPATIAL ");
            }
            builder.append("INDEX ");
            if (this.ifNotExist) {
                builder.append("IF NOT EXISTS ");
            }
            builder.append(H2SpatialSQLBuilder.this.as_identifier(this.indexName));
            builder.append(" ON ");
            builder.append(this.table.toString(formatter));
            builder.append(" ( ");
            boolean is_first_column = true;
            for (String column : this.columns) {
                if (is_first_column) {
                    is_first_column = false;
                } else {
                    builder.append(", ");
                }
                builder.append(H2SpatialSQLBuilder.this.as_identifier(column));
            }
            builder.append(" )");
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(builder.toString());
            return sqls;
        }
    }

    public class H2SpatialTableNameBuilderBase
    extends SQLBuilderBase.TableNameBuilderBase {
        public H2SpatialTableNameBuilderBase() {
            super((SQLBuilderBase)H2SpatialSQLBuilder.this);
        }

        public boolean has_database() {
            return false;
        }
    }
}

