/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.store.h2.H2SpatialConnectionParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.H2Utils;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.h2.engine.Constants;
import org.h2.tools.Server;

public class H2SpatialUtils {
    public static final String NAME_H2SPATIAL_CONNECTION_CACHE_LIFETIME = "h2GlobalConnectionsLifetime";
    public static final int DEFAULT_VALUE_H2SPATIAL_CONNECTION_CACHE_LIFETIME = 60000;
    private static boolean enable_server = true;
    private static Server h2server = null;
    private static boolean startServer = true;
    private static boolean lastAllowOthers = true;
    private static String lastPort = "9123";
    private static Map<String, GlobalConnection> globalConnections;
    private static Timer timerCleanExpiredGlobalConnections;
    private static final Thread shutdownHook;

    public static File[] getH2Files(File f) {
        if (f == null) {
            return null;
        }
        String name = H2SpatialUtils.removeH2FileNameExtension(f.getName());
        File[] files = new File[62];
        files[0] = new File(f.getParentFile(), name + ".mv.db");
        files[1] = new File(f.getParentFile(), name + ".trace.db");
        for (int i = 2; i < files.length; ++i) {
            files[i] = new File(f.getParentFile(), name + ".mv.db." + (i - 1) + ".part");
        }
        return files;
    }

    public static boolean existsH2db(File f) {
        File[] files;
        for (File file : files = H2SpatialUtils.getH2Files(f)) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean removeH2db(File f) {
        try {
            File[] files;
            for (File file : files = H2SpatialUtils.getH2Files(f)) {
                if (!file.exists()) continue;
                FileUtils.delete((File)file);
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static File normalizeH2File(File f) {
        if (f == null) {
            return null;
        }
        f = new File(f.getParentFile(), H2SpatialUtils.normalizeH2FileName(f.getName()));
        return f;
    }

    public static String normalizeH2FileName(String name) {
        String s = H2SpatialUtils.removeH2FileNameExtension(name);
        if (s == null) {
            return null;
        }
        return s + ".mv.db";
    }

    public static String removeH2FileNameExtension(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.endsWith(".mv.db")) {
            int l = name.length();
            return name.substring(0, l - 6);
        }
        if (name.endsWith(".trace.db")) {
            int l = name.length();
            return name.substring(0, l - 9);
        }
        return FilenameUtils.removeExtension((String)name);
    }

    public static File getLocalFile(H2SpatialConnectionParameters params) {
        String host = params.getHost();
        if (!(StringUtils.isEmpty((CharSequence)host) || (host = host.toLowerCase().trim()).equals("localhost") || host.equals("127.0.0.1"))) {
            return null;
        }
        File f = params.getFile();
        return H2SpatialUtils.normalizeH2File(f);
    }

    public static String getConnectionURL(H2SpatialConnectionParameters params) {
        String dbfilename = params.getFile().getAbsolutePath().replace("\\", "/");
        if (dbfilename != null) {
            dbfilename = H2SpatialUtils.removeH2FileNameExtension(dbfilename);
        }
        StringBuilder commonParameters = new StringBuilder();
        commonParameters.append(";MODE=PostgreSQL");
        commonParameters.append(";SCHEMA=PUBLIC");
        commonParameters.append(";ALLOW_LITERALS=ALL");
        int splitSize = params.getSplitSize();
        String connectionURL = StringUtils.isEmpty((CharSequence)params.getHost()) ? (StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)params.getFile().getName()), (CharSequence)"zip") ? MessageFormat.format("jdbc:h2:zip:{0}!/{1}" + commonParameters.toString(), dbfilename, params.getDBName()) : (splitSize > 0 ? MessageFormat.format("jdbc:h2:split:{1,number,##}:{0}" + commonParameters.toString(), dbfilename, splitSize) : MessageFormat.format("jdbc:h2:file:{0}" + commonParameters.toString(), dbfilename))) : (params.getPort() == null ? (splitSize > 0 ? MessageFormat.format("jdbc:h2:tcp://{0}/split:{2,number,##}:/{1}" + commonParameters.toString(), params.getHost(), dbfilename, splitSize) : MessageFormat.format("jdbc:h2:tcp://{0}/{1}" + commonParameters.toString(), params.getHost(), dbfilename)) : (splitSize > 0 ? MessageFormat.format("jdbc:h2:tcp://{0}:{1,number,#######}/split:{3,number,##}:/{2}" + commonParameters.toString(), params.getHost(), params.getPort(), dbfilename, splitSize) : MessageFormat.format("jdbc:h2:tcp://{0}:{1,number,#######}/{2}" + commonParameters.toString(), params.getHost(), params.getPort(), dbfilename)));
        H2SpatialHelper.LOGGER.debug("connectionURL: {}", (Object)connectionURL);
        return connectionURL;
    }

    public static synchronized void server_stop() {
        H2SpatialUtils.closeGlobalConnections();
        if (h2server == null) {
            H2SpatialHelper.LOGGER.info("The H2 server is already stopped.");
        } else {
            H2SpatialHelper.LOGGER.info("Stopping the H2 server.");
            H2SpatialHelper.LOGGER.info("  port  :" + h2server.getPort());
            H2SpatialHelper.LOGGER.info("  URL   :" + h2server.getURL());
            H2SpatialHelper.LOGGER.info("  shutdown server...");
            try {
                h2server.shutdown();
            }
            catch (Throwable th) {
                H2SpatialHelper.LOGGER.warn("Problems shutdown the H2 server.", th);
            }
            H2SpatialHelper.LOGGER.info("  Stoping server...");
            try {
                h2server.stop();
            }
            catch (Throwable th) {
                H2SpatialHelper.LOGGER.warn("Problems stopping the H2 server.", th);
            }
            H2SpatialHelper.LOGGER.info("  status:" + h2server.getStatus());
            h2server = null;
            H2SpatialHelper.LOGGER.info("H2 Server stopped");
        }
        startServer = true;
    }

    public static void server_start() {
        H2SpatialUtils.server_start(lastPort, lastAllowOthers);
    }

    public static synchronized void server_start(String port, Boolean allowOthers) {
        if (!enable_server) {
            return;
        }
        if (startServer && h2server == null) {
            if (StringUtils.isBlank((CharSequence)port)) {
                port = lastPort;
            }
            if (allowOthers == null) {
                allowOthers = lastAllowOthers;
            }
            try {
                Server theH2Server = allowOthers != false ? Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-ifExists", "-tcpAllowOthers"}) : Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-ifExists"});
                theH2Server.start();
                h2server = theH2Server;
                H2SpatialHelper.LOGGER.info("H2 Server started");
                H2SpatialHelper.LOGGER.info("  Engine version : h2 " + Constants.getFullVersion() + ", h2gis " + H2Utils.getH2GisVersion());
                H2SpatialHelper.LOGGER.info("  Connection url : jdbc:h2:" + h2server.getURL() + "/ABSOLUTE_DATABASE_PATH;MODE=PostgreSQL;SCHEMA=PUBLIC;ALLOW_LITERALS=ALL");
                H2SpatialHelper.LOGGER.info("  status:" + h2server.getStatus());
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                lastPort = port;
                lastAllowOthers = allowOthers;
            }
            catch (SQLException ex) {
                H2SpatialHelper.LOGGER.warn("H2 Server not started", (Throwable)ex);
            }
            startServer = false;
        }
    }

    public static void set_enable_server(boolean enable) {
        enable_server = enable;
    }

    public static void set_server_port(int port) {
        lastPort = Integer.toString(port);
    }

    public static boolean is_enable_server() {
        return enable_server;
    }

    public static synchronized boolean is_server_started() {
        return h2server != null;
    }

    public static synchronized void addGlobalConnection(ConnectionProvider connectionProvider) {
        try {
            if (globalConnections == null) {
                DataManager dataManager = DALLocator.getDataManager();
                String h2GlobalConnectionsLifetime_s = Objects.toString(dataManager.getProperty(NAME_H2SPATIAL_CONNECTION_CACHE_LIFETIME), null);
                final MutableInt h2GlobalConnectionsLifetime = new MutableInt(60000);
                try {
                    h2GlobalConnectionsLifetime.setValue(Integer.parseInt(h2GlobalConnectionsLifetime_s));
                }
                catch (NumberFormatException ex) {
                    h2GlobalConnectionsLifetime.setValue(60000);
                }
                globalConnections = new HashMap<String, GlobalConnection>();
                if (h2GlobalConnectionsLifetime.getValue() > 0) {
                    timerCleanExpiredGlobalConnections = new Timer("CleanGlobalConnections", true);
                    timerCleanExpiredGlobalConnections.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            H2SpatialUtils.cleanExpiredConnections(h2GlobalConnectionsLifetime.getValue());
                        }
                    }, h2GlobalConnectionsLifetime.getValue().intValue(), (long)Math.max(h2GlobalConnectionsLifetime.getValue(), 10000));
                }
            }
            if (!(connectionProvider instanceof H2SpatialHelper.H2SpatialConnectionProvider)) {
                return;
            }
            H2SpatialConnectionParameters connectionParameters = ((H2SpatialHelper.H2SpatialConnectionProvider)connectionProvider).getConnectionParameters();
            if (!connectionParameters.getMaintainGlobalConnection()) {
                return;
            }
            String connectionProviderKey = H2SpatialUtils.getConnectionProviderKey(connectionParameters);
            GlobalConnection gc = globalConnections.get(connectionProviderKey);
            if (gc != null) {
                return;
            }
            Connection x = connectionProvider.getConnection();
            globalConnections.put(connectionProviderKey, new GlobalConnection(connectionProviderKey, x));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't add global connection.", e);
        }
    }

    public static String getConnectionProviderKey(JDBCConnectionParameters connectionParameters) {
        String pass = Hex.encodeHexString((byte[])(connectionParameters.getPassword() + "").getBytes());
        return connectionParameters.getUrl() + ";user:" + connectionParameters.getUser() + "@" + pass;
    }

    public static synchronized void closeGlobalConnections() {
        if (globalConnections == null) {
            return;
        }
        for (GlobalConnection globalCon : globalConnections.values()) {
            H2SpatialHelper.LOGGER.info("Clossing connection " + JDBCUtils.getConnId((Connection)globalCon.getConnection()));
            JDBCUtils.closeQuietly((Connection)globalCon.getConnection());
        }
        globalConnections = new HashMap<String, GlobalConnection>();
    }

    static void useConnection(ConnectionProvider connectionProvider, H2SpatialConnectionParameters connectionParameters) {
        if (globalConnections == null) {
            try {
                throw new IllegalStateException("globalConnections is null");
            }
            catch (Exception ex) {
                H2SpatialHelper.LOGGER.warn("globalConnections is null", (Throwable)ex);
                return;
            }
        }
        try {
            String connectionProviderKey = H2SpatialUtils.getConnectionProviderKey(connectionParameters);
            GlobalConnection x = globalConnections.get(connectionProviderKey);
            if (x == null) {
                if (connectionProvider != null) {
                    H2SpatialUtils.addGlobalConnection(connectionProvider);
                }
                return;
            }
            x.use();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't mark connection as used.", e);
        }
    }

    static void cleanExpiredConnections(int msLifetime) {
        if (globalConnections == null) {
            return;
        }
        ArrayList<GlobalConnection> expired = new ArrayList<GlobalConnection>();
        for (GlobalConnection globalConnection : globalConnections.values()) {
            if (!globalConnection.isExpired(msLifetime)) continue;
            expired.add(globalConnection);
        }
        for (GlobalConnection globalConnection : expired) {
            JDBCUtils.closeQuietly((Connection)globalConnection.getConnection());
            globalConnections.remove(globalConnection.getKey());
        }
    }

    static {
        shutdownHook = new Thread("H2_shutdown_hook"){

            @Override
            public void run() {
                H2SpatialUtils.server_stop();
            }
        };
    }

    private static class GlobalConnection {
        private final String key;
        private final Connection conn;
        private long lastUsage;

        public GlobalConnection(String key, Connection conn) {
            this.key = key;
            this.conn = conn;
            this.lastUsage = System.currentTimeMillis();
        }

        public void use() {
            this.lastUsage = System.currentTimeMillis();
        }

        public boolean isExpired(long ms) {
            return System.currentTimeMillis() - this.lastUsage > ms;
        }

        public String getKey() {
            return this.key;
        }

        private Connection getConnection() {
            return this.conn;
        }
    }
}

