/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.h2spatial.H2SpatialPreferencesPage;
import org.gvsig.h2spatial.ImportTable;
import org.gvsig.h2spatial.ShutdownCompact;
import org.gvsig.h2spatial.backup.Backup;
import org.gvsig.h2spatial.restore.Restore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.webbrowser.WebBrowserFactory;
import org.gvsig.webbrowser.WebBrowserPanel;
import org.h2.tools.Server;

public class H2SpatialExtension
extends Extension
implements IPreferenceExtension {
    public static String DAL_EXPLORER_NAME = "H2Spatial";

    public void initialize() {
    }

    public boolean canQueryByAction() {
        return true;
    }

    public void postInitialize() {
        MapContextManager mapContextMgr = MapContextLocator.getMapContextManager();
        IconThemeHelper.registerIcon((String)"preferences", (String)"preferences-h2spatialprovider", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-h2", (Object)((Object)this));
        mapContextMgr.registerIconLayer("H2Spatial", "layer-icon-h2");
    }

    public void execute(String actionCommand) {
        switch (actionCommand.toLowerCase()) {
            case "tools-h2spatial-show-admintool": {
                this.startserver();
                this.startbrowser();
                break;
            }
            case "tools-h2spatial-linklayer": {
                this.linkActiveLayers();
                break;
            }
            case "tools-h2spatial-import": {
                this.importTables();
                break;
            }
            case "tools-h2spatial-downloadosm": {
                this.downloadOSM();
                break;
            }
            case "tools-h2spatial-shutdownserver": {
                this.shutdownserver();
                break;
            }
            case "tools-h2spatial-backup": {
                this.backup();
                break;
            }
            case "tools-h2spatial-restore": {
                this.restore();
                break;
            }
            case "tools-h2spatial-shutdowndatabase": {
                this.shutdownDatabase();
            }
        }
    }

    private void shutdownDatabase() {
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        ShutdownCompact panel = new ShutdownCompact();
        Dialog dialog = winmanager.createDialog((JComponent)panel, "Shutdown and compact database", null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                panel.shutdownAndCompact();
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    private void shutdownserver() {
        try {
            DataManager dataManager = DALLocator.getManager();
            DataServerExplorerParameters params = dataManager.createServerExplorerParameters(DAL_EXPLORER_NAME);
            JDBCServerExplorer server = (JDBCServerExplorer)dataManager.openServerExplorer(DAL_EXPLORER_NAME, params);
            server.execute("!SHUTDOWN");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startserver() {
        try {
            Server server = Server.createWebServer((String[])new String[]{"-webPort", "8082"});
            server.start();
        }
        catch (SQLException ex) {
            if (ex.getCause() instanceof BindException) {
                logger.warn("Can't start H2 web server, \u00bf Already running ?");
            }
            logger.warn("Can't start H2 web server.", (Throwable)ex);
        }
    }

    private List<FLyrVect> getSelectedLayers() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return null;
        }
        Object[] layers = viewdoc.getMapContext().getLayers().getActives();
        if (ArrayUtils.isEmpty((Object[])layers)) {
            return null;
        }
        ArrayList<FLyrVect> r = new ArrayList<FLyrVect>();
        for (Object layer : layers) {
            FeatureStore store;
            if (!(layer instanceof FLyrVect) || (store = ((FLyrVect)layer).getFeatureStore()) == null || !(store.getParameters() instanceof FilesystemStoreParameters) || !StringUtils.equalsIgnoreCase((CharSequence)store.getProviderName(), (CharSequence)"Shape")) continue;
            r.add((FLyrVect)layer);
        }
        if (r.isEmpty()) {
            return null;
        }
        return r;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isEnabled(String action) {
        ApplicationManager application = ApplicationLocator.getManager();
        switch (action.toLowerCase()) {
            case "tools-h2spatial-show-admintool": {
                return true;
            }
            case "tools-h2spatial-linklayer": {
                return !CollectionUtils.isEmpty(this.getSelectedLayers());
            }
            case "tools-h2spatial-import": {
                return true;
            }
            case "tools-h2spatial-downloadosm": {
                ViewDocument viewDoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
                if (viewDoc == null) {
                    return false;
                }
                Envelope env = viewDoc.getMapContext().getViewPort().getEnvelope();
                return env == null || !env.isEmpty();
            }
            case "tools-h2spatial-shutdownserver": {
                return true;
            }
            case "tools-h2spatial-backup": {
                return true;
            }
            case "tools-h2spatial-restore": {
                return true;
            }
            case "tools-h2spatial-shutdowndatabase": {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible(String action) {
        return true;
    }

    private void startbrowser() {
        try {
            WindowManager winmanager = ToolsSwingLocator.getWindowManager();
            WebBrowserPanel webbrowser = WebBrowserFactory.createWebBrowserPanel();
            winmanager.showWindow(webbrowser.asJComponent(), ToolsLocator.getI18nManager().getTranslation("_H2_administration_tool"), WindowManager.MODE.WINDOW);
            webbrowser.setPage("http://localhost:8082");
            return;
        }
        catch (Throwable t) {
            logger.warn("Can't launch embedded web browser", t);
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            int res = dialogs.confirmDialog(i18n.getTranslation("_Unable_to_start_the_builtin_internal_browser_Do_you_want_to_try_opening_the_system_browser"), i18n.getTranslation("_H2_administration_tool"), 0, 2, "_Show_H2_administration_tool_with_external_browser");
            if (res != 0) {
                return;
            }
            try {
                DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
                desktop.browse(new URI("http://localhost:8082"));
            }
            catch (URISyntaxException ex) {
                logger.warn("Can't launch external web browser", (Throwable)ex);
            }
            return;
        }
    }

    private void importTables() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        ImportTable panel = new ImportTable();
        Dialog dlg = winmanager.createDialog((JComponent)panel, i18n.getTranslation("_Select_files_to_import"), i18n.getTranslation("_Select_files_to_import_as_tables_in_H2_database"), 3);
        dlg.addActionListener(e -> {
            if (dlg.getAction() == 1) {
                this.doImportTables(panel.getExplorerParameters(), panel.getFileType(), panel.getFile(), panel.getTableName(), panel.getDeleteTables());
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void doImportTables(JDBCServerExplorerParameters explorerParameters, String fileType, File file, String tableName, boolean deleteTables) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        StringBuilder sql = new StringBuilder();
        switch (fileType.toLowerCase()) {
            case "gpx": {
                sql.append("CALL GPXRead('");
                sql.append(file.getAbsolutePath());
                sql.append("', '");
                sql.append(tableName);
                sql.append("');");
                break;
            }
            case "geojson": {
                sql.append("CALL GeoJsonRead('");
                sql.append(file.getAbsolutePath());
                sql.append("', '");
                sql.append(tableName);
                sql.append("');");
                break;
            }
            case "osm": {
                sql.append("CALL OSMRead('");
                sql.append(file.getAbsolutePath());
                sql.append("', '");
                sql.append(tableName);
                sql.append("', ");
                sql.append(BooleanUtils.toStringTrueFalse((boolean)deleteTables));
                sql.append(");");
                break;
            }
            default: {
                return;
            }
        }
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParameters.getExplorerName(), (DataServerExplorerParameters)explorerParameters);
            explorer.execute(sql.toString());
        }
        catch (Exception ex) {
            logger.warn("Can't import file.", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Cant_import_file.") + "\n" + i18n.getTranslation("_See_the_log_file_to_more_information"), i18n.getTranslation("_Warning"), 2);
        }
    }

    private void linkActiveLayers() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        List<FLyrVect> layers = this.getSelectedLayers();
        if (CollectionUtils.isEmpty(layers)) {
            return;
        }
        JDBCConnectionPanel jdbcConnectionPanel = DALSwingLocator.getSwingManager().createJDBCConnectionPanel();
        jdbcConnectionPanel.setConnectorFilter(parameters -> StringUtils.equalsIgnoreCase((CharSequence)parameters.getExplorerName(), (CharSequence)DAL_EXPLORER_NAME));
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dlg = winmanager.createDialog(jdbcConnectionPanel.asJComponent(), i18n.getTranslation("_Select_database"), null, 3);
        dlg.addActionListener(e -> {
            if (dlg.getAction() == 1) {
                JDBCServerExplorerParameters params = jdbcConnectionPanel.getServerExplorerParametersAndRegister();
                this.linkLayers(layers, params);
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void linkLayers(List<FLyrVect> layers, JDBCServerExplorerParameters params) {
        try {
            JDBCServerExplorer explorer = (JDBCServerExplorer)DALLocator.getDataManager().openServerExplorer(params.getExplorerName(), (DataServerExplorerParameters)params);
            for (FLyrVect layer : layers) {
                FilesystemStoreParameters layerParameters = (FilesystemStoreParameters)layer.getFeatureStore().getParameters();
                File f = layerParameters.getFile();
                String sql = MessageFormat.format("CALL FILE_TABLE(''{0}'', ''{1}'')", FilenameUtils.normalize((String)f.getAbsolutePath(), (boolean)true), layer.getName());
                explorer.execute(sql);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void downloadOSM() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewDoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewDoc == null) {
            return;
        }
        Envelope env = viewDoc.getMapContext().getViewPort().getEnvelope();
        Object[] files = application.showChooserDialog(i18n.getTranslation("_Select_the_file_in_which_to_save_the_data"), 1, 0, false, foldersManager.get("DataFolder"), (FileFilter)new FileNameExtensionFilter("OSM File (.osm, .osm.gz, .osm.bz2)", ".osm", ".osm.gz", ".osm.bz2"), false);
        if (!ArrayUtils.isEmpty((Object[])files)) {
            JDBCConnectionPanel jdbcConnectionPanel = DALSwingLocator.getSwingManager().createJDBCConnectionPanel();
            jdbcConnectionPanel.setConnectorFilter(parameters -> StringUtils.equalsIgnoreCase((CharSequence)parameters.getExplorerName(), (CharSequence)DAL_EXPLORER_NAME));
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dlg = winmanager.createDialog(jdbcConnectionPanel.asJComponent(), i18n.getTranslation("_Select_database"), null, 3);
            dlg.addActionListener(arg_0 -> this.lambda$downloadOSM$5(dlg, env, (File[])files, jdbcConnectionPanel, arg_0));
            dlg.show(WindowManager.MODE.WINDOW);
        }
    }

    private void doDownloadOSM(Envelope env, File f, JDBCServerExplorerParameters explorerParameters) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        try {
            String sql = MessageFormat.format("CALL ST_OSMDownloader(''{0}''::geometry, ''{1}'');", env.getGeometry().convertToWKT(), f.getAbsolutePath());
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParameters.getExplorerName(), (DataServerExplorerParameters)explorerParameters);
            explorer.execute(sql);
        }
        catch (Exception ex) {
            logger.warn("Can't download from OSM.", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Cant_download_from_OSM.") + "\n" + i18n.getTranslation("_See_the_log_file_to_more_information"), i18n.getTranslation("_Warning"), 2);
        }
    }

    private void backup() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Backup panel = new Backup();
        Dialog dlg = winmanager.createDialog((JComponent)panel, i18n.getTranslation("_Backup"), i18n.getTranslation("_Backup_H2_database"), 3);
        dlg.addActionListener(e -> {
            if (dlg.getAction() == 1) {
                panel.createBackup();
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void restore() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Restore panel = new Restore();
        Dialog dlg = winmanager.createDialog((JComponent)panel, i18n.getTranslation("_Restore"), i18n.getTranslation("_Restore_H2_database"), 3);
        dlg.addActionListener(e -> {
            if (dlg.getAction() == 1) {
                panel.restoreBackup();
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    public IPreference[] getPreferencesPages() {
        return new IPreference[]{new H2SpatialPreferencesPage()};
    }

    private /* synthetic */ void lambda$downloadOSM$5(Dialog dlg, Envelope env, File[] files, JDBCConnectionPanel jdbcConnectionPanel, ActionEvent e) {
        if (dlg.getAction() == 1) {
            this.doDownloadOSM(env, files[0], jdbcConnectionPanel.getServerExplorerParametersAndRegister());
        }
    }
}

