/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.wfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorerParameters;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.wfs.WFSFeatureFiller;
import org.gvsig.fmap.dal.store.wfs.WFSOpenStoreParameters;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProvider;
import org.gvsig.remoteclient.wfs.WFSClient;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.xmlschema.lib.api.exceptions.SchemaCreationException;

public class WFSServerExplorer
extends AbstractDataServerExplorer
implements DataServerExplorerProvider {
    public static final String NAME = "WFSServerExplorer";
    private DataManager dataManager = DALLocator.getDataManager();
    private String url = null;
    private WFSStatus status = null;
    private WFSClient wfsClient = null;

    public WFSServerExplorer(WFSServerExplorerParameters parameters, DataServerExplorerProviderServices services) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
        this.url = parameters.getUrl();
        if (this.wfsClient == null) {
            try {
                this.wfsClient = new WFSClient(this.url, parameters.getIgnoreChace());
                if (this.status == null) {
                    this.status = new WFSStatus(null);
                }
                this.wfsClient.getCapabilities(this.status, parameters.getIgnoreChace(), null);
            }
            catch (ConnectException e) {
                throw new InitializeException("Not possible to connect with " + this.url, (Throwable)e);
            }
            catch (IOException e) {
                throw new InitializeException("Not possible to connect with " + this.url, (Throwable)e);
            }
            catch (WFSException e) {
                throw new InitializeException("Not possible to connect with " + this.url, (Throwable)e);
            }
        }
    }

    public WFSFeature getFeatureInfo(String nameSpace, String layerName) throws WFSException {
        this.status = new WFSStatus(layerName, nameSpace);
        WFSFeature feature = this.wfsClient.getFeature(nameSpace, layerName);
        if (!feature.isCompleted()) {
            File describeFeatureTypeFile = this.wfsClient.describeFeatureType(this.status, this.getParameters().getIgnoreChace(), null);
            WFSFeatureFiller featureFiller = new WFSFeatureFiller(feature);
            try {
                featureFiller.fill(describeFeatureTypeFile);
            }
            catch (SchemaCreationException e) {
                throw new WFSException(e);
            }
            catch (FileNotFoundException e) {
                throw new WFSException(e);
            }
        }
        return feature;
    }

    public Hashtable getFeatures() {
        return this.wfsClient.getFeatures();
    }

    public boolean add(String providerName, NewDataStoreParameters parameters, boolean overwrite) throws DataException {
        return false;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAdd(String storeName) throws DataException {
        return false;
    }

    protected void doDispose() throws BaseException {
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        return null;
    }

    public String getProviderName() {
        return NAME;
    }

    public WFSServerExplorerParameters getParameters() {
        return (WFSServerExplorerParameters)super.getParameters();
    }

    public List list() throws DataException {
        ArrayList<DataStoreParameters> list = new ArrayList<DataStoreParameters>();
        Hashtable features = this.wfsClient.getFeatures();
        Iterator it = features.keySet().iterator();
        Object dsp = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            WFSFeature feature = (WFSFeature)features.get(key);
            list.add(this.getParametersFor(feature));
        }
        return list;
    }

    public DataStoreParameters getParametersFor(WFSFeature feature) throws DataException {
        WFSOpenStoreParameters params = (WFSOpenStoreParameters)this.dataManager.createStoreParameters(WFSStoreProvider.NAME);
        params.setUrl(this.url);
        params.setFeatureType(feature.getNamespace().getPrefix(), feature.getNamespace().getLocation(), feature.getName());
        return params;
    }

    public List list(int mode) throws DataException {
        return this.list();
    }

    public void remove(DataStoreParameters parameters) throws DataException {
    }

    public DataServerExplorerProviderServices getServerExplorerProviderServices() {
        return null;
    }

    public void initialize(DataServerExplorerProviderServices dataServerExplorerProviderServices) {
    }

    public String getTitle() {
        String title = this.wfsClient.getServiceInformation().title;
        if (title == null) {
            return "None";
        }
        return title;
    }

    public String getAbstract() {
        String _abstract = this.wfsClient.getServiceInformation().abstr;
        if (_abstract == null) {
            return "None";
        }
        return _abstract;
    }

    public String getServerType() {
        String serverVersion = this.wfsClient.getVersion();
        if (serverVersion == null) {
            return "WFS";
        }
        return "WFS " + serverVersion;
    }

    public String getUrl() {
        return this.wfsClient.getHost();
    }

    public int getMaxFeatures() {
        return this.status.getMaxFeatures();
    }

    public int getTimeOut() {
        return this.status.getTimeout();
    }

    public void setUserName(String userName) {
        this.status.setUserName(userName);
    }

    public void setMaxFeatures(int buffer) {
        this.status.setMaxFeatures(buffer);
    }

    public void setTimeOut(int timeout) {
        this.status.setTimeout(timeout);
    }

    public String getVersion() {
        return this.wfsClient.getVersion();
    }

    public List getDataStoreProviderNames() {
        ArrayList<String> x = new ArrayList<String>();
        x.add(WFSStoreProvider.NAME);
        return x;
    }
}

