/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.wfs;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.gpe.GPEStoreParameters;
import org.gvsig.fmap.dal.store.gpe.GPEStoreProvider;
import org.gvsig.fmap.dal.store.wfs.WFSOpenStoreParameters;
import org.gvsig.fmap.dal.store.wfs.WFSTTRansactionException;
import org.gvsig.fmap.dal.store.wfs.WFSTTransactionBuilder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerCreationException;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wfs.WFSClient;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequestInformation;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequestInformation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.xmlschema.lib.api.XMLSchemaLocator;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.gvsig.xmlschema.lib.api.som.IXSGeometryTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSStoreProvider
extends AbstractFeatureStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(WFSStoreProvider.class);
    public static String NAME = "WFSStore";
    public static String DESCRIPTION = "WFS store to load WFS resources";
    private static final MetadataManager metadataManager = MetadataLocator.getMetadataManager();
    private static final String METADATA_DEFINITION_NAME = "WFSStore";
    private static final String METADATA_DEFINITION_DESCRIPTION = "WFSStore metadata definition";
    private long featureCount = -1L;
    private boolean isKnownEnvelope = false;
    private boolean hasFilterByArea = false;
    private GPEStoreProvider storeProviderDelegate = null;
    private static final XMLSchemaManager xmlSchemaManager = XMLSchemaLocator.getXMLSchemaManager();
    boolean isFilterByAreaSupported = true;
    private WFSClient wfsClient;
    private WFSStatus wfsStatus;

    public WFSStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super(params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(metadataManager.getDefinition(METADATA_DEFINITION_NAME)));
        try {
            this.initParams();
            this.initFeatureType();
        }
        catch (ReadException | WFSException e) {
            throw new InitializeException(e);
        }
    }

    private void initParams() throws InitializeException {
        try {
            Envelope envelope;
            String nameSpace;
            WFSOpenStoreParameters wfsParameters = this.getWFSParameters();
            try {
                if (wfsParameters.getVersion() == null) {
                    this.wfsClient = new WFSClient(wfsParameters.getUrl(), wfsParameters.getIgnoreCache());
                    wfsParameters.setVersion(this.wfsClient.getVersion());
                } else {
                    this.wfsClient = new WFSClient(wfsParameters.getUrl(), wfsParameters.getVersion(), wfsParameters.getIgnoreCache());
                }
            }
            catch (IOException e) {
                throw new InitializeException((Throwable)e);
            }
            this.wfsStatus = new WFSStatus(wfsParameters.getFeatureType(), wfsParameters.getFeatureNamespace());
            this.wfsStatus.setNamespacePrefix(wfsParameters.getFeaturePrefix());
            this.wfsStatus.setFields(wfsParameters.getFields());
            Geometry filterByAreaGeometry = wfsParameters.getFilterByAreaGeometry();
            Envelope filterByAreaEnvelope = wfsParameters.getFilterByAreaEnvelope();
            if (filterByAreaGeometry != null) {
                this.wfsStatus.setFilterByArea(filterByAreaGeometry, wfsParameters.getFilterByAreaAttribute(), wfsParameters.getFilterByAreaCrs().getFullCode(), wfsParameters.getFilterByAreaOperation());
            } else if (filterByAreaEnvelope != null) {
                this.wfsStatus.setFilterByArea(filterByAreaEnvelope, wfsParameters.getFilterByAreaAttribute(), wfsParameters.getFilterByAreaCrs().getFullCode(), wfsParameters.getFilterByAreaOperation());
            }
            this.hasFilterByArea = this.wfsStatus.getFilterByArea() != null;
            this.wfsStatus.setFilterByAttribute(wfsParameters.getFilterEncodingByAttribute());
            String _srs = wfsParameters.getCrs();
            this.wfsStatus.setSrs(_srs);
            this.wfsStatus.setTimeout(wfsParameters.getTimeOut());
            this.wfsStatus.setMaxFeatures(wfsParameters.getMaxFeatures());
            this.wfsStatus.setUserName(wfsParameters.getUser());
            this.wfsStatus.setPassword(wfsParameters.getPassword());
            this.wfsClient.getCapabilities(this.wfsStatus, false, null);
            if (StringUtils.isBlank((CharSequence)wfsParameters.getFeatureNamespace()) && StringUtils.isNotBlank((CharSequence)(nameSpace = this.wfsClient.findNameSpace(wfsParameters.getFeatureType())))) {
                wfsParameters.setFeatureNamespace(nameSpace);
            }
            if ((envelope = this.calculateFullEnvelope()) != null) {
                this.setDynValue("Envelope", envelope);
                this.isKnownEnvelope = true;
            }
        }
        catch (WFSException e) {
            throw new InitializeException("Can't initialize WFS parameters", (Throwable)e);
        }
    }

    private WFSFeature getSelectedWFSFeature() throws ReadException, WFSException {
        WFSOpenStoreParameters wfsParameters = this.getWFSParameters();
        return ((WFSServerExplorer)this.getExplorer()).getFeatureInfo(wfsParameters.getFeatureNamespace(), wfsParameters.getFeatureType());
    }

    private void initFeatureType() throws WFSException, ReadException {
        WFSFeature feature = this.getSelectedWFSFeature();
        if (feature == null) {
            throw new WFSException("It is not possible to parse the schema");
        }
        IProjection ipro = null;
        try {
            ipro = CRSFactory.getCRS((String)this.wfsStatus.getSrs());
            this.setDynValue("CRS", ipro);
        }
        catch (Exception ex) {
            logger.info("Error: did not set CRS in store provider.", (Throwable)ex);
        }
        EditableFeatureType featureType = this.getStoreServices().createFeatureType();
        for (int i = 0; i < feature.getFieldSize(); ++i) {
            WFSFeatureField featureField = feature.getFieldAt(i);
            int dataType = 8;
            String typeName = featureField.getType();
            EditableFeatureAttributeDescriptor attributeDescriptor = null;
            IXSTypeDefinition typeDefinition = null;
            if (typeName != null) {
                typeDefinition = xmlSchemaManager.getTypeDefinition(typeName);
            }
            if (typeDefinition != null) {
                if (typeDefinition.getDataType() != null) {
                    dataType = typeDefinition.getDataType().getType();
                }
                attributeDescriptor = featureType.add(featureField.getName(), dataType);
                if (typeDefinition instanceof IXSGeometryTypeDefinition) {
                    if (ipro != null) {
                        attributeDescriptor.setSRS(ipro);
                    } else if (!feature.getSrs().isEmpty()) {
                        attributeDescriptor.setSRS(CRSFactory.getCRS((String)((String)feature.getSrs().get(0))));
                    } else {
                        logger.info("Unable to set CRS in feature type.");
                    }
                    attributeDescriptor.setGeometryType(((IXSGeometryTypeDefinition)typeDefinition).getGeometryType());
                    attributeDescriptor.setGeometrySubType(1);
                    featureType.setDefaultGeometryAttributeName(featureField.getName());
                }
            } else {
                attributeDescriptor = featureType.add(typeName, dataType);
            }
            attributeDescriptor.setSize(128);
        }
        featureType.setHasOID(true);
        FeatureType defaultType = featureType.getNotEditableCopy();
        ArrayList<FeatureType> types = new ArrayList<FeatureType>(1);
        types.add(defaultType);
        this.getStoreServices().setFeatureTypes(types, defaultType);
    }

    private Envelope calculateFullEnvelope() throws WFSException {
        block8: {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            try {
                WFSFeature feature = this.getSelectedWFSFeature();
                if (feature == null) break block8;
                String _srs = this.wfsStatus.getSrs();
                if (_srs != null) {
                    BoundaryBox boundaryBox = feature.getBbox(_srs);
                    if (boundaryBox != null) {
                        return geometryManager.createEnvelope(boundaryBox.getXmin(), boundaryBox.getYmin(), boundaryBox.getXmax(), boundaryBox.getYmax(), 0);
                    }
                    boundaryBox = feature.getLatLonBbox();
                    if (boundaryBox != null) {
                        Envelope envelope = geometryManager.createEnvelope(boundaryBox.getXmin(), boundaryBox.getYmin(), boundaryBox.getXmax(), boundaryBox.getYmax(), 0);
                        if (!"EPSG:4326".equals(_srs)) {
                            IProjection sourceProjection = CRSFactory.getCRS((String)"EPSG:4326");
                            IProjection destinationProjection = CRSFactory.getCRS((String)_srs);
                            if (destinationProjection != null) {
                                ICoordTrans coordTrans = sourceProjection.getCT(destinationProjection);
                                return envelope.convert(coordTrans);
                            }
                        }
                    }
                    break block8;
                }
                int odlMaxFeatures = this.wfsStatus.getMaxFeatures();
                this.wfsStatus.setMaxFeatures(500);
                this.createSet(null, null);
                return this.storeProviderDelegate.getEnvelope();
            }
            catch (WFSException e) {
                throw e;
            }
            catch (DataException | CreateEnvelopeException e) {
                throw new WFSException("Impossible to create an envelope", e);
            }
        }
        return null;
    }

    private WFSOpenStoreParameters getWFSParameters() {
        return (WFSOpenStoreParameters)this.getParameters();
    }

    public void open() throws OpenException {
        try {
            List featureTypes = this.getFeatureStore().getFeatureTypes();
            for (int i = 0; i < featureTypes.size(); ++i) {
                FeatureType featureType = (FeatureType)featureTypes.get(i);
            }
        }
        catch (DataException e) {
            throw new OpenException("Reading the geometry type", (Throwable)e);
        }
    }

    protected static void registerMetadataDefinition() throws MetadataException {
        if (metadataManager.getDefinition(METADATA_DEFINITION_NAME) == null) {
            DynStruct metadataDefinition = metadataManager.addDefinition(METADATA_DEFINITION_NAME, METADATA_DEFINITION_DESCRIPTION);
            metadataDefinition.addDynFieldObject("Envelope").setClassOfValue(Envelope.class).setMandatory(false);
            metadataDefinition.addDynFieldObject("CRS").setClassOfValue(IProjection.class).setMandatory(true);
            metadataDefinition.extend(metadataManager.getDefinition("FeatureStore"));
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            WFSServerExplorerParameters params = (WFSServerExplorerParameters)manager.createServerExplorerParameters("WFSServerExplorer");
            params.setUrl(this.wfsClient.getHost());
            return manager.openServerExplorer("WFSServerExplorer", (DataServerExplorerParameters)params);
        }
        catch (Exception e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
    }

    public String getProviderName() {
        return NAME;
    }

    public FeatureSetProvider createSet(FeatureQuery query) throws DataException {
        return this.createSet(query, null);
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        if (this.featureCount == -1L || this.storeProviderDelegate == null || this.featureCount >= (long)this.wfsStatus.getMaxFeatures().intValue()) {
            File file = this.executeSpatialQuery();
            this.storeProviderDelegate = this.createProvider(file);
        }
        return this.storeProviderDelegate.createSet(query, featureType);
    }

    private GPEStoreProvider createProvider(File file) throws InitializeException, ProviderNotRegisteredException {
        return new GPEStoreProvider(this.createStoreParameters(file), (DataStoreProviderServices)this.getStoreServices());
    }

    private DataStoreParameters createStoreParameters(File file) throws InitializeException, ProviderNotRegisteredException {
        GPEStoreParameters parameters = new GPEStoreParameters();
        parameters.setDynValue("File", (Object)file.getAbsolutePath());
        parameters.setDynValue("Envelope", this.getDynValue("Envelope"));
        parameters.setDynValue("useAxisOrderYX", (Object)this.getWFSParameters().getUseAxisOrderYX());
        parameters.setDynValue("Crs", (Object)this.getWFSParameters().getCrs());
        return parameters;
    }

    private File executeSpatialQuery() throws DataException {
        try {
            Envelope filterByAreaEnvelope = this.getWFSParameters().getFilterByAreaEnvelope();
            Geometry filterByAreaGeometry = this.getWFSParameters().getFilterByAreaGeometry();
            if (filterByAreaEnvelope != null) {
                Envelope envelope;
                String crs = this.getWFSParameters().getCrs();
                String the_geom = this.getWFSParameters().getFilterByAreaAttribute();
                int operator = this.getWFSParameters().getFilterByAreaOperation();
                IProjection envelopeCrs = this.getWFSParameters().getFilterByAreaCrs();
                if (!crs.equalsIgnoreCase(envelopeCrs.getFullCode())) {
                    envelope = null;
                    try {
                        envelope = (Envelope)filterByAreaEnvelope.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        logger.warn("Can't clone envelope", (Throwable)e);
                    }
                    ICoordTrans ct = envelopeCrs.getCT(CRSFactory.getCRS((String)crs));
                    filterByAreaEnvelope = envelope.convert(ct);
                }
                if (this.getWFSParameters().getUseAxisOrderYX()) {
                    envelope = null;
                    try {
                        envelope = (Envelope)filterByAreaEnvelope.clone();
                    }
                    catch (CloneNotSupportedException ct) {
                        // empty catch block
                    }
                    double x = envelope.getLowerCorner().getX();
                    envelope.getLowerCorner().setX(envelope.getLowerCorner().getY());
                    envelope.getLowerCorner().setY(x);
                    x = envelope.getUpperCorner().getX();
                    envelope.getUpperCorner().setX(envelope.getUpperCorner().getY());
                    envelope.getUpperCorner().setY(x);
                    filterByAreaEnvelope = envelope;
                }
                this.wfsStatus.setFilterByArea(filterByAreaEnvelope, the_geom, crs, (Integer)operator);
            } else if (filterByAreaGeometry != null) {
                Geometry geom;
                String crs = this.getWFSParameters().getCrs();
                String the_geom = this.getWFSParameters().getFilterByAreaAttribute();
                int operator = this.getWFSParameters().getFilterByAreaOperation();
                IProjection geometryCrs = this.getWFSParameters().getFilterByAreaCrs();
                if (!crs.equalsIgnoreCase(geometryCrs.getFullCode())) {
                    geom = filterByAreaGeometry.cloneGeometry();
                    ICoordTrans ct = geometryCrs.getCT(CRSFactory.getCRS((String)crs));
                    geom.reProject(ct);
                    filterByAreaGeometry = geom;
                }
                if (this.getWFSParameters().getUseAxisOrderYX()) {
                    geom = filterByAreaGeometry.cloneGeometry();
                    AffineTransform at = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
                    geom.transform(at);
                    filterByAreaGeometry = geom;
                }
                this.wfsStatus.setFilterByArea(filterByAreaGeometry, the_geom, crs, (Integer)operator);
            }
            this.wfsStatus.setProtocol(1);
            this.wfsStatus.setResultType(0);
            return this.wfsClient.getFeature(this.wfsStatus, this.getWFSParameters().getIgnoreCache(), null);
        }
        catch (WFSException e) {
            throw new InitializeException("Can't execute WFS query", (Throwable)e);
        }
    }

    public Object getSourceId() {
        StringBuilder sourceID = new StringBuilder(this.getWFSParameters().getUrl());
        sourceID.append("_");
        sourceID.append(this.getWFSParameters().getFeatureType());
        int hash = sourceID.hashCode();
        if (sourceID.length() > 60) {
            return sourceID.substring(0, 60) + "_" + hash;
        }
        return sourceID.toString() + "_" + hash;
    }

    public Object createNewOID() {
        try {
            return String.valueOf(this.getFeatureCount() + 1L);
        }
        catch (DataException e) {
            return String.valueOf(Math.random());
        }
    }

    public long getFeatureCount() throws DataException {
        if (this.featureCount == -1L) {
            this.wfsStatus.setResultType(1);
            if (this.hasFilterByArea) {
                this.wfsStatus.setProtocol(1);
            } else {
                this.wfsStatus.setProtocol(0);
            }
            File file = this.executeSpatialQuery();
            this.featureCount = ((WFSGetFeatureRequestInformation)this.wfsClient.getLastWfsRequestInformation()).getNumberOfFeatures();
            if (this.featureCount == -1L) {
                this.storeProviderDelegate = this.createProvider(file);
                this.featureCount = this.storeProviderDelegate.getFeatureCount();
            }
        }
        return this.featureCount;
    }

    public int getOIDType() {
        return 8;
    }

    public ResourceProvider getResource() {
        return this.storeProviderDelegate.getResource();
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType) throws DataException {
        return this.storeProviderDelegate.internalGetFeatureProviderByReference(reference, featureType);
    }

    public String getFullName() {
        return this.getWFSParameters().getUrl() + "_" + this.getWFSParameters().getFeatureType();
    }

    public String getName() {
        return this.getWFSParameters().getFeatureType();
    }

    public boolean isKnownEnvelope() {
        return this.isKnownEnvelope;
    }

    public boolean hasRetrievedFeaturesLimit() {
        return true;
    }

    public int getRetrievedFeaturesLimit() {
        if (this.getWFSParameters().getVersion().equals("1.0.0")) {
            return 0;
        }
        return this.wfsClient.getServiceInformation().getMaxFeatures();
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged) throws DataException {
        this.wfsStatus.setProtocol(1);
        WFSTTransactionBuilder transactionBuilder = new WFSTTransactionBuilder(this.wfsStatus, this.wfsClient);
        try {
            while (inserteds.hasNext()) {
                transactionBuilder.addInsertFeature((FeatureProvider)inserteds.next());
            }
            while (deleteds.hasNext()) {
                transactionBuilder.addDeleteFeature(this.internalGetFeatureProviderByReference((FeatureReferenceProviderServices)deleteds.next(), null).getOID().toString());
            }
            while (updateds.hasNext()) {
                transactionBuilder.addUpdateFeature((FeatureProvider)updateds.next());
            }
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException | WriterHandlerCreationException e) {
            throw new WFSTTRansactionException(e);
        }
        try {
            this.wfsClient.transaction(this.wfsStatus, true, null);
            WFSTransactionRequestInformation transactionRequestInformation = (WFSTransactionRequestInformation)this.wfsClient.getLastWfsRequestInformation();
            if (transactionRequestInformation.getStatus() == 1) {
                throw new WFSTTRansactionException(transactionRequestInformation.getMessage());
            }
        }
        catch (WFSException e) {
            throw new WFSTTRansactionException(e);
        }
    }

    public boolean allowWrite() {
        return this.wfsClient.getServiceInformation().isOperationSupported("Transaction");
    }

    public Envelope getEnvelope() throws DataException {
        return (Envelope)this.getDynValue("Envelope");
    }

    public FeatureProvider createFeatureProvider(FeatureType type) throws DataException {
        return super.createFeatureProvider(type);
    }
}

