/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.wfs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerCreationException;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandler;
import org.gvsig.remoteclient.wfs.WFSClient;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.edition.WFSTAttributesOperation;
import org.gvsig.remoteclient.wfs.edition.WFSTInsertOperation;
import org.gvsig.remoteclient.wfs.edition.WFSTTransaction;
import org.gvsig.remoteclient.wfs.edition.WFSTUpdateOperation;

public class WFSTTransactionBuilder {
    private WFSStatus wfsStatus;
    private WFSClient wfsClient;
    private static final GPEManager gpeManager = GPELocator.getGPEManager();
    private WFSTTransaction transaction = null;

    public WFSTTransactionBuilder(WFSStatus wfsStatus, WFSClient wfsClient) {
        this.wfsStatus = wfsStatus;
        this.wfsClient = wfsClient;
        this.transaction = wfsStatus.createNewTransaction();
    }

    private void addFeatureAttributes(WFSTAttributesOperation attributesOperation, FeatureProvider featureProvider) throws WriterHandlerCreationException, GeometryOperationNotSupportedException, GeometryOperationException {
        for (int i = 0; i < featureProvider.getType().size(); ++i) {
            FeatureAttributeDescriptor featureAttributeDescriptor = featureProvider.getType().getAttributeDescriptor(i);
            String attributeValue = "";
            if (featureAttributeDescriptor.getType() != 66) {
                if (featureProvider.get(i) != null) {
                    attributeValue = featureProvider.get(i).toString();
                }
            } else {
                Geometry geometry = (Geometry)featureProvider.get(i);
                attributeValue = this.toGML(geometry, featureAttributeDescriptor.getSRS().getAbrev());
            }
            attributesOperation.addAttribute(featureAttributeDescriptor.getName(), attributeValue);
        }
    }

    private String toGML(Geometry geometry, String srs) throws GeometryOperationNotSupportedException, GeometryOperationException, WriterHandlerCreationException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IGPEWriterHandler writerHandler = gpeManager.createWriterByMimeType("text/xml; subtype=gml/3.1.2");
        writerHandler.setOutputStream((OutputStream)os);
        writerHandler.initialize();
        GeometryOperationContext geometryOperationContext = new GeometryOperationContext();
        geometryOperationContext.setAttribute("writerHandler", (Object)writerHandler);
        geometryOperationContext.setAttribute("srs", (Object)srs);
        geometryOperationContext.setAttribute("id", null);
        geometry.invokeOperation("writeGml2", geometryOperationContext);
        writerHandler.close();
        String gml = ((Object)os).toString();
        return gml.substring(38, gml.length());
    }

    public void addInsertFeature(FeatureProvider featureProvider) throws WriterHandlerCreationException, GeometryOperationNotSupportedException, GeometryOperationException {
        WFSTInsertOperation insertOperation = this.transaction.createInsertOperation();
        this.addFeatureAttributes(insertOperation, featureProvider);
    }

    public void addUpdateFeature(FeatureProvider featureProvider) throws WriterHandlerCreationException, GeometryOperationNotSupportedException, GeometryOperationException {
        WFSTUpdateOperation updateOperation = this.transaction.createUpdateOperation(featureProvider.getOID().toString());
        this.addFeatureAttributes(updateOperation, featureProvider);
    }

    public void addDeleteFeature(String id) throws DataException {
        this.transaction.createDeleteOperation(id);
    }
}

