/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.util.Hashtable;
import java.util.Vector;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.remoteclient.wfs.WFSServiceInformation;
import org.gvsig.remoteclient.wfs.schema.XMLNameSpace;

public class WFSFeature
extends WFSFeatureField {
    private String localName = null;
    private String title = null;
    private String _abstract = null;
    private Vector srs = new Vector();
    private String defaultSRS = null;
    private BoundaryBox latLonBbox = null;
    private Hashtable bBoxes = new Hashtable();
    private Vector keywords = new Vector();
    private XMLNameSpace namespace = null;
    private WFSServiceInformation serviceInformation;
    private boolean isCompleted = false;

    protected WFSFeature(WFSServiceInformation serviceInformation) {
        this.serviceInformation = serviceInformation;
    }

    protected WFSFeature(WFSServiceInformation serviceInformation, String name) {
        this.serviceInformation = serviceInformation;
        this.setName(name);
    }

    public String getAbstract() {
        return this._abstract;
    }

    public void setAbstract(String _abstract) {
        this._abstract = _abstract;
    }

    public void setName(String name) {
        this.name = name;
        int index = name.indexOf(":");
        if (index > 0) {
            String prefix = name.substring(0, index);
            this.localName = name.substring(index + 1, name.length());
            String nameSpace = this.serviceInformation.getNamespace(prefix);
            this.setNamespace(new XMLNameSpace(prefix, nameSpace));
        }
    }

    public String getTitle() {
        if (this.title == null || this.title.equals("")) {
            return this.name;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BoundaryBox getLatLonBbox() {
        return this.latLonBbox;
    }

    public void setLatLonBbox(BoundaryBox latLonBbox) {
        this.latLonBbox = latLonBbox;
    }

    public Vector getKeywords() {
        return this.keywords;
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public Vector getSrs() {
        return this.srs;
    }

    public void addSRS(String key) {
        String epsgCode = this.getEPSGCode(key);
        if (!this.srs.contains(epsgCode)) {
            this.srs.add(epsgCode);
        }
        if (this.defaultSRS == null) {
            this.defaultSRS = epsgCode;
        }
    }

    public void addBBox(BoundaryBox bbox) {
        this.bBoxes.put(bbox.getSrs(), bbox);
    }

    public BoundaryBox getBbox(String id) {
        return (BoundaryBox)this.bBoxes.get(id);
    }

    public XMLNameSpace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(XMLNameSpace namespace) {
        this.namespace = namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public String getDefaultSRS() {
        return this.defaultSRS;
    }

    public void setDefaultSRS(String defaultSRS) {
        this.defaultSRS = this.getEPSGCode(defaultSRS);
        this.addSRS(defaultSRS);
    }

    private String getEPSGCode(String srs) {
        if (srs == null) {
            return null;
        }
        if (srs.startsWith("urn:x-ogc:def:crs:") || srs.startsWith("urn:ogc:def:crs:")) {
            String newString = srs.substring(srs.lastIndexOf(":") + 1, srs.length());
            if (srs.indexOf("EPSG") > 0 && newString.indexOf("EPSG") < 0) {
                newString = "EPSG:" + newString;
            }
            return newString;
        }
        if (srs.toLowerCase().startsWith("crs:")) {
            return srs.substring(4, srs.length());
        }
        return srs;
    }
}

