/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.exceptions;

import java.io.IOException;
import org.gvsig.remoteclient.wfs.exceptions.InvalidFormatException;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExceptionsFactory {
    public static WFSException parseServiceExceptionReport(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareToIgnoreCase("ServiceException") != 0) break;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attName = parser.getAttributeName(i);
                        String code = null;
                        if (attName.compareTo("code") == 0) {
                            code = parser.getAttributeValue(i);
                        }
                        if (code == null) continue;
                        if (code.compareTo("InvalidFormat") == 0) {
                            parser.next();
                            return new InvalidFormatException(parser.getText());
                        }
                        parser.next();
                        return new WFSException(code, parser.getText());
                    }
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("ServiceExceptionReport") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        return new WFSException();
    }

    public static WFSException parseExceptionReport(KXmlParser parser) throws XmlPullParserException, IOException {
        String code = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    if ("Exception".equals(parser.getName())) {
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            String attName = parser.getAttributeName(i);
                            if (!"exceptionCode".equals(attName)) continue;
                            code = parser.getAttributeValue(i);
                        }
                        break;
                    }
                    if (!"ExceptionText".equals(parser.getName())) break;
                    parser.next();
                    return new WFSException(code, parser.getText());
                }
                case 3: {
                    break;
                }
            }
            parser.nextTag();
            eventType = parser.getEventType();
        }
        return new WFSException();
    }
}

