/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.filters;

public class BinaryTree {
    private Node root = null;
    private Node currentNode = null;

    public void addTerm(String value) {
        if (value.equals("(")) {
            if (this.currentNode == null) {
                this.currentNode = new Node();
                if (this.root == null) {
                    this.root = this.currentNode;
                }
            } else if (this.currentNode.leftNode == null) {
                this.currentNode.leftNode = new Node(this.currentNode);
                this.currentNode = this.currentNode.leftNode;
            } else {
                this.currentNode.rigthNode = new Node(this.currentNode);
                this.currentNode = this.currentNode.rigthNode;
            }
        } else if (!value.equals(")")) {
            while (this.currentNode.value != null) {
                if (this.currentNode.parentNode == null) {
                    this.currentNode.parentNode = new Node();
                    this.currentNode.parentNode.leftNode = this.root;
                    this.currentNode = this.root = this.currentNode.parentNode;
                    break;
                }
                this.currentNode = this.currentNode.parentNode;
            }
            this.currentNode.value = value;
        }
    }

    public void addTerm(String value, String operationTree) {
        Node operationNode = new Node();
        operationNode.value = value;
        if (this.root == null) {
            this.root = operationNode;
        } else {
            Node newRoot = new Node();
            newRoot.value = operationTree;
            newRoot.leftNode = this.root;
            newRoot.rigthNode = operationNode;
            this.root = newRoot;
        }
    }

    public void printTree() {
        this.printNode(this.root, 0);
    }

    private void printNode(Node node, int level) {
        if (node != null) {
            String tab = "";
            for (int i = 0; i < level; ++i) {
                tab = tab + "\t";
            }
            ++level;
            if (node.isField()) {
                System.out.print(tab + node.value + "\n");
            } else {
                System.out.print(tab + node.value + "\n");
                this.printNode(node.leftNode, level);
                this.printNode(node.rigthNode, level);
                System.out.print(tab + "\\" + node.value + "\n");
            }
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public class Node {
        private String value;
        private Node leftNode = null;
        private Node rigthNode = null;
        private Node parentNode;

        private Node() {
            this.parentNode = null;
        }

        private Node(Node parentNode) {
            this.parentNode = parentNode;
        }

        private Node(Node parentNode, String value) {
            this.value = value;
            this.parentNode = parentNode;
        }

        public boolean isField() {
            return this.leftNode == null && this.rigthNode == null;
        }

        public Node getLeftNode() {
            return this.leftNode;
        }

        public Node getRigthNode() {
            return this.rigthNode;
        }

        public String getValue() {
            return this.value;
        }
    }
}

