/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.filters.filterencoding;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.filters.AbstractFilter;
import org.gvsig.remoteclient.wfs.filters.BinaryTree;
import org.gvsig.remoteclient.wfs.filters.DefaultSQLExpressionFormat;
import org.gvsig.remoteclient.wfs.filters.ISQLExpressionFormat;
import org.gvsig.remoteclient.wfs.filters.filterencoding.FEQuery;
import org.gvsig.remoteclient.wfs.filters.filterencoding.wfs_1_0_0.EnvelopeFEQuery1_0_0;
import org.gvsig.remoteclient.wfs.filters.filterencoding.wfs_1_0_0.GeometryFEQuery_1_0_0;
import org.gvsig.remoteclient.wfs.filters.filterencoding.wfs_1_1_0.EnvelopeFEQuery1_1_0;
import org.gvsig.remoteclient.wfs.filters.filterencoding.wfs_1_1_0.GeometryFEQuery_1_1_0;
import org.gvsig.remoteclient.wfs.filters.operations.WFSEnvelopeFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSGeometryFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSSpatialFilterOperation;

public class FilterEncoding
extends AbstractFilter {
    public static final int RELATIONSHIP_PROPERTY = 0;
    public static final int RELATIONSHIP_VAUES = 1;
    private StringBuffer currentQuery = null;
    private static final int OPERATION_PROPERTYNAME = 0;
    private static final int OPERATION_LITERAL = 1;
    private String nameSpacePrefix = null;
    private String nameSpaceLocation = null;
    private boolean hasBlankSpaces = true;
    private String defaultBlankSpace = "%20";
    private String wildCardChar = null;
    private String singleChar = null;
    private String escapeChar = null;
    public static final String DEFAULT_NAMESPACE_PREFIX = "ogc";
    public static final String DEFAULT_WILDCARD = "*";
    public static final String DEFAULT_SINGLECHAR = "?";
    public static final String DEFAULT_ESCAPE = "\\";
    public static final String DEFAULT_NAMESPACE = "xmlns:ogc=\"http://www.opengis.net/ogc\"";
    private Hashtable filterAttributes = new Hashtable();
    private boolean isQualified = false;
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public FilterEncoding(ISQLExpressionFormat formatter, String namesPacePrefix, String wildCard, String singleChar, String escape, Hashtable filterAttributes) {
        super(formatter);
        if (namesPacePrefix == null) {
            this.setQualified(false);
        } else {
            this.setQualified(true);
        }
        this.wildCardChar = wildCard;
        this.singleChar = singleChar;
        this.escapeChar = escape;
        this.filterAttributes = filterAttributes;
    }

    public FilterEncoding(ISQLExpressionFormat formatter) {
        this(formatter, null, DEFAULT_WILDCARD, DEFAULT_SINGLECHAR, DEFAULT_ESCAPE, new Hashtable());
    }

    FilterEncoding() {
        this(new DefaultSQLExpressionFormat());
    }

    public FilterEncoding(WFSStatus status) {
        this();
        this.nameSpacePrefix = status.getNamespacePrefix();
        this.nameSpaceLocation = status.getNamespaceLocation();
        this.setQueryByAttribute(status.getFilterByAttribute());
        this.clearSpatialFilters();
        this.addSpatialFilter(status.getFilterByArea());
    }

    @Override
    public String toString(BinaryTree tree, String version) {
        StringBuffer idQuery = null;
        if (this.getIds() != null) {
            idQuery = new StringBuffer();
            ArrayList ids = this.getIds();
            for (int i = 0; i < ids.size(); ++i) {
                if (ids.get(i) == null) continue;
                Hashtable<String, String> attributes = new Hashtable<String, String>();
                attributes.put("fid", "\"" + ids.get(i).toString() + "\"");
                idQuery.append(this.setTag("FeatureId", attributes, null));
            }
            return this.enclosesWithFilterTag(idQuery.toString(), version);
        }
        String filterQuery = null;
        if (tree.getRoot() == null && this.getSpatialFiltersCount() == 0) {
            return null;
        }
        if (tree.getRoot() != null) {
            this.currentQuery = new StringBuffer();
            filterQuery = this.getFilterNode(tree.getRoot());
            if (this.getSpatialFiltersCount() == 0) {
                return this.enclosesWithFilterTag(filterQuery, version);
            }
        }
        String bboxQuery = null;
        if (this.getSpatialFiltersCount() > 0) {
            for (int i = 0; i < this.getSpatialFiltersCount(); ++i) {
                WFSSpatialFilterOperation spatialFilter = this.getSpatialFilterAt(i);
                FEQuery feQuery = null;
                if (spatialFilter instanceof WFSGeometryFilterOperation) {
                    feQuery = version.equals("1.0.0") ? new GeometryFEQuery_1_0_0((WFSGeometryFilterOperation)spatialFilter) : new GeometryFEQuery_1_1_0((WFSGeometryFilterOperation)spatialFilter);
                } else if (spatialFilter instanceof WFSEnvelopeFilterOperation) {
                    feQuery = version.equals("1.0.0") ? new EnvelopeFEQuery1_0_0((WFSEnvelopeFilterOperation)spatialFilter) : new EnvelopeFEQuery1_1_0((WFSEnvelopeFilterOperation)spatialFilter);
                }
                if (feQuery == null) continue;
                bboxQuery = feQuery.getFilterEncoding();
                if (tree.getRoot() != null) continue;
                String filter_bbox = this.enclosesWithFilterTag(bboxQuery, version);
                return filter_bbox;
            }
        }
        return this.enclosesWithFilterTag(filterQuery + bboxQuery, version);
    }

    private String getFilterNode(BinaryTree.Node node) {
        if (node.isField()) {
            return this.getExpression(node.getValue());
        }
        String left = "";
        String rigth = "";
        if (node.getLeftNode() != null) {
            left = this.getFilterNode(node.getLeftNode());
        }
        if (node.getRigthNode() != null) {
            rigth = this.getFilterNode(node.getRigthNode());
        }
        int operationCode = this.getLogicalOperator(node.getValue());
        String operation = this.getLogicalOperator(operationCode);
        return this.enterLabel(left + rigth, operation);
    }

    private String getExpression(String expression) {
        String[] words = stringUtils.split(expression, " ");
        String param = words[0];
        if (param.charAt(0) == '\"') {
            param = param.substring(1, param.length());
        }
        if (param.charAt(param.length() - 1) == '\"') {
            param = param.substring(0, param.length() - 1);
        }
        String operator = words[1];
        String value = words[2];
        for (int i = 3; i < words.length; ++i) {
            value = value + " " + words[i];
        }
        if (value.charAt(0) == '\'') {
            value = value.substring(1, value.length());
        }
        if (value.charAt(value.length() - 1) == '\'') {
            value = value.substring(0, value.length() - 1);
        }
        int operatorCode = this.getRelationalOperator(operator);
        operator = this.getRelationalOperator(operatorCode);
        return this.createExpression(operator, param, value);
    }

    private String createExpression(String property, String parameter, String value) {
        String cadena = "";
        cadena = "<ogc:" + property;
        if (property.equals("PropertyIsLike")) {
            if (this.wildCardChar != null) {
                cadena = cadena + " wildCard=\"" + this.wildCardChar + "\"";
            }
            if (this.singleChar != null) {
                cadena = cadena + " singleChar=\"" + this.singleChar + "\"";
            }
            if (this.escapeChar != null) {
                cadena = cadena + " escape=\"" + this.escapeChar + "\"";
            }
        }
        cadena = cadena + ">" + this.enterLabel(this.nameSpacePrefix + ":" + parameter, "PropertyName");
        cadena = cadena + this.enterLabel(value, "Literal");
        return cadena + "</" + DEFAULT_NAMESPACE_PREFIX + ":" + property + ">";
    }

    private String enterLabel(String value, String tagName) {
        if (tagName.equals("Filter") && !this.filterAttributes.isEmpty()) {
            return this.setTag(tagName, this.filterAttributes, value);
        }
        return this.setTag(tagName, null, value);
    }

    public String setTag(String tagName, Hashtable attributes, String value) {
        StringBuffer tag = new StringBuffer();
        tag.append("<");
        tag.append("ogc:");
        tag.append(tagName);
        if (attributes != null) {
            Set keys = attributes.keySet();
            if (attributes.size() > 0) {
                for (String key : keys) {
                    if (this.hasBlankSpaces) {
                        tag.append(" ");
                    } else {
                        tag.append(this.defaultBlankSpace);
                    }
                    tag.append(key + "=" + (String)attributes.get(key));
                }
            }
        }
        if (value == null) {
            tag.append("/>");
        } else {
            tag.append(">" + value);
            tag.append("</");
            tag.append("ogc:");
            tag.append(tagName);
            tag.append(">");
        }
        return tag.toString();
    }

    private String enclosesWithFilterTag(String query, String version) {
        StringBuffer filter = new StringBuffer();
        filter.append("<ogc:Filter");
        if (!this.isQualified) {
            filter.append(" ");
            this.addNamespace(filter, DEFAULT_NAMESPACE_PREFIX, "http://www.opengis.net/ogc");
            this.addNamespace(filter, "gml", "http://www.opengis.net/gml");
            if (this.nameSpacePrefix != null) {
                this.addNamespace(filter, this.nameSpacePrefix, this.nameSpaceLocation);
            }
            filter.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            filter.append("xsi:schemaLocation=\"http://www.opengis.net/ogc ../filter/".concat(version).concat("/filter.xsd http://www.opengis.net/gml ../gml/2.1.2/geometry.xsd\""));
        }
        filter.append(">");
        filter.append(query);
        filter.append("</ogc:Filter>");
        return filter.toString();
    }

    private void addNamespace(StringBuffer buffer, String nameSpacePrefix, String nameSpaceLocation) {
        buffer.append("xmlns:" + nameSpacePrefix + "=\"" + nameSpaceLocation + "\" ");
    }

    @Override
    public String getLogicalOperator(int operator) {
        switch (operator) {
            case 10: {
                return "And";
            }
            case 11: {
                return "Or";
            }
            case 12: {
                return "Not";
            }
        }
        return "And";
    }

    @Override
    public String getRelationalOperator(int operator) {
        switch (operator) {
            case 40: {
                return "PropertyIsEqualTo";
            }
            case 41: {
                return "PropertyIsNotEqualTo";
            }
            case 42: {
                return "PropertyIsLessThan";
            }
            case 43: {
                return "PropertyIsGreaterThan";
            }
            case 44: {
                return "PropertyIsLessThanOrEqualTo";
            }
            case 45: {
                return "PropertyIsGreaterThanOrEqualTo";
            }
            case 46: {
                return "PropertyIsLike";
            }
            case 47: {
                return "PropertyIsNull";
            }
            case 48: {
                return "PropertyIsBetween";
            }
        }
        return "PropertyIsLike";
    }

    @Override
    public String getGeometricOperator(int operator) {
        switch (operator) {
            case 21: {
                return "Equals";
            }
            case 22: {
                return "Disjoint";
            }
            case 23: {
                return "Touches";
            }
            case 24: {
                return "Within";
            }
            case 25: {
                return "Overlaps";
            }
            case 26: {
                return "Crosses";
            }
            case 27: {
                return "Intersect";
            }
            case 28: {
                return "Contains";
            }
            case 29: {
                return "Dwithin";
            }
            case 30: {
                return "Beyond";
            }
            case 31: {
                return "BBOX";
            }
        }
        return "Equals";
    }

    @Override
    public String getSeparator(int separator) {
        return null;
    }

    public void setQualified(boolean isQualified) {
        this.isQualified = isQualified;
        this.nameSpacePrefix = isQualified ? "ogc:" : "";
    }

    public void setNamepacePrefix(String namepacePrefix) {
        this.nameSpacePrefix = namepacePrefix == null || namepacePrefix.equals("") ? "" : namepacePrefix + ":";
    }

    public void setHasBlankSpaces(boolean hasBlankSpaces) {
        this.hasBlankSpaces = hasBlankSpaces;
    }
}

