/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.wfs_1_1_0;

import java.io.IOException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSServiceInformation;
import org.gvsig.remoteclient.wfs.schema.XMLNameSpace;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WFSFeature1_1_0
extends WFSFeature {
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public WFSFeature1_1_0(WFSServiceInformation serviceInformation) {
        super(serviceInformation);
    }

    WFSFeature1_1_0(WFSServiceInformation serviceInformation, String name) {
        super(serviceInformation, name);
    }

    public void parse(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "FeatureType");
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String[] attName = stringUtils.split(parser.getAttributeName(i), ":");
            if (attName.length != 2 || attName[0].compareTo("xmlns") != 0) continue;
            XMLNameSpace nameSpace = new XMLNameSpace(attName[1], parser.getAttributeValue(i));
            this.setNamespace(nameSpace);
        }
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    String[] upperCoordinates;
                    String value;
                    if (parser.getName().compareToIgnoreCase("Name") == 0) {
                        this.setName(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("Title") == 0) {
                        this.setTitle(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("Keywords") == 0) {
                        parser.nextTag();
                        while (parser.getName().compareTo("Keyword") == 0) {
                            parser.next();
                            String keyword = parser.getText();
                            if (keyword != null || !keyword.equals("")) {
                                this.addKeyword(keyword);
                            }
                            parser.nextTag();
                            parser.nextTag();
                        }
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("Keyword") == 0) {
                        this.addKeyword(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("SRS") == 0 || parser.getName().compareToIgnoreCase("OtherSRS") == 0) {
                        String value2 = parser.nextText();
                        if (value2 == null) break;
                        String[] mySRSs = stringUtils.split(value2, " ");
                        for (int i = 0; i < mySRSs.length; ++i) {
                            this.addSRS(mySRSs[i]);
                        }
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("DefaultSRS") == 0) {
                        String value3 = parser.nextText();
                        this.setDefaultSRS(value3.trim());
                        break;
                    }
                    if (parser.getName().compareToIgnoreCase("LatLongBoundingBox") == 0) {
                        BoundaryBox bbox = new BoundaryBox();
                        if (this.getDefaultSRS() != null) {
                            bbox.setSrs(this.getDefaultSRS());
                        } else {
                            bbox.setSrs("EPSG:4326");
                        }
                        value = parser.getAttributeValue("", "minx");
                        if (value != null && Utilities.isNumber((String)value)) {
                            bbox.setXmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "miny")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmax(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxy")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmax(Double.parseDouble(value));
                        }
                        this.addBBox(bbox);
                        this.setLatLonBbox(bbox);
                        break;
                    }
                    if (parser.getName().compareTo("BoundingBox") == 0) {
                        BoundaryBox bbox = new BoundaryBox();
                        value = parser.getAttributeValue("", "SRS");
                        if (value != null) {
                            bbox.setSrs(value);
                        }
                        if ((value = parser.getAttributeValue("", "minx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "miny")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmax(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxy")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmax(Double.parseDouble(value));
                        }
                        if (bbox.getSrs() == null) break;
                        this.addBBox(bbox);
                        this.addSRS(bbox.getSrs());
                        break;
                    }
                    if (!"WGS84BoundingBox".equals(parser.getName())) break;
                    String lowerCorner = null;
                    String upperCorner = null;
                    parser.next();
                    String tagName = parser.getName();
                    while (!"WGS84BoundingBox".equals(tagName)) {
                        if ("LowerCorner".equals(tagName) && 2 == currentTag) {
                            parser.next();
                            lowerCorner = parser.getText();
                        } else if ("UpperCorner".equals(tagName) && 2 == currentTag) {
                            parser.next();
                            upperCorner = parser.getText();
                        }
                        currentTag = parser.next();
                        tagName = parser.getName();
                    }
                    if (lowerCorner == null || upperCorner == null) break;
                    BoundaryBox bbox = new BoundaryBox();
                    bbox.setSrs("EPSG:4326");
                    String[] lowerCoordinates = stringUtils.split(lowerCorner, "[! \t\r\n]");
                    if (lowerCoordinates.length >= 2) {
                        try {
                            bbox.setXmin(Double.valueOf(lowerCoordinates[0]).doubleValue());
                            bbox.setYmin(Double.valueOf(lowerCoordinates[1]).doubleValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((upperCoordinates = stringUtils.split(upperCorner, "[! \t\r\n]")).length >= 2) {
                        try {
                            bbox.setXmax(Double.valueOf(upperCoordinates[0]).doubleValue());
                            bbox.setYmax(Double.valueOf(upperCoordinates[1]).doubleValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    bbox = BoundaryBox.clipGeodeticBBox((BoundaryBox)bbox);
                    this.addBBox(bbox);
                    this.setLatLonBbox(bbox);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("FeatureType") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }
}

