/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import Zql.ZExp;
import Zql.ZqlParser;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.sqlQueryValidation.SQLQueryValidation;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.filterPanel.filterQueryPanel.FilterQueryJPanel;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.utils.stringNumberUtilities.StringNumberUtilities;
import org.gvsig.wfs.gui.panels.IWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTableModel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSFilterPanel
extends FilterQueryJPanel
implements IWFSPanel {
    private static final long serialVersionUID = -6041218260822015810L;
    private static final Logger LOG = LoggerFactory.getLogger(WFSFilterPanel.class);
    private static Logger logger = LoggerFactory.getLogger(WFSFilterPanel.class);
    private FieldsTreeTableModel fieldsTreeTableModel;
    private boolean panelAsATabForWFSLayersLoad;
    private TreePath currentPath = null;
    private Map<String, Map<String, String>> allFieldsAndValuesKnownOfCurrentLayer = new HashMap<String, Map<String, String>>();
    private DataStore dataStore = null;

    public WFSFilterPanel() {
        super.getValuesJList().setEnabled(false);
        this.getValidateFilterExpressionJCheckBox().setSelected(false);
    }

    protected void initialize() {
        this.setLabel(PluginServices.getText((Object)this, (String)"filter"));
        this.setLabelGroup(PluginServices.getText((Object)this, (String)"wfs"));
        super.initialize();
        this.resizeHeight(380);
        this.defaultTreeModel = (DefaultTreeModel)this.fieldsJTree.getModel();
        this.addNewListeners();
        this.panelAsATabForWFSLayersLoad = true;
        this.getValidateFilterExpressionJCheckBox().setSelected(true);
        this.getValuesJLabel().setToolTipText(Messages.getText((String)"values_of_the_selected_field_explanation"));
        this.getFieldsJLabel().setToolTipText(Messages.getText((String)"fields_of_the_selected_feature_explanation"));
    }

    private void addNewListeners() {
        this.txtExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!WFSFilterPanel.this.panelAsATabForWFSLayersLoad) {
                    AbstractPanelGroup panelGroup = WFSFilterPanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!WFSFilterPanel.this.panelAsATabForWFSLayersLoad) {
                    AbstractPanelGroup panelGroup = WFSFilterPanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }
            }
        });
        this.getFieldsJTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = WFSFilterPanel.this.fieldsJTree.getRowForLocation(e.getX(), e.getY());
                TreePath treePath = WFSFilterPanel.this.fieldsJTree.getPathForLocation(e.getX(), e.getY());
                if (row > -1) {
                    switch (e.getClickCount()) {
                        case 2: {
                            WFSFilterPanel.this.putSymbolOfSelectedByMouseBranch(treePath);
                        }
                    }
                }
            }
        });
        this.getValuesJList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = WFSFilterPanel.this.getValuesJList().getSelectedIndex();
                if (index == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    String valor = WFSFilterPanel.this.valuesListModel.getElementAt(index).toString();
                    if (WFSFilterPanel.this.getNodeOfCurrentPath().getDataType().getType() == 8) {
                        WFSFilterPanel.this.putSymbol("'" + valor + "'");
                    } else {
                        WFSFilterPanel.this.putSymbol(valor);
                    }
                }
            }
        });
        this.getFieldsJTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (WFSFilterPanel.this.dataStore != null) {
                    WFSFilterPanel.this.currentPath = e.getPath();
                    WFSFilterPanel.this.fillValuesByPath(WFSFilterPanel.this.currentPath);
                }
            }
        });
        this.getTxtExpression().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WFSFilterPanel.this.getTxtExpression().setForeground(Color.BLACK);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WFSFilterPanel.this.getTxtExpression().setForeground(Color.BLACK);
            }
        });
    }

    private WFSFeatureField getNodeOfCurrentPath() {
        Object node;
        if (this.currentPath != null && (node = this.currentPath.getLastPathComponent()) != null && node instanceof WFSFeatureField) {
            return (WFSFeatureField)node;
        }
        return null;
    }

    public void putSymbolOfSelectedByMouseBranch(TreePath treePath) {
        if (treePath != null) {
            this.putSymbol("\"" + this.getPathOfLeafWithoutRoot(treePath.getLastPathComponent().toString()) + "\"");
        }
    }

    private String getPathOfLeafWithoutRoot(Object node) {
        String path = "";
        if (node != null && node instanceof IXSElementDeclaration) {
            IXSElementDeclaration element = (IXSElementDeclaration)node;
            IXSElementDeclaration parent = element.getParentElement();
            path = element.getNodeName();
            while (parent.getParentElement() != null) {
                path = parent.getNodeName() + "/" + path;
                parent = parent.getParentElement();
            }
        } else if (node instanceof String) {
            path = node.toString();
        }
        return path;
    }

    public boolean getWFSFilterPanelIsAsTabForWFSLayersLoad() {
        return this.panelAsATabForWFSLayersLoad;
    }

    @Override
    public void refresh(WFSSelectedFeature feature) {
        this.setFields(feature);
    }

    public String getQuery() {
        String writtenQuery = this.txtExpression.getText().trim();
        if (!this.validateExpression(writtenQuery)) {
            this.getTxtExpression().setForeground(Color.red);
            return null;
        }
        logger.debug("Codified WFS filter query: " + writtenQuery);
        if (writtenQuery.trim().length() == 0) {
            return null;
        }
        return this.formatResutl(writtenQuery);
    }

    public String getFilterExpressionFromInterface() {
        return this.getTxtExpression().getText();
    }

    public void setFilterExpressionIntoInterface(String filterExpression) {
        this.getTxtExpression().setText(filterExpression);
    }

    public void removeFilterExpression() {
        this.getTxtExpression().setText("");
    }

    private String formatResutl(String query) {
        if (query == null || query.equals("")) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes());
        ZqlParser parser = new ZqlParser();
        parser.initParser((InputStream)is);
        try {
            ZExp exp = parser.readExpression();
            return exp.toString();
        }
        catch (Zql.ParseException e) {
            LOG.error("Formatting the filter request", (Throwable)e);
            JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format"), PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
            return query;
        }
    }

    private boolean validateExpression(String query) {
        try {
            if (this.getValidateFilterExpressionJCheckBox().isSelected()) {
                if (query.trim().length() == 0) {
                    return true;
                }
                int index = 0;
                String query_copy = new String(query);
                while ((index = query_copy.indexOf("Date(", index)) != -1 && (index <= 0 || query_copy.charAt(index - 1) == ' ' || query_copy.charAt(index - 1) == '(')) {
                    if (index + 16 >= query_copy.length() || query_copy.charAt(index + 16) != ')') continue;
                    if (index + 17 < query_copy.length()) {
                        query_copy = query_copy.substring(0, index) + "     " + query_copy.substring(index + 6, index + 16) + " " + query_copy.substring(index + 17);
                        continue;
                    }
                    query_copy = query_copy.substring(0, index) + "     " + query_copy.substring(index + 6, index + 16);
                }
                SQLQueryValidation sQLQueryValidation = new SQLQueryValidation(this.formatSQLQuery(query_copy), true);
                if (!sQLQueryValidation.validateQuery()) {
                    JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"finded") + " " + sQLQueryValidation.getTokenThatProducedTheSyntacticError() + " " + PluginServices.getText(null, (String)"in") + " " + sQLQueryValidation.getErrorPositionAsMessage() + ".", PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                    return false;
                }
                StringTokenizer tokens = new StringTokenizer(query, " ");
                boolean finish = false;
                while (tokens.hasMoreTokens()) {
                    String token_aux;
                    String token = tokens.nextToken().trim();
                    if (token.charAt(0) == '\'' && token.charAt(token.length() - 1) != '\'') {
                        while (!finish) {
                            if (!tokens.hasMoreTokens()) {
                                JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"the_token") + " " + token + " " + PluginServices.getText(null, (String)"has_bad_format"), PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                                return false;
                            }
                            token_aux = tokens.nextToken().trim();
                            token = token + " " + token_aux;
                            if (token_aux.charAt(token_aux.length() - 1) != '\'') continue;
                            finish = true;
                        }
                        finish = false;
                    }
                    if (token.charAt(0) == '\"' && token.charAt(token.length() - 1) != '\"') {
                        while (!finish) {
                            if (!tokens.hasMoreTokens()) {
                                JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"the_token") + " " + token + " " + PluginServices.getText(null, (String)"has_bad_format"), PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                                return false;
                            }
                            token_aux = tokens.nextToken().trim();
                            token = token + " " + token_aux;
                            if (token_aux.charAt(token_aux.length() - 1) != '\"') continue;
                            finish = true;
                        }
                        finish = false;
                    }
                    if (token.length() <= 0) continue;
                    if (token.length() > 2 && token.charAt(0) == '\"' && token.charAt(token.length() - 1) == '\"') {
                        if (this.isAField(token.substring(1, token.length() - 1))) continue;
                        JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"the_token") + " " + token + " " + PluginServices.getText(null, (String)"isnt_a_field_of_layer"), PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                        return false;
                    }
                    if (token.charAt(0) == token.charAt(token.length() - 1) && token.charAt(0) == '\'') continue;
                    int returnValue = this.validateDate(token);
                    if (returnValue == 1) {
                        JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"incorrect_format_on_date") + " " + token.substring(5, 16) + " .", PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                        return false;
                    }
                    if (returnValue != 2 || StringNumberUtilities.isRealNumberWithIntegerExponent((String)token) || this.isAnOperatorNameOrSymbol(token, this.getAllOperatorSymbols())) continue;
                    JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + ": " + PluginServices.getText(null, (String)"not_valid_token") + ": " + token, PluginServices.getText(null, (String)"error_validating_filter_query"), 0);
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            NotificationManager.showMessageError((String)(PluginServices.getText(null, (String)"filter_with_an_incorrect_format") + "."), (Exception)e);
            return true;
        }
    }

    private String formatSQLQuery(String token) {
        token = token.replace("\u00c3\u00b1", "n").replace("\u00c3\u00a7", "c").replace("\u00c3\u00a1", "a").replace("\u00c3\u00a9", "e").replace("\u00c3\u00ad", "i").replace("\u00c3\u00b3", "o").replace("\u00c3\u00ba", "u").replace("\u00c3\u00a0", "a").replace("\u00c3\u00a8", "e").replace("\u00c3\u00ac", "i").replace("\u00c3\u00b2", "o").replace("\u00c3\u00b9", "u").replace("\u00c3\u00a4", "a").replace("\u00c3\u00ab", "e").replace("\u00c3\u00af", "i").replace("\u00c3\u00b6", "o").replace("\u00c3\u00bc", "u").replace("\u00c3\u00a2", "a").replace("\u00c3\u00aa", "e").replace("\u00c3\u00ae", "i").replace("\u00c3\u00b4", "o").replace("\u00c3\u00bb", "u");
        return token;
    }

    private boolean isAField(String text) {
        return this.allFieldsAndValuesKnownOfCurrentLayer.containsKey(text);
    }

    private int validateDate(String text) {
        if (text.length() == 17 && text.startsWith("Date(") && text.endsWith(")") && text.charAt(7) == '-' && text.charAt(11) == '-') {
            if (StringNumberUtilities.isNaturalNumber((String)text.substring(5, 7)) && StringNumberUtilities.isNaturalNumber((String)text.substring(12, 16))) {
                try {
                    DateFormat.getDateInstance().parse(text.substring(5, 16));
                    return 0;
                }
                catch (ParseException e) {
                    NotificationManager.addError((Throwable)e);
                    return 1;
                }
            }
            return 1;
        }
        return 2;
    }

    private boolean isAnOperatorNameOrSymbol(String text, Set<String> operatorNamesAndSymbols) {
        return operatorNamesAndSymbols.contains(text);
    }

    private boolean setFields(WFSSelectedFeature feature) {
        this.resetFieldsAndValuesData();
        int numberOfFields = feature.getWFSFeature().getFieldSize();
        if (numberOfFields > 0) {
            Vector<WFSFeatureField> fieldBranches = new Vector<WFSFeatureField>(0, 1);
            for (int i = 0; i < numberOfFields; ++i) {
                WFSFeatureField featureField = feature.getWFSFeature().getFieldAt(i);
                if (featureField.isGeometry()) continue;
                fieldBranches.add(featureField);
            }
            if (fieldBranches.size() > 0) {
                Object obj = fieldBranches.get(0);
                this.fieldsTreeTableModel = new FieldsTreeTableModel(feature.getWFSFeature(), false);
                this.fieldsJTree.setModel((TreeModel)((Object)new FieldsTreeTableModel(feature.getWFSFeature(), false)));
                Object root = this.fieldsTreeTableModel.getRoot();
                if (root != null) {
                    Vector<Object> fieldsNames = this.fieldsTreeTableModel.getLeafsFromNodeBranch(root);
                    for (Object field : fieldsNames) {
                        String completeFieldPath;
                        if (!(field instanceof WFSFeatureField) || field == null || ((WFSFeatureField)field).isGeometry() || this.allFieldsAndValuesKnownOfCurrentLayer.containsKey(completeFieldPath = this.getPathOfLeafWithoutRoot(field))) continue;
                        this.allFieldsAndValuesKnownOfCurrentLayer.put(completeFieldPath, new HashMap());
                    }
                }
            }
        }
        return true;
    }

    private void resetFieldsAndValuesData() {
        this.fieldsJTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.txtExpression.setText("");
        ((DefaultListModel)this.valuesJList.getModel()).removeAllElements();
    }

    private void fillValuesByPath(TreePath treePath) {
        TreeSet<Object> fieldValueSet = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    return o1.toString().compareTo(o2.toString());
                }
                return 0;
            }
        });
        this.valuesListModel.clear();
        try {
            WFSFeatureField wfsFeatureField = (WFSFeatureField)treePath.getLastPathComponent();
            if (wfsFeatureField == null) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)this.dataStore;
            FeatureAttributeDescriptor featureAttributeDescriptor = featureStore.getDefaultFeatureType().getAttributeDescriptor(wfsFeatureField.getName());
            if (featureAttributeDescriptor == null) {
                return;
            }
            if (!wfsFeatureField.isComplex()) {
                for (Feature feature : featureStore.getFeatureSet()) {
                    Object obj = feature.get(featureAttributeDescriptor.getIndex());
                    if (fieldValueSet.contains(obj)) continue;
                    fieldValueSet.add(obj);
                }
                Iterator<Object> it = fieldValueSet.iterator();
                while (it.hasNext()) {
                    String text = it.next().toString();
                    this.valuesListModel.addElement(text);
                }
            }
            this.getValuesJList().setEnabled(this.valuesListModel.getSize() > 0);
        }
        catch (Exception e) {
            NotificationManager.addError((Throwable)e);
        }
    }

    public void setAllFieldsAndValuesKnownOfCurrentLayer(Map<String, Map<String, String>> _allFieldsAndValuesKnownOfCurrentLayer) {
        this.allFieldsAndValuesKnownOfCurrentLayer = _allFieldsAndValuesKnownOfCurrentLayer == null ? new HashMap<String, Map<String, String>>() : _allFieldsAndValuesKnownOfCurrentLayer;
    }

    public Map<String, Map<String, String>> getAllFieldsAndValuesKnownOfCurrentLayer() {
        return this.allFieldsAndValuesKnownOfCurrentLayer;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }
}

