/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.toc.gui.HTMLInfoPanel;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.wfs.gui.panels.IWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;

public class WFSInfoPanel
extends HTMLInfoPanel
implements IWFSPanel {
    private static final long serialVersionUID = 2605168444543321684L;
    private final String service_title = PluginServices.getText((Object)this, (String)"service_info");
    private final String server = PluginServices.getText((Object)this, (String)"server");
    private final String server_type = PluginServices.getText((Object)this, (String)"server_type");
    private final String server_abstract = PluginServices.getText((Object)this, (String)"server_abstract");
    private final String server_title = PluginServices.getText((Object)this, (String)"server_title");
    private final String layers_title = PluginServices.getText((Object)this, (String)"selected_layer");
    private final String layer_title = PluginServices.getText((Object)this, (String)"layer_title");
    private final String layer_abstract = PluginServices.getText((Object)this, (String)"layer_abstract");
    private final String options = PluginServices.getText((Object)this, (String)"properties");
    private final String layer_fields = PluginServices.getText((Object)this, (String)"fields");
    private final String layer_name = PluginServices.getText((Object)this, (String)"name");
    private final String timeout = PluginServices.getText((Object)this, (String)"timeout");
    private final String buffer = PluginServices.getText((Object)this, (String)"max_features");
    private final String layer_geometry = PluginServices.getText((Object)this, (String)"geometry");
    private final String layer_srs = PluginServices.getText((Object)this, (String)"srs");

    public WFSInfoPanel() {
        this.initialize();
        this.setPreferredSize(new Dimension(10, 10));
    }

    protected void paintComponent(Graphics g) {
        AbstractPanelGroup panelGroup = this.getPanelGroup();
        if (panelGroup == null) {
            return;
        }
        ((WFSParamsPanel)panelGroup).refreshCapabilitiesInfo();
        super.paintComponent(g);
    }

    @Override
    public void refresh(WFSSelectedFeature layer) {
        WFSServerExplorer serverExplorer = this.getServerExplorer();
        String server_text = serverExplorer.getUrl();
        String server_type_text = serverExplorer.getServerType();
        String server_title_text = serverExplorer.getTitle();
        String server_abstract_text = serverExplorer.getAbstract();
        if (server_text == null) {
            server_text = "-";
        }
        if (server_type_text == null) {
            server_type_text = "-";
        }
        if (server_title_text == null) {
            server_title_text = "-";
        }
        if (server_abstract_text == null) {
            server_abstract_text = "-";
        }
        String layers_html = "";
        if (layer != null) {
            String layer_name_text = layer.getName();
            String layer_abstract_text = layer.getAbstract();
            String layer_title_text = layer.getTitle();
            String layer_fields_text = "-";
            String layer_geometry_text = "-";
            String layer_srs_text = "-";
            Vector fields = layer.getSelectedFields();
            layer_fields_text = "";
            for (int i = 0; i < fields.size(); ++i) {
                WFSFeatureField field = (WFSFeatureField)fields.get(i);
                layer_fields_text = field.isGeometry() ? layer_fields_text + field.getName() + " (" + PluginServices.getText((Object)this, (String)field.getType()) + ")" : layer_fields_text + field.getName();
                if (i >= fields.size() - 1) continue;
                layer_fields_text = layer_fields_text + ", ";
            }
            layer_geometry_text = PluginServices.getText((Object)this, (String)layer.getGeometryField().getType());
            if (layer_geometry_text.equals("")) {
                layer_geometry_text = "-";
            }
            if (layer.getSrs().size() > 0) {
                layer_srs_text = (String)layer.getSrs().get(0);
            }
            if (layer_name_text == null) {
                layer_name_text = "-";
            }
            if (layer_abstract_text == null) {
                layer_abstract_text = "-";
            }
            if (layer_title_text == null) {
                layer_title_text = "-";
            }
            StringBuffer layer_html = new StringBuffer();
            layer_html.append(this.setHTMLBasicProperty(this.layer_name, layer_name_text));
            layer_html.append(this.setHTMLBasicProperty(this.layer_title, layer_title_text));
            layer_html.append(this.setHTMLBasicProperty(this.layer_abstract, layer_abstract_text));
            layer_html.append(this.setHTMLBasicProperty(this.layer_geometry, layer_geometry_text));
            layer_html.append(this.setHTMLBasicProperty(this.layer_fields, layer_fields_text));
            layer_html.append(this.setHTMLBasicProperty(this.layer_srs, layer_srs_text));
            layers_html = layers_html + layer_html.toString();
        }
        if (!layers_html.equals("")) {
            layers_html = this.setHTMLTitleTable(this.layers_title, 2) + layers_html;
        }
        String buffer_text = String.valueOf(serverExplorer.getMaxFeatures());
        String timeout_text = String.valueOf(serverExplorer.getTimeOut());
        StringBuffer options_html = new StringBuffer();
        options_html.append(this.setHTMLTitleTable(this.options, 2));
        options_html.append(this.setHTMLBasicProperty(this.timeout, timeout_text));
        options_html.append(this.setHTMLBasicProperty(this.buffer, buffer_text));
        StringBuffer service_html = new StringBuffer();
        service_html.append(this.setHTMLTitleTable(this.service_title, 2));
        service_html.append(this.setHTMLBasicProperty(this.server, server_text));
        service_html.append(this.setHTMLBasicProperty(this.server_type, server_type_text));
        service_html.append(this.setHTMLBasicProperty(this.server_title, server_title_text));
        service_html.append(this.setHTMLBasicProperty(this.server_abstract, server_abstract_text));
        StringBuffer html = new StringBuffer();
        html.append(this.setHTMLTable(service_html.toString()));
        html.append(this.setHTMLTable(layers_html.toString()));
        html.append(this.setHTMLTable(options_html.toString()));
        this.addHTMLToPanel(this.setHTMLBody(html.toString()));
    }

    public void accept() {
    }

    public void apply() {
    }

    public void cancel() {
    }

    public void selected() {
    }

    public WFSServerExplorer getServerExplorer() {
        return this.getPanelGroup() == null ? null : ((WFSParamsPanel)this.getPanelGroup()).getServerExplorer();
    }
}

