/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.cresques.cts.CRSUtils;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.ILayerPanel;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.fmap.dal.store.wfs.WFSOpenStoreParameters;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.CreateLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupException;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupGUIException;
import org.gvsig.gui.beans.panelGroup.exceptions.ListCouldntAddPanelException;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.gui.beans.panelGroup.tabbedPanel.TabbedPanel;
import org.gvsig.remoteclient.wfs.schema.XMLNameSpace;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.wfs.gui.panels.WFSAreaPanel;
import org.gvsig.wfs.gui.panels.WFSInfoPanel;
import org.gvsig.wfs.gui.panels.WFSOptionsPanel;
import org.gvsig.wfs.gui.panels.WFSSelectFeaturePanel;
import org.gvsig.wfs.gui.panels.WFSSelectFieldsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeatureManager;
import org.gvsig.wfs.gui.wizards.WFSWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSParamsPanel
extends TabbedPanel
implements ILayerPanel {
    private static final long serialVersionUID = 150328995058481516L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WFSParamsPanel.class);
    private WFSServerExplorer serverExplorer = null;
    private WFSSelectedFeatureManager selectedFeatureManager = null;
    private static final MapContextManager MAP_CONTEXT_MANAGER = MapContextLocator.getMapContextManager();
    private int infoTabPosition = -1;
    private int featureTabPosition = -1;
    private int fieldsTabPosition = -1;
    private int optionsTabPosition = -1;
    private int areaTabPosition = -1;
    private WFSInfoPanel infoPanel = null;
    private WFSSelectFeaturePanel featurePanel = null;
    private WFSSelectFieldsPanel fieldsPanel = null;
    private WFSOptionsPanel optionsPanel = null;
    private WFSAreaPanel areaPanel = null;
    private String cacheSelected = null;
    private WizardPanel wfsWizard;

    public WFSParamsPanel(Object reference) {
        super(reference);
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.setVisible(false);
    }

    public WizardPanel getWizardPanel() {
        return this.wfsWizard;
    }

    public void setWizardPanel(WizardPanel wfsWizard) {
        this.wfsWizard = wfsWizard;
    }

    public void goToNextTab() {
        int nextIndex;
        int tabIndex = this.getSelectedIndex();
        if (tabIndex - 1 < this.getPanelInGUICount() && (nextIndex = this.nextPageEnabled()) > -1) {
            this.setSelectedIndex(nextIndex);
        }
    }

    public void goToPreviousTab() {
        this.setSelectedIndex(this.previousEnabledPage());
    }

    public int getSelectedIndex() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.getJTabbedPane().setSelectedIndex(index);
    }

    public WFSInfoPanel getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        if (this.infoTabPosition == -1) {
            return null;
        }
        this.infoPanel = (WFSInfoPanel)this.values().toArray()[this.infoTabPosition];
        return this.infoPanel;
    }

    public WFSSelectFeaturePanel getFeaturesPanel() {
        if (this.featurePanel != null) {
            return this.featurePanel;
        }
        if (this.featureTabPosition == -1) {
            return null;
        }
        this.featurePanel = (WFSSelectFeaturePanel)this.values().toArray()[this.featureTabPosition];
        return this.featurePanel;
    }

    public WFSSelectFieldsPanel getFieldsPanel() {
        if (this.fieldsPanel != null) {
            return this.fieldsPanel;
        }
        if (this.fieldsTabPosition == -1) {
            return null;
        }
        this.fieldsPanel = (WFSSelectFieldsPanel)this.values().toArray()[this.fieldsTabPosition];
        return this.fieldsPanel;
    }

    public WFSOptionsPanel getOptionsPanel() {
        if (this.optionsPanel != null) {
            return this.optionsPanel;
        }
        if (this.optionsTabPosition == -1) {
            return null;
        }
        this.optionsPanel = (WFSOptionsPanel)this.values().toArray()[this.optionsTabPosition];
        return this.optionsPanel;
    }

    public WFSAreaPanel getAreaPanel() {
        if (this.areaPanel != null) {
            return this.areaPanel;
        }
        if (this.areaTabPosition == -1) {
            return null;
        }
        this.areaPanel = (WFSAreaPanel)this.values().toArray()[this.areaTabPosition];
        return this.areaPanel;
    }

    public boolean isCorretlyConfigured() {
        if (this.featurePanel == null) {
            return false;
        }
        int n_sel = this.featurePanel.getSelectedFeaturesCount();
        return n_sel > 0;
    }

    public void enableDefaultTabs(boolean isEnabled) {
        if (this.fieldsTabPosition != -1) {
            this.setEnabledAt(this.fieldsTabPosition, isEnabled);
        }
        if (this.areaTabPosition != -1) {
            this.setEnabledAt(this.areaTabPosition, isEnabled);
        }
    }

    protected void loadPanel(IPanel panel) {
        super.loadPanel(panel);
        if (((AbstractPanel)panel).getClass() == WFSInfoPanel.class) {
            this.infoTabPosition = this.getPanelInGUICount() - 1;
            return;
        }
        if (((AbstractPanel)panel).getClass() == WFSSelectFeaturePanel.class) {
            this.featureTabPosition = this.getPanelInGUICount() - 1;
            return;
        }
        if (((AbstractPanel)panel).getClass() == WFSSelectFieldsPanel.class) {
            this.fieldsTabPosition = this.getPanelInGUICount() - 1;
            return;
        }
        if (((AbstractPanel)panel).getClass() == WFSOptionsPanel.class) {
            this.optionsTabPosition = this.getPanelInGUICount() - 1;
            return;
        }
        if (((AbstractPanel)panel).getClass() == WFSAreaPanel.class) {
            this.areaTabPosition = this.getPanelInGUICount() - 1;
            return;
        }
    }

    public void refreshCapabilitiesInfo() {
        WFSSelectedFeature selectedFeature = this.getFeaturesPanel().getSelectedFeature();
        if (selectedFeature != null) {
            selectedFeature.setSelectedFields(this.getFieldsPanel().getSelectedFields());
        } else {
            this.getFeaturesPanel().refresh(null);
        }
        this.serverExplorer.setUserName(this.getOptionsPanel().getUserName());
        this.serverExplorer.setMaxFeatures(this.getOptionsPanel().getBuffer());
        this.serverExplorer.setTimeOut(this.getOptionsPanel().getTimeout());
        this.getInfoPanel().refresh(selectedFeature);
    }

    public WFSServerExplorer getServerExplorer() {
        return this.serverExplorer;
    }

    public void setServerExplorer(WFSServerExplorer serverExplorer) {
        this.serverExplorer = serverExplorer;
        this.selectedFeatureManager = WFSSelectedFeatureManager.getInstance(serverExplorer);
    }

    public int nextPageEnabled() {
        int nPages;
        int currentPage = this.getSelectedIndex();
        if (currentPage == (nPages = this.getPanelInGUICount())) {
            return -1;
        }
        for (int i = currentPage + 1; i < nPages; ++i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            return i;
        }
        return -1;
    }

    public int currentPage() {
        return this.getSelectedIndex();
    }

    public int previousEnabledPage() {
        int currentPage = this.getSelectedIndex();
        if (currentPage == 0) {
            return -1;
        }
        for (int i = currentPage - 1; i > -1; --i) {
            if (!this.isEnabledAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void initWizard() {
    }

    public void execute() {
    }

    public FLayer getLayer() {
        try {
            FLyrVect layer = (FLyrVect)this.createLayer();
            LOGGER.warn("El flujo de la apliaci\u00f3n tal vez no deber\u00eda haber pasado por aqu\u00ed.");
            return layer;
        }
        catch (CreateLayerException createLayerException) {
            return null;
        }
    }

    public FLayer createLayer() throws CreateLayerException {
        try {
            FLyrVect layerAux = (FLyrVect)MAP_CONTEXT_MANAGER.createLayer(this.getFeaturesPanel().getLayerName(), (DataStoreParameters)this.getDataStoreParameters());
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (StringUtils.isNotBlank((String)this.cacheSelected) && !StringUtils.equalsIgnoreCase((String)this.cacheSelected, (String)i18n.getTranslation("none"))) {
                layerAux.getFeatureStore().createCache(this.cacheSelected, this.getParameters(this.cacheSelected));
            }
            return layerAux;
        }
        catch (Exception e) {
            LOGGER.warn("Can't create layer.", (Throwable)e);
            throw new CreateLayerException(this.getFeaturesPanel().getLayerName(), (Throwable)e);
        }
    }

    protected DynObject getParameters(String nameCacheProvider) throws DataException {
        DataManager dataManager = DALLocator.getDataManager();
        return dataManager.createCacheParameters(nameCacheProvider);
    }

    public WFSOpenStoreParameters getDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        DataManager dataManager = DALLocator.getDataManager();
        WFSOpenStoreParameters parameters = (WFSOpenStoreParameters)dataManager.createStoreParameters(WFSStoreProvider.NAME);
        this.refreshDataStoreParameters(parameters);
        return parameters;
    }

    private void refreshDataStoreParameters(WFSOpenStoreParameters parameters) {
        WFSSelectedFeature selectedFeature = this.getSelectedFeature();
        parameters.setUrl(this.serverExplorer.getUrl());
        parameters.setFeatureType(selectedFeature.getNameSpace(), selectedFeature.getName());
        parameters.setFields(this.getFieldsPanel().getSelectedFieldsAsString());
        parameters.setUser(this.getOptionsPanel().getUserName());
        parameters.setPassword(this.getOptionsPanel().getPassword());
        parameters.setMaxFeatures(this.getOptionsPanel().getBuffer());
        parameters.setTimeOut(this.getOptionsPanel().getTimeout());
        boolean useAxisOrderYX = this.getOptionsPanel().getUseAxisOrderYX();
        parameters.setUseAxisOrderYX(useAxisOrderYX);
        Geometry area = this.getAreaPanel().getArea();
        if (area != null) {
            Envelope envelope = area.getEnvelope();
            parameters.setFilterByAreaEnvelope(envelope);
        }
        parameters.setFilterByAreaCrs(this.getAreaPanel().getSrs());
        XMLNameSpace ns = selectedFeature.getWFSFeature().getNamespace();
        if (ns != null) {
            String ns_pre = ns.getPrefix();
            parameters.setDynValue("namespacePrefix", ns_pre);
        }
        parameters.setVersion(this.getOptionsPanel().getVersion());
        parameters.setFilterByAreaOperation(28);
        parameters.setFilterByAreaAttribute(selectedFeature.getGeometryField().getName());
        parameters.setCrs(this.getOptionsPanel().getSRS());
    }

    public void setDataStore(DataStore dataStore) {
        WFSOpenStoreParameters storeParameters = (WFSOpenStoreParameters)dataStore.getParameters();
        WFSSelectedFeature selectedFeature = this.selectedFeatureManager.getFeatureInfo(storeParameters.getFeatureNamespace(), storeParameters.getFeatureType());
        this.getFeaturesPanel().setSelectedFeature(selectedFeature);
        this.getFieldsPanel().setSelectedFields(storeParameters.getFields());
        this.getOptionsPanel().setUserName(storeParameters.getUser());
        this.getOptionsPanel().setPassword(storeParameters.getPassword());
        this.getOptionsPanel().setBuffer(storeParameters.getMaxFeatures());
        this.getOptionsPanel().setTimeOut(storeParameters.getTimeOut());
        this.getOptionsPanel().setSRS(storeParameters.getCrs());
        this.getOptionsPanel().setVersion(storeParameters.getVersion());
        this.getAreaPanel().setArea(storeParameters.getFilterByAreaGeometry());
        this.getAreaPanel().setSrs(storeParameters.getFilterByAreaCrs());
    }

    private WFSSelectedFeature getSelectedFeature() {
        WFSSelectedFeature selectedFeature = this.getFeaturesPanel().getSelectedFeature();
        selectedFeature.setSelectedFields(this.getFieldsPanel().getSelectedFields());
        return selectedFeature;
    }

    public void doClickOnNextButton() {
        WizardPanel obj = this.getWizardPanel();
        if (obj == null) {
            return;
        }
        if (obj instanceof WFSWizard) {
            ((WFSWizard)this.getWizardPanel()).doClickOnNextButton();
        } else {
            this.advanceCurrentTab();
        }
    }

    public void advanceCurrentTab() {
        int currentTabIndex = this.getJTabbedPane().getSelectedIndex();
        if (currentTabIndex != -1 && currentTabIndex < this.values().size() - 1) {
            this.setSelectedIndex(currentTabIndex + 1);
        }
    }

    public void refreshWFSSelectFeaturePanel() {
        WFSSelectFeaturePanel panel = this.getFeaturesPanel();
        if (panel != null) {
            panel.refresh(null);
        }
    }

    public IProjection getSelectedFeatureProjection() {
        WFSSelectedFeature selectedFeature = this.getSelectedFeature();
        if (!selectedFeature.getSrs().isEmpty()) {
            String crs = (String)selectedFeature.getSrs().get(0);
            IProjection projection = CRSFactory.getCRS((String)(crs = this.getSRS(crs)));
            if (projection != null) {
                return projection;
            }
        }
        return null;
    }

    private String getSRS(String srs) {
        return CRSUtils.ogcProjectionToAuthorityAndCode((String)srs);
    }

    public void refresh(WFSSelectedFeature selectedFeature, List vers_list) {
        boolean hasFields = false;
        if (selectedFeature != null) {
            if ((selectedFeature = this.selectedFeatureManager.getFeatureInfo(selectedFeature.getNameSpace(), selectedFeature.getName())).getWFSFeature().getFieldSize() == 0) {
                this.setApplicable(false);
                hasFields = false;
            } else {
                this.getFieldsPanel().refresh(selectedFeature);
                this.getOptionsPanel().refresh(selectedFeature);
                this.getOptionsPanel().refreshVersions(vers_list);
                this.getAreaPanel().refresh(selectedFeature);
                hasFields = true;
            }
        }
        this.enableDefaultTabs(hasFields);
    }

    public void setApplicable(boolean isApplicable) {
        this.setEnabledApplyButton(isApplicable);
    }

    public void setEnabledApplyButton(boolean b) {
        super.setEnabledApplyButton(b);
        WizardPanel parent = this.getWizardPanel();
        if (parent != null && parent instanceof WizardPanel) {
            parent.callStateChanged(b);
        }
    }

    public void loadPanels(IPanelGroupLoader loader) throws ListCouldntAddPanelException, EmptyPanelGroupException, EmptyPanelGroupGUIException {
        if (this.getReference() != null) {
            FLyrVect lyr = (FLyrVect)this.getReference();
            DataManager dataManager = DALLocator.getDataManager();
            try {
                WFSOpenStoreParameters parameters = (WFSOpenStoreParameters)dataManager.createStoreParameters(WFSStoreProvider.NAME);
                parameters.setUrl(this.serverExplorer.getUrl());
                parameters.setVersion(this.serverExplorer.getVersion());
                super.loadPanels(loader);
            }
            catch (InitializeException | ProviderNotRegisteredException e) {
                LOGGER.warn("Can't load panels", e);
            }
            return;
        }
        super.loadPanels(loader);
    }

    public void setLayerName(String name) {
        this.getFeaturesPanel().setLayerName(name);
    }

    public void refreshInfo() {
        WFSSelectedFeature selectedFeature = this.getFeaturesPanel().getSelectedFeature();
        if (selectedFeature != null) {
            selectedFeature.setSelectedFields(this.getFieldsPanel().getSelectedFields());
        }
        this.serverExplorer.setUserName(this.getOptionsPanel().getUserName());
        this.serverExplorer.setMaxFeatures(this.getOptionsPanel().getBuffer());
        this.serverExplorer.setTimeOut(this.getOptionsPanel().getTimeout());
        this.getInfoPanel().refresh(selectedFeature);
    }

    public WFSSelectedFeatureManager getSelectedFeatureManager() {
        return this.selectedFeatureManager;
    }

    public void setSelectedCache(String selectedCache) {
        this.cacheSelected = selectedCache;
    }
}

