/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.i18n.Messages;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.remoteclient.wfs.WFSProtocolHandlerFactory;
import org.gvsig.utils.StringComparator;
import org.gvsig.wfs.gui.panels.AbstractWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;
import org.gvsig.wfs.gui.wizards.WFSWizard;

public class WFSSelectFeaturePanel
extends AbstractWFSPanel {
    private static final long serialVersionUID = -3781080396069038450L;
    private JPanel featureListPanel = null;
    private JScrollPane jScrollPane = null;
    private LayerTable lstFeatures = null;
    private JTextField txtName = null;
    private JCheckBox chkExtendedNames = null;
    private JPanel layerNamePanel = null;
    private WFSSelectedFeature layerNode = null;
    private ListSelectionListener listSelectionListener = null;

    public WFSSelectFeaturePanel() {
        this.initialize();
    }

    private JPanel getFeaturesListPanel() {
        if (this.featureListPanel == null) {
            this.featureListPanel = new JPanel();
            this.featureListPanel.setLayout(new GridBagLayout());
            this.featureListPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"select_features"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.featureListPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.featureListPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLstFeatures());
            this.jScrollPane.setToolTipText(PluginServices.getText((Object)this.jScrollPane, (String)"feature_Selection_Info"));
        }
        return this.jScrollPane;
    }

    public LayerTable getLstFeatures() {
        if (this.lstFeatures == null) {
            this.lstFeatures = new LayerTable();
            this.lstFeatures.setSelectionMode(0);
            this.lstFeatures.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
            this.lstFeatures.setToolTipText(PluginServices.getText((Object)this.lstFeatures, (String)"feature_Selection_Info"));
            this.lstFeatures.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractPanelGroup obj;
                    if (e.getClickCount() == 2 && (obj = WFSSelectFeaturePanel.this.getPanelGroup()) != null && obj instanceof WFSParamsPanel) {
                        ((WFSParamsPanel)obj).doClickOnNextButton();
                    }
                }
            });
        }
        return this.lstFeatures;
    }

    public int getSelectedFeaturesCount() {
        if (this.lstFeatures == null) {
            return 0;
        }
        ListSelectionModel m = this.lstFeatures.getSelectionModel();
        if (m == null || m.isSelectionEmpty()) {
            return 0;
        }
        int resp = 0;
        for (int i = m.getMinSelectionIndex(); i <= m.getMaxSelectionIndex(); ++i) {
            if (!m.isSelectedIndex(i)) continue;
            ++resp;
        }
        return resp;
    }

    private ListSelectionListener getListSelectionListener() {
        if (this.listSelectionListener == null) {
            this.listSelectionListener = e -> {
                AbstractPanelGroup obj;
                int n_sel;
                DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
                LayerTable.LayerTableModel t_model = (LayerTable.LayerTableModel)this.lstFeatures.getModel();
                if (t_model.isUpdatingSelection()) {
                    return;
                }
                if (model.getMinSelectionIndex() > -1 && !e.getValueIsAdjusting()) {
                    AbstractPanelGroup panelGroup1 = this.getPanelGroup();
                    if (panelGroup1 == null) {
                        return;
                    }
                    this.refreshData();
                }
                if ((n_sel = this.getSelectedFeaturesCount()) == 0 && (obj = this.getPanelGroup()) != null && obj instanceof WFSParamsPanel && (obj = ((WFSParamsPanel)obj).getWizardPanel()) instanceof WFSWizard) {
                    ((WFSWizard)obj).callStateChanged(false);
                }
            };
        }
        return this.listSelectionListener;
    }

    public JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.setBounds(6, 19, 472, 20);
            this.txtName.setText(PluginServices.getText((Object)this, (String)"WFSLayer"));
            this.txtName.setEditable(false);
            this.txtName.setBackground(Color.WHITE);
            this.txtName.setToolTipText(PluginServices.getText((Object)this.txtName, (String)"feature_to_load"));
            this.txtName.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AbstractPanelGroup panelGroup = WFSSelectFeaturePanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
        return this.txtName;
    }

    private JCheckBox getChkExtendedNames() {
        if (this.chkExtendedNames == null) {
            this.chkExtendedNames = new JCheckBox();
            this.chkExtendedNames.setText(PluginServices.getText((Object)this, (String)"show_layer_names"));
            this.chkExtendedNames.setBounds(10, 372, 382, 20);
            this.chkExtendedNames.addItemListener(e -> {
                boolean b = this.chkExtendedNames.isSelected();
                this.getLstFeatures().setShowLayerNames(b);
                this.getLstFeatures().repaint();
            });
        }
        return this.chkExtendedNames;
    }

    public void setSelectedFeature(WFSSelectedFeature layerNode) {
        int index = -1;
        for (int i = 0; i < this.getLstFeatures().getRowCount(); ++i) {
            WFSSelectedFeature node = this.getLstFeatures().getValueAt(i);
            if (node == null || !layerNode.getName().equals(node.getName())) continue;
            index = i;
        }
        if (index != -1) {
            this.getLstFeatures().changeSelection(index, 0, false, false);
        }
    }

    @Override
    public void refresh(WFSSelectedFeature layer) {
        this.unselectAllFeatures();
        this.getLstFeatures().addFeatures(this.getSelectedFeatureManager().getLayerList());
        if (layer != null) {
            this.layerNode = layer;
            this.setLayerName(layer.getName());
            this.setSelectedFeature(layer);
        }
    }

    public void refreshData() {
        WFSSelectedFeature lyr = this.getLstFeatures().getSelectedValue();
        try {
            this.getTxtName().setText(lyr.getTitle());
        }
        catch (NullPointerException e) {
            this.getTxtName().setText(PluginServices.getText((Object)this, (String)"default_name"));
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"default_name"), (Throwable)e);
        }
        AbstractPanelGroup panelGroup = this.getPanelGroup();
        if (panelGroup == null) {
            return;
        }
        WFSParamsPanel wfspp = (WFSParamsPanel)panelGroup;
        String url = wfspp.getServerExplorer().getUrl();
        List sel_ver = null;
        try {
            sel_ver = WFSProtocolHandlerFactory.getRequestableVersions(url, false);
            wfspp.refresh(lyr, sel_ver);
        }
        catch (Exception e) {
            ApplicationLocator.getManager().message(Messages.getText((String)"_Unable_to_get_server_version"), 0);
        }
        this.repaint();
    }

    private JPanel getLayerNamePanel() {
        if (this.layerNamePanel == null) {
            this.layerNamePanel = new JPanel();
            this.layerNamePanel.setLayout(new GridBagLayout());
            this.layerNamePanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"layer_name"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.layerNamePanel.add((Component)this.getTxtName(), gridBagConstraints);
        }
        return this.layerNamePanel;
    }

    public String getLayerName() {
        if (this.getLstFeatures().getSelectedValue() != null) {
            return this.getLstFeatures().getSelectedValue().getName();
        }
        return "";
    }

    public String getLayerNameSpace() {
        return this.getLstFeatures().getSelectedValue().getNameSpace();
    }

    public WFSSelectedFeature getSelectedFeature() {
        WFSSelectedFeature selectedFeature = this.getLstFeatures().getSelectedValue();
        if (selectedFeature != null) {
            this.layerNode = selectedFeature;
        }
        return this.layerNode;
    }

    public void setLayerName(String name) {
        this.getTxtName().setText(name);
    }

    @Override
    protected void initialize() {
        this.setLabel(PluginServices.getText((Object)this, (String)"feature"));
        this.setLabelGroup(PluginServices.getText((Object)this, (String)"wfs"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.getLayerNamePanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.getFeaturesListPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add(this.getChkExtendedNames(), gridBagConstraints);
    }

    @Override
    public void setReference(Object ref) {
        super.setReference(ref);
    }

    public void unselectAllFeatures() {
        int numberOfFeatures = this.getLstFeatures().getRowCount();
        if (numberOfFeatures > 0) {
            ListSelectionModel model = this.getLstFeatures().getSelectionModel();
            model.removeSelectionInterval(0, numberOfFeatures - 1);
        }
    }

    public class LayerTable
    extends JTable {
        private static final long serialVersionUID = 4700375945858283696L;
        private int headerSelected = -1;

        public LayerTable() {
            this.setModel(new LayerTableModel());
            this.getTableHeader().setUI(new BasicTableHeaderSelectableUI());
            this.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((LayerTableModel)LayerTable.this.getModel()).sort(LayerTable.this.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX()));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    LayerTable.this.headerSelected = LayerTable.this.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                    LayerTable.this.getTableHeader().repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    LayerTable.this.headerSelected = -1;
                }
            });
        }

        @Override
        public void createDefaultColumnsFromModel() {
            TableModel m = this.getModel();
            if (m != null) {
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    TableColumn newColumn = new TableColumn(i);
                    newColumn.setHeaderRenderer(new DefaultTableSelectableCellRenderer());
                    this.addColumn(newColumn);
                }
            }
        }

        public WFSSelectedFeature getSelectedValue() {
            int selectedRow = this.getSelectedRow();
            LayerTableModel model = (LayerTableModel)this.getModel();
            return model.getLayerAt(selectedRow);
        }

        public WFSSelectedFeature getValueAt(int position) {
            if (position < this.getRowCount()) {
                LayerTableModel model = (LayerTableModel)this.getModel();
                return model.getLayerAt(position);
            }
            return null;
        }

        public void addFeatures(WFSSelectedFeature[] features) {
            LayerTableModel model = (LayerTableModel)this.getModel();
            model.deleteAllRows();
            for (WFSSelectedFeature feature : features) {
                model.addRow(feature);
            }
            model.sort(0);
        }

        public void setShowLayerNames(boolean showFeatureNameType) {
            LayerTableModel model = (LayerTableModel)this.getModel();
            model.setShowedFeatureNameType(showFeatureNameType);
        }

        private class WFSLayerStringComparator
        extends StringComparator {
            public static final short LAYER_NAME = 0;
            public static final short GEOMETRY_TYPE = 1;
            protected short column = 0;
            protected boolean showFeatureNameType = false;
            protected boolean ascendingOrdering = true;

            private WFSLayerStringComparator() {
            }

            public int compare(Object o1, Object o2) {
                String s2;
                String s1;
                switch (this.column) {
                    case 0: {
                        if (this.ascendingOrdering) {
                            s1 = o1.toString();
                            s2 = o2.toString();
                        } else {
                            s1 = o2.toString();
                            s2 = o1.toString();
                        }
                        if (this.showFeatureNameType) {
                            if (this.ascendingOrdering) {
                                return super.compare(o1, o2);
                            }
                            return super.compare(o2, o1);
                        }
                        int index = s1.indexOf(93);
                        s1 = index > 0 ? s1.substring(index, s1.length()).trim() : s1.trim();
                        index = s2.indexOf(93);
                        if (index > 0) {
                            s2 = s2.substring(index, s2.length()).trim();
                            break;
                        }
                        s2 = s2.trim();
                        break;
                    }
                    case 1: {
                        WFSFeatureField gType = ((WFSSelectedFeature)o1).getGeometryField();
                        String s12 = gType == null ? "" : gType.getName();
                        gType = ((WFSSelectedFeature)o2).getGeometryField();
                        String s22 = gType == null ? "" : gType.getName();
                        if (this.ascendingOrdering) {
                            return super.compare((Object)s12, (Object)s22);
                        }
                        return super.compare((Object)s22, (Object)s12);
                    }
                    default: {
                        return 0;
                    }
                }
                if (this.getLocaleRules() == null) {
                    if (this.isCaseSensitive()) {
                        return s1.compareTo(s2);
                    }
                    return s1.compareToIgnoreCase(s2);
                }
                if (this.getLocaleRules().isUseLocaleRules()) {
                    Collator collator = this.getLocaleRules().getCollator();
                    if (this.isCaseSensitive()) {
                        return collator.compare(s1, s2);
                    }
                    return collator.compare(s1.toUpperCase(), s2.toUpperCase());
                }
                if (this.isCaseSensitive()) {
                    return s1.compareTo(s2);
                }
                return s1.compareToIgnoreCase(s2);
            }

            public boolean isShowFeatureNameType() {
                return this.showFeatureNameType;
            }

            public void setShowFeatureNameType(boolean showFeatureNameType) {
                this.showFeatureNameType = showFeatureNameType;
            }

            public void setColumn(short column) {
                this.column = column;
            }

            public void setAscendingOrdering(boolean b) {
                this.ascendingOrdering = b;
            }

            public boolean isAscendingOrdering() {
                return this.ascendingOrdering;
            }
        }

        private class DefaultTableSelectableCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -3896516869747447668L;

            private DefaultTableSelectableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color bgColor = LayerTable.this.getTableHeader().getBackground();
                if (isSelected) {
                    comp.setBackground(new Color(bgColor.getRed() - 10, bgColor.getGreen() - 10, bgColor.getBlue() - 10));
                } else {
                    comp.setBackground(bgColor);
                }
                ((JLabel)comp).setText(value == null ? "" : value.toString());
                ((JLabel)comp).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return comp;
            }
        }

        private class BasicTableHeaderSelectableUI
        extends BasicTableHeaderUI {
            @Override
            public void paint(Graphics g, JComponent c) {
                int column;
                if (this.header.getColumnModel().getColumnCount() <= 0) {
                    return;
                }
                boolean ltr = this.header.getComponentOrientation().isLeftToRight();
                Rectangle clip = g.getClipBounds();
                Point left = clip.getLocation();
                Point right = new Point(clip.x + clip.width - 1, clip.y);
                TableColumnModel cm = this.header.getColumnModel();
                int cMin = this.header.columnAtPoint(ltr ? left : right);
                int cMax = this.header.columnAtPoint(ltr ? right : left);
                if (cMin == -1) {
                    cMin = 0;
                }
                if (cMax == -1) {
                    cMax = cm.getColumnCount() - 1;
                }
                TableColumn draggedColumn = this.header.getDraggedColumn();
                Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
                if (ltr) {
                    for (column = cMin; column <= cMax; ++column) {
                        int columnWidth;
                        TableColumn aColumn = cm.getColumn(column);
                        cellRect.width = columnWidth = aColumn.getWidth();
                        if (aColumn != draggedColumn) {
                            this.paintCell(g, cellRect, column);
                        }
                        cellRect.x += columnWidth;
                    }
                } else {
                    for (column = cMax; column >= cMin; --column) {
                        int columnWidth;
                        TableColumn aColumn = cm.getColumn(column);
                        cellRect.width = columnWidth = aColumn.getWidth();
                        if (aColumn != draggedColumn) {
                            this.paintCell(g, cellRect, column);
                        }
                        cellRect.x += columnWidth;
                    }
                }
                if (draggedColumn != null) {
                    int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
                    Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
                    g.setColor(this.header.getParent().getBackground());
                    g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
                    draggedCellRect.x += this.header.getDraggedDistance();
                    g.setColor(this.header.getBackground());
                    g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
                    this.paintCell(g, draggedCellRect, draggedColumnIndex);
                }
                this.rendererPane.removeAll();
            }

            private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
                Component component = this.getHeaderRenderer(columnIndex);
                this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }

            private Component getHeaderRenderer(int columnIndex) {
                TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    renderer = this.header.getDefaultRenderer();
                }
                if (LayerTable.this.headerSelected == columnIndex) {
                    LayerTable.this.headerSelected = -1;
                    return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), true, false, -1, columnIndex);
                }
                return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
            }

            private int viewIndexForColumn(TableColumn aColumn) {
                TableColumnModel cm = this.header.getColumnModel();
                for (int column = 0; column < cm.getColumnCount(); ++column) {
                    if (cm.getColumn(column) != aColumn) continue;
                    return column;
                }
                return -1;
            }
        }

        public class LayerTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 2722138264867593508L;
            private final List<WFSSelectedFeature> layers = new ArrayList<WFSSelectedFeature>();
            private boolean showFeatureNameType = false;
            private final WFSLayerStringComparator stringComparator;
            private boolean updatingSelection = false;
            private short previousColumnSorted = (short)-1;

            public LayerTableModel() {
                Collator collator = Collator.getInstance(new Locale("en_EN"));
                WFSLayerStringComparator wFSLayerStringComparator = this.stringComparator = new WFSLayerStringComparator();
                ((Object)((Object)wFSLayerStringComparator)).getClass();
                this.stringComparator.setLocaleRules(new StringComparator.LocaleRules((StringComparator)wFSLayerStringComparator, true, collator));
                this.stringComparator.setCaseSensitive(false);
                this.stringComparator.setAscendingOrdering(true);
            }

            @Override
            public int getRowCount() {
                return this.layers.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowNumber, int columnNumber) {
                if (rowNumber < this.layers.size()) {
                    WFSSelectedFeature layer = this.layers.get(rowNumber);
                    if (columnNumber == 0) {
                        return this.getLayerName(layer);
                    }
                    if (layer.getGeometryField() != null) {
                        return PluginServices.getText((Object)this, (String)layer.getGeometryField().getType());
                    }
                    return "";
                }
                return "";
            }

            private String getLayerName(WFSSelectedFeature layer) {
                if (this.showFeatureNameType) {
                    return "[" + layer.getName() + "] " + layer.getTitle();
                }
                return layer.getTitle();
            }

            public WFSSelectedFeature getLayerAt(int rowNumber) {
                try {
                    if (rowNumber == -1) {
                        return null;
                    }
                    return this.layers.get(rowNumber);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    NotificationManager.addError((Throwable)e);
                    return null;
                }
            }

            public void addRow(WFSSelectedFeature layer) {
                this.layers.add(layer);
                this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
                this.fireTableRowsUpdated(0, this.getRowCount());
                this.previousColumnSorted = (short)-1;
            }

            public void deleteAllRows() {
                this.layers.clear();
                int rows = this.getRowCount();
                if (rows >= 1) {
                    this.fireTableRowsDeleted(0, rows - 1);
                }
            }

            public void deleteRow(int rowPosition) {
                this.layers.remove(rowPosition);
                this.fireTableRowsDeleted(rowPosition, rowPosition);
                this.fireTableRowsUpdated(0, this.getRowCount());
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return PluginServices.getText((Object)this, (String)"layerName");
                }
                return PluginServices.getText((Object)this, (String)"layerType");
            }

            public boolean isShowedFeatureNameType() {
                return this.showFeatureNameType;
            }

            public void setShowedFeatureNameType(boolean showFeatureNameType) {
                this.showFeatureNameType = showFeatureNameType;
                this.stringComparator.setShowFeatureNameType(showFeatureNameType);
            }

            public void sort(int column) {
                switch (column) {
                    case 0: {
                        this.stringComparator.setColumn((short)0);
                        break;
                    }
                    case 1: {
                        this.stringComparator.setColumn((short)1);
                    }
                }
                if (this.previousColumnSorted != column) {
                    this.stringComparator.setAscendingOrdering(true);
                }
                this.previousColumnSorted = (short)column;
                WFSSelectedFeature layer = LayerTable.this.getSelectedValue();
                Collections.sort(this.layers, this.stringComparator);
                if (layer != null) {
                    this.updatingSelection = true;
                    WFSSelectFeaturePanel.this.unselectAllFeatures();
                    int row = Collections.binarySearch(this.layers, layer, this.stringComparator);
                    if (row != -1) {
                        ListSelectionModel model = LayerTable.this.getSelectionModel();
                        model.setLeadSelectionIndex(row);
                    }
                    this.updatingSelection = false;
                }
                this.stringComparator.setAscendingOrdering(!this.stringComparator.isAscendingOrdering());
            }

            public boolean isUpdatingSelection() {
                return this.updatingSelection;
            }
        }
    }
}

