/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.awt.Color;
import java.util.Vector;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.wfs.gui.panels.fieldstree.TetraStateCheckBox;

public class CheckBoxNode
extends TetraStateCheckBox {
    private WFSFeatureField featureField = null;
    private String featureFieldName = null;
    private CheckBoxNode parent = null;
    private Vector children = new Vector();

    public CheckBoxNode(WFSFeatureField featureField, CheckBoxNode parent) {
        this.parent = parent;
        this.initialize(featureField);
        this.setSelected(true);
    }

    private void initialize(WFSFeature feature) {
        this.setBackground(Color.WHITE);
        this.featureFieldName = CheckBoxNode.fillNameWithBlancs(feature.getName());
        this.setText(this.featureFieldName);
        for (int i = 0; i < feature.getFieldSize(); ++i) {
            this.children.add(new CheckBoxNode(feature.getFieldAt(i), this));
        }
    }

    private void initialize(WFSFeatureField featureField) {
        this.setBackground(Color.WHITE);
        this.featureFieldName = CheckBoxNode.fillNameWithBlancs(featureField.getName());
        this.setText(this.featureFieldName);
        this.featureField = featureField;
        for (int i = 0; i < featureField.getFieldSize(); ++i) {
            this.children.add(new CheckBoxNode(featureField.getFieldAt(i), this));
        }
        if (featureField.isGeometry()) {
            this.setSelected(true);
        }
    }

    public static int getTextLength() {
        return 200;
    }

    public static String fillNameWithBlancs(String name) {
        String withBlancs = name;
        for (int i = name.length(); i < CheckBoxNode.getTextLength(); ++i) {
            name = name + " ";
        }
        return name;
    }

    public WFSFeatureField getFeatureField() {
        return this.featureField;
    }

    public Vector getChildren() {
        return this.children;
    }

    @Override
    public String toString() {
        return this.featureFieldName;
    }

    public CheckBoxNode getParentNode() {
        return this.parent;
    }
}

