/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxNode;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxTreeCellRenderer;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTable;

public class CheckBoxTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    CheckBoxTreeCellRenderer renderer = null;
    ChangeEvent changeEvent = null;
    JTree tree;
    FieldsTreeTable treetable;

    public CheckBoxTreeCellEditor(FieldsTreeTable treetable) {
        this.treetable = treetable;
        this.tree = (JTree)treetable.getTree();
        this.renderer = new CheckBoxTreeCellRenderer(treetable);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof CheckBoxNode) {
            CheckBoxNode selectedNode = (CheckBoxNode)node;
            if (mouseEvent.getClickCount() != 2 && mouseEvent.getClickCount() == 1) {
                if (!selectedNode.getFeatureField().isGeometry()) {
                    this.changeAllChildren(selectedNode, !selectedNode.isSelected());
                    this.changeParentState(selectedNode, !selectedNode.isSelected());
                    selectedNode.setSelected(!selectedNode.isSelected());
                }
                this.tree.repaint();
            }
        }
        return false;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        if (editor instanceof JCheckBox) {
            // empty if block
        }
        return editor;
    }

    private void changeParentState(CheckBoxNode selectedNode, boolean isSelected) {
        CheckBoxNode parent = selectedNode.getParentNode();
        while (parent != null) {
            if (isSelected != parent.isSelected()) {
                parent.setColor(1);
            } else {
                boolean isEnabled = true;
                for (int i = 0; i < parent.getChildren().size(); ++i) {
                    CheckBoxNode child = (CheckBoxNode)parent.getChildren().get(i);
                    if (child == selectedNode || parent.isSelected() == child.isSelected()) continue;
                    isEnabled = false;
                }
                if (!isEnabled) {
                    parent.setColor(1);
                } else {
                    parent.setColor(0);
                }
            }
            selectedNode = parent;
            parent = selectedNode.getParentNode();
        }
    }

    private void changeAllChildren(CheckBoxNode selectedNode, boolean selected) {
        for (int i = 0; i < selectedNode.getChildren().size(); ++i) {
            CheckBoxNode child = (CheckBoxNode)selectedNode.getChildren().get(i);
            if (child.getFeatureField().isGeometry()) {
                child.setSelected(true);
                continue;
            }
            child.setSelected(selected);
            if (child.getChildren().size() <= 0) continue;
            this.changeAllChildren(child, selected);
        }
    }
}

