/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.model;

import java.util.Vector;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSFeatureField;

public class WFSSelectedFeature {
    private WFSFeature feature = null;
    private Vector selectedFields = new Vector();
    private String filter = null;
    private Vector srs = new Vector();
    private BoundaryBox latLonBbox = null;
    private WFSFeatureField geometryField = null;

    public WFSSelectedFeature(WFSFeature feature) {
        this.feature = feature;
    }

    public WFSFeature getWFSFeature() {
        return this.feature;
    }

    public String toString() {
        String str = this.getName() == null ? this.getTitle() : "[" + this.getName() + "] " + this.getTitle();
        return str;
    }

    public String getAbstract() {
        return this.feature.getAbstract();
    }

    public String getName() {
        return this.feature.getName();
    }

    public String getTitle() {
        return this.feature.getTitle();
    }

    public Vector getSelectedFields() {
        return this.selectedFields;
    }

    public void setSelectedFields(Vector selectedFields) {
        this.selectedFields = selectedFields;
    }

    public void setSelectedFields(Object[] selectedFields) {
        this.selectedFields.clear();
        for (int i = 0; i < selectedFields.length; ++i) {
            this.selectedFields.add(selectedFields[i]);
        }
    }

    public Vector getSrs() {
        return this.feature.getSrs();
    }

    public BoundaryBox getLatLonBbox() {
        return this.feature.getLatLonBbox();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getNameSpace() {
        if (this.feature.getNamespace() != null) {
            return this.feature.getNamespace().getLocation();
        }
        return null;
    }

    public void setFeature(WFSFeature feature) {
        this.feature = feature;
    }

    public WFSFeatureField getGeometryField() {
        if (this.geometryField == null) {
            for (int i = 0; i < this.getWFSFeature().getFieldSize(); ++i) {
                WFSFeatureField field = this.getWFSFeature().getFieldAt(i);
                if (!field.isGeometry()) continue;
                this.geometryField = field;
            }
        }
        return this.geometryField;
    }
}

