/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.utils.StringComparator;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSSelectedFeatureManager {
    private static final Logger LOG = LoggerFactory.getLogger(WFSSelectedFeatureManager.class);
    private WFSServerExplorer serverExplorer = null;
    private Hashtable hashFeatures;
    private WFSSelectedFeature[] featuresList;
    private static HashMap featureManagers = new HashMap();

    public static WFSSelectedFeatureManager getInstance(WFSServerExplorer serverExplorer) {
        if (featureManagers.containsKey((Object)serverExplorer)) {
            return (WFSSelectedFeatureManager)featureManagers.get((Object)serverExplorer);
        }
        WFSSelectedFeatureManager selectedFeatureManager = new WFSSelectedFeatureManager(serverExplorer);
        featureManagers.put(serverExplorer, selectedFeatureManager);
        return selectedFeatureManager;
    }

    private WFSSelectedFeatureManager(WFSServerExplorer serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public WFSSelectedFeature getFeatureInfo(String nameSpace, String layerName) {
        if (this.hashFeatures == null) {
            this.getLayerList();
        }
        WFSSelectedFeature selectedFeature = (WFSSelectedFeature)this.hashFeatures.get(layerName);
        try {
            WFSFeature feature = this.serverExplorer.getFeatureInfo(nameSpace, layerName);
            selectedFeature.setFeature(feature);
        }
        catch (WFSException e) {
            LOG.error("Impossible to get the feature", (Throwable)e);
        }
        return selectedFeature;
    }

    public WFSSelectedFeature[] getLayerList() {
        if (this.hashFeatures == null) {
            this.hashFeatures = new Hashtable();
            Hashtable wfsFeatures = this.serverExplorer.getFeatures();
            StringComparator stringComparator = new StringComparator();
            Collator collator = Collator.getInstance(new Locale("es_ES"));
            StringComparator stringComparator2 = stringComparator;
            stringComparator2.getClass();
            stringComparator.setLocaleRules(new StringComparator.LocaleRules(stringComparator2, true, collator));
            stringComparator.setCaseSensitive(false);
            ArrayList keysList = new ArrayList(wfsFeatures.keySet());
            Collections.sort(keysList, stringComparator);
            Iterator keys = keysList.iterator();
            this.featuresList = new WFSSelectedFeature[wfsFeatures.size()];
            for (int i = 0; i < wfsFeatures.size(); ++i) {
                WFSSelectedFeature selectedFeature;
                WFSFeature feature = (WFSFeature)wfsFeatures.get(keys.next());
                this.featuresList[i] = selectedFeature = new WFSSelectedFeature(feature);
                this.hashFeatures.put(selectedFeature.getName(), selectedFeature);
            }
        }
        return this.featuresList;
    }
}

