/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionAdapter;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class ShowTable
extends Extension {
    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (doc == null) {
            return false;
        }
        MapContext mapContext = doc.getMapContext();
        return mapContext.hasActiveVectorLayers();
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (doc == null) {
            return false;
        }
        MapContext mapContext = doc.getMapContext();
        return mapContext.hasVectorLayers();
    }

    public void execute(String command) {
        this.execute(command, null);
    }

    public void execute(String command, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        if ("layer-show-attributes-table".equalsIgnoreCase(command)) {
            ApplicationManager application = ApplicationLocator.getManager();
            FLayer[] layers = (FLayer[])arguments.get(0);
            if (layers == null) {
                ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
                if (doc == null) {
                    return;
                }
                MapContext mapContext = doc.getMapContext();
                layers = mapContext.getLayers().getActives();
            }
            Project project = application.getCurrentProject();
            TableManager tableManager = this.getTableManager();
            for (FLayer layer : layers) {
                if (!(layer instanceof FLyrVect)) continue;
                final FLyrVect layerVect = (FLyrVect)layer;
                TableDocument tableDoc = tableManager.getTableDocument((VectorLayer)layerVect);
                if (tableDoc == null) {
                    tableDoc = tableManager.getTableDocument(layerVect.getFeatureStore());
                    if (tableDoc == null) {
                        tableDoc = (TableDocument)tableManager.createDocument();
                        tableDoc.setName(layerVect.getName());
                        tableDoc.setStore(layerVect.getFeatureStore());
                        layerVect.getParentLayer().addLayerCollectionListener((LayerCollectionListener)new LayerCollectionAdapter(){

                            public void layerRemoved(LayerCollectionEvent e) {
                                FLayer layer = e.getAffectedLayer();
                                if (layer == layerVect) {
                                    ShowTable.this.getTableManager().removeTableDocument((VectorLayer)((FLyrVect)layer));
                                    FLayers layers = layer.getParentLayer();
                                    if (layers != null && layers.getLayersCount() == 0) {
                                        layers.removeLayerCollectionListener((LayerCollectionListener)this);
                                    }
                                }
                            }
                        });
                        project.addDocument((Document)tableDoc);
                    }
                    tableDoc.setAssociatedLayer((VectorLayer)layerVect);
                }
                try {
                    FeatureStore store = tableDoc.getDataStore();
                    FeatureType type = store.getDefaultFeatureType();
                    if (!type.supportReferences()) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                        dialogs.messageDialog("\"" + store.getName() + "\"\n" + i18n.getTranslation("_The_table_has_no_primary_key_or_OID") + "\n" + i18n.getTranslation("_Many_features_selection_deletion_modification_will_not_be_available_as_they_require_it_for_proper_operation"), null, i18n.getTranslation("_Warning"), 2, "TableDoNotSupportReferences");
                    }
                }
                catch (Exception store) {
                    // empty catch block
                }
                IWindow tablePanel = tableManager.getMainWindow((Document)tableDoc);
                tableDoc.setModified(true);
                ToolsSwingUtils.ensureHeightWitdh((JComponent)((Component)tablePanel).asJComponent(), (int)1, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
                application.getUIManager().addWindow(tablePanel);
            }
        }
    }

    private TableManager getTableManager() {
        ApplicationManager application = ApplicationLocator.getManager();
        DocumentManager tableManager = application.getProjectManager().getDocumentManager(TableManager.TYPENAME);
        return (TableManager)tableManager;
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-show-attributes-table", (Object)((Object)this));
    }
}

