/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.AbstractTableEditExtension;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.arguments.Arguments;

public class TableEditStartExtension
extends AbstractTableEditExtension {
    @Override
    public void initialize() {
        super.initialize();
        IconThemeHelper.registerIcon((String)"action", (String)"table-start-editing", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        if ("table-start-editing".equals(actionCommand)) {
            try {
                EditingNotificationManager editingNotification;
                EditingNotification notification;
                TableDocument doc = (TableDocument)((Object)arguments.get(0));
                if (doc == null) {
                    doc = (TableDocument)this.table.getDocument();
                }
                if ((notification = (editingNotification = DALSwingLocator.getEditingNotificationManager()).notifyObservers((Object)this, "BEFORE_ENTER_EDITING_STORE", (Object)doc, (DataStore)doc.getStore())).isCanceled()) {
                    return;
                }
                doc.getStore().edit(1);
                ApplicationLocator.getManager().refreshMenusAndToolBars();
                editingNotification.notifyObservers((Object)this, "AFTER_ENTER_EDITING_STORE", (Object)doc, (DataStore)doc.getStore());
            }
            catch (DataException e) {
                logger.warn("Problems starting table editing.", (Throwable)e);
            }
        }
    }

    public boolean isEnabled() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        if (v instanceof FeatureTableDocumentPanel) {
            try {
                FeatureTableDocumentPanel t = (FeatureTableDocumentPanel)v;
                FeatureStore fs = t.getModel().getStore();
                return fs.supportReferences();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        if (v instanceof FeatureTableDocumentPanel && !((FeatureTableDocumentPanel)v).getModel().getStore().isEditing()) {
            this.table = (FeatureTableDocumentPanel)v;
            return true;
        }
        return false;
    }
}

