/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTable;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFieldOperations
extends Extension {
    private static Logger logger = LoggerFactory.getLogger(TableFieldOperations.class);
    private FeatureTableDocumentPanel table = null;

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-order-desc", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"table-order-asc", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"selection-duplicates", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        this.doExecute(actionCommand, this.table);
    }

    protected void doExecute(String actionCommand, FeatureTableDocumentPanel table) {
        ConfigurableFeatureTableModel cftm = table.getTablePanel().getTableModel();
        try {
            if ("table-order-asc".equals(actionCommand)) {
                cftm.orderByColumn(table.getTablePanel().getTable().getSelectedColumnsAttributeDescriptor()[0].getName(), true);
                table.getModel().setModified(true);
            } else if ("table-order-desc".equals(actionCommand)) {
                cftm.orderByColumn(table.getTablePanel().getTable().getSelectedColumnsAttributeDescriptor()[0].getName(), false);
                table.getModel().setModified(true);
            } else if ("selection-duplicates".equals(actionCommand)) {
                long[] valCases = this.findSelectDuplicates(table);
                String msg = "";
                if (valCases[0] == 0L) {
                    msg = Messages.getText((String)"_No_repetitions_found");
                } else {
                    String[] args = new String[]{Long.toString(valCases[0]), Long.toString(valCases[1])};
                    msg = Messages.getText((String)"_Found_N_diff_repeated_vals_in_total_N_cases", (String[])args);
                }
                JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), msg, Messages.getText((String)"_Find_and_select_duplicates"), 1);
            }
        }
        catch (BaseException e) {
            logger.error("While applying field operation (" + actionCommand + ")", (Throwable)e);
        }
    }

    private long[] findSelectDuplicates(FeatureTableDocumentPanel tpanel) throws DataException {
        long[] values_cases = new long[]{0L, 0L};
        ConfigurableFeatureTableModel cftm = tpanel.getTablePanel().getTableModel();
        FeatureTable ftable = tpanel.getTablePanel().getTable();
        String fieldName = ftable.getSelectedColumnsAttributeDescriptor()[0].getName();
        FeatureStore fstore = cftm.getFeatureStore();
        Set selFeats = DALLocator.getDataManager().createLargeSet();
        FeatureQuery fquery = fstore.createFeatureQuery();
        FeatureQueryOrder fqo = fquery.getOrder();
        fqo.add(fieldName, true);
        fquery.setOrder(fqo);
        FeatureSet fset = fstore.getFeatureSet(fquery);
        DisposableIterator iter = fset.fastIterator();
        Feature currFeat = null;
        Feature prevFeat = null;
        Object curVal = null;
        Object preVal = null;
        if (!iter.hasNext()) {
            iter.dispose();
            return values_cases;
        }
        currFeat = (Feature)iter.next();
        currFeat = currFeat.getCopy();
        curVal = currFeat.get(fieldName);
        boolean equals = false;
        while (iter.hasNext()) {
            prevFeat = currFeat;
            currFeat = (Feature)iter.next();
            preVal = curVal;
            if (this.sameValue(preVal, curVal = (currFeat = currFeat.getCopy()).get(fieldName))) {
                if (!equals) {
                    values_cases[0] = values_cases[0] + 1L;
                }
                equals = true;
                selFeats.add(prevFeat.getReference().getCode());
                continue;
            }
            if (equals) {
                selFeats.add(prevFeat.getReference().getCode());
            }
            equals = false;
        }
        iter.dispose();
        FeatureSelection fsele = (FeatureSelection)fstore.getSelection();
        fsele.beginComplexNotification();
        fsele.deselectAll();
        values_cases[1] = selFeats.size();
        if (values_cases[1] > 0L) {
            Iterator fiter = selFeats.iterator();
            while (fiter.hasNext()) {
                fsele.select(fstore.getFeatureReference((String)fiter.next()));
            }
        }
        fsele.endComplexNotification();
        return values_cases;
    }

    private boolean sameValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public boolean isEnabled() {
        try {
            return this.table.getTablePanel().getTable().getSelectedColumnCount() == 1;
        }
        catch (DataException e) {
            logger.error("While getting number of selected rows.", (Throwable)e);
            return false;
        }
    }

    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v != null && v instanceof FeatureTableDocumentPanel) {
            this.table = (FeatureTableDocumentPanel)v;
            return true;
        }
        return false;
    }
}

