/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;

public class TableRowsOperations
extends Extension {
    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-move-up", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"selection-disable-move-up", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"selection-reverse", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        FeatureTableDocumentPanel tableDocument = this.getTableDocument();
        if (actionCommand.equalsIgnoreCase("selection-disable-move-up")) {
            tableDocument.setSelectionUp(false);
        }
        if (actionCommand.equalsIgnoreCase("selection-move-up")) {
            tableDocument.setSelectionUp(true);
            tableDocument.getModel().setModified(true);
        }
        if (actionCommand.equalsIgnoreCase("selection-reverse")) {
            this.invertSelection(tableDocument);
            tableDocument.getModel().setModified(true);
        }
    }

    private void invertSelection(FeatureTableDocumentPanel table) {
        try {
            FeatureStore fs = this.getTableDocument().getModel().getStore();
            fs.getFeatureSelection().reverse();
        }
        catch (DataException e) {
            logger.warn("Can't invert selecction", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        FeatureTableDocumentPanel panel = this.getTableDocument();
        if (panel == null) {
            return false;
        }
        FeatureStore store = panel.getFeatureStore();
        try {
            if (!store.getFeatureSelection().isAvailable()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isVisible() {
        return this.getTableDocument() != null;
    }

    private FeatureTableDocumentPanel getTableDocument() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v != null && v instanceof FeatureTableDocumentPanel) {
            return (FeatureTableDocumentPanel)v;
        }
        return null;
    }

    private boolean thereIsSelection(FeatureTableDocumentPanel tabledoc) {
        if (tabledoc != null) {
            return !tabledoc.getModel().getStore().isFeatureSelectionEmpty();
        }
        return false;
    }
}

