/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;

public class CreateNewAttributePanel
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = 6447641307779709964L;
    private static final String DEFAULT_FIELD_LENGTH = "50";
    private JLabel jLblFieldName = null;
    private JTextField jTxtFieldName = null;
    private JLabel jLblFieldType = null;
    private JComboBox jCboFieldType = null;
    private JLabel jLblFieldLength = null;
    private JTextField jTxtFieldLength = null;
    private JLabel jLblFieldPrecision = null;
    private JTextField jTxtFieldPrecision = null;
    private JLabel jLblDefaultValue = null;
    private JTextField jTxtDefaultValue = null;
    private JLabel jLblExpression = null;
    private JTextField jTxtExpression = null;
    private JRadioButton jRdbFieldReal = null;
    private JRadioButton jRdbFieldVirtual = null;
    private JButton jBtnExpression = null;
    private WindowInfo viewInfo;
    private JPanel jPanel = null;
    private AcceptCancelPanel jPanelOkCancel = null;
    private JPanel jPnlFields = null;
    private int maxAttributeNameSize = -1;
    private KeyListener checkInt = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            JTextField component = (JTextField)e.getComponent();
            try {
                component.setText(String.valueOf(Integer.parseInt(component.getText())));
            }
            catch (Exception ex) {
                String text = component.getText();
                text = text.length() <= 1 ? "0" : text.substring(0, text.length() - 1);
                component.setText(text);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };
    private String[] currentFieldNames;
    private ExpressionPickerController expressionPicker;
    private FeatureStore store;

    public CreateNewAttributePanel(FeatureStore store) {
        this.store = store;
        this.initialize();
    }

    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            this.viewInfo = new WindowInfo(8);
            this.viewInfo.setWidth(this.getWidth() + 8);
            this.viewInfo.setHeight(this.getHeight());
            this.viewInfo.setTitle(PluginServices.getText((Object)this, (String)"new_field_properties"));
        }
        return this.viewInfo;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 310);
        this.setPreferredSize(new Dimension(300, 310));
        this.add((Component)this.getJPanel(), "Center");
        this.add((Component)this.getJPanelOkCancel(), "South");
        this.jBtnExpression.setText("");
        ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
        this.expressionPicker = manager.createExpressionPickerController((JTextComponent)this.jTxtExpression, this.jBtnExpression);
        if (this.store != null) {
            Element element = manager.createElement("DAL.FeatureStoreExpressionElement", new Object[]{this.expressionPicker, this.store});
            if (element != null) {
                this.expressionPicker.getConfig().addElement(element);
            }
            Feature sampleFeature = null;
            try {
                sampleFeature = this.store.getFeatureSelection().first();
                if (sampleFeature == null) {
                    sampleFeature = this.store.first();
                }
            }
            catch (DataException dataException) {
                // empty catch block
            }
            if (sampleFeature != null) {
                FeatureSymbolTable featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
                featureSymbolTable.setFeature(sampleFeature);
                this.expressionPicker.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
            }
        }
    }

    private JTextField getJTxtFieldName() {
        if (this.jTxtFieldName == null) {
            this.jTxtFieldName = new JTextField();
            this.jTxtFieldName.setBounds(new Rectangle(147, 15, 138, 22));
        }
        return this.jTxtFieldName;
    }

    private JComboBox getJCboFieldType() {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        if (this.jCboFieldType == null) {
            this.jCboFieldType = new JComboBox();
            this.jCboFieldType.setBounds(new Rectangle(147, 52, 138, 22));
            this.jCboFieldType.addItem(manager.getTypeName(1));
            this.jCboFieldType.addItem(manager.getTypeName(9));
            this.jCboFieldType.addItem(manager.getTypeName(4));
            this.jCboFieldType.addItem(manager.getTypeName(7));
            this.jCboFieldType.addItem(manager.getTypeName(8));
            this.jCboFieldType.setSelectedIndex(4);
            this.jCboFieldType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTypesManager manager = ToolsLocator.getDataTypesManager();
                    String strType = (String)CreateNewAttributePanel.this.getJCboFieldType().getModel().getSelectedItem();
                    if (strType == manager.getTypeName(7)) {
                        CreateNewAttributePanel.this.getJTxtFieldPrecision().setEnabled(true);
                        if (CreateNewAttributePanel.this.getJTxtFieldPrecision().getText().equals("")) {
                            CreateNewAttributePanel.this.getJTxtFieldPrecision().setText("3");
                        } else {
                            try {
                                Integer.parseInt(CreateNewAttributePanel.this.getJTxtFieldPrecision().getText());
                            }
                            catch (NumberFormatException e1) {
                                CreateNewAttributePanel.this.getJTxtFieldPrecision().setText("3");
                            }
                        }
                    } else {
                        CreateNewAttributePanel.this.getJTxtFieldPrecision().setEnabled(false);
                    }
                    if (strType == manager.getTypeName(1)) {
                        CreateNewAttributePanel.this.getJTxtFieldLength().setText("0");
                        CreateNewAttributePanel.this.getJTxtFieldLength().setEnabled(false);
                    } else {
                        CreateNewAttributePanel.this.getJTxtFieldLength().setEnabled(true);
                    }
                }
            });
        }
        return this.jCboFieldType;
    }

    private JTextField getJTxtFieldLength() {
        if (this.jTxtFieldLength == null) {
            this.jTxtFieldLength = new JTextField();
            this.jTxtFieldLength.setBounds(new Rectangle(147, 89, 138, 22));
            this.jTxtFieldLength.setText(DEFAULT_FIELD_LENGTH);
            this.jTxtFieldLength.addKeyListener(this.checkInt);
        }
        return this.jTxtFieldLength;
    }

    private JTextField getJTxtFieldPrecision() {
        if (this.jTxtFieldPrecision == null) {
            this.jTxtFieldPrecision = new JTextField();
            this.jTxtFieldPrecision.setBounds(new Rectangle(147, 126, 138, 22));
            this.jTxtFieldPrecision.setEnabled(false);
            this.jTxtFieldPrecision.addKeyListener(this.checkInt);
        }
        return this.jTxtFieldPrecision;
    }

    private JTextField getJTxtDefaultValue() {
        if (this.jTxtDefaultValue == null) {
            this.jTxtDefaultValue = new JTextField();
            this.jTxtDefaultValue.setBounds(new Rectangle(147, 200, 138, 22));
        }
        return this.jTxtDefaultValue;
    }

    public EditableFeatureAttributeDescriptor loadFieldDescription(EditableFeatureType featureType) throws ParseException {
        String nameAttr = "";
        int typeAttr = 8;
        int sizeAttr = 0;
        int precisionAttr = 0;
        String defaultValueAttr = "";
        nameAttr = this.getJTxtFieldName().getText();
        if (nameAttr == null || nameAttr.length() == 0) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"_No_input_name"), Messages.getText((String)"_Rename_column"), 0);
            return null;
        }
        if (this.maxAttributeNameSize > 0 && nameAttr.length() > this.maxAttributeNameSize) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"_Name_too_long"), Messages.getText((String)"_Rename_column"), 0);
            return null;
        }
        String strType = (String)this.getJCboFieldType().getModel().getSelectedItem();
        typeAttr = ToolsLocator.getDataTypesManager().getType(strType);
        try {
            int fieldLength;
            sizeAttr = fieldLength = Integer.parseInt(this.getJTxtFieldLength().getText());
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if (typeAttr == 7) {
            try {
                precisionAttr = Integer.parseInt(this.getJTxtFieldPrecision().getText());
            }
            catch (NumberFormatException e) {
                precisionAttr = 3;
            }
        }
        if (featureType.getIndex(nameAttr) != -1) {
            NotificationManager.showMessageInfo((String)PluginServices.getText((Object)this, (String)"field_already_exists"), null);
            return null;
        }
        EditableFeatureAttributeDescriptor ead = null;
        if (this.getJRdbFieldVirtual().isSelected()) {
            FeatureAttributeEmulatorExpression myEmulated = DALLocator.getDataManager().createFeatureAttributeEmulatorExpression((FeatureType)featureType, this.expressionPicker.get());
            if (!myEmulated.isValid()) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                ApplicationManager application = ApplicationLocator.getManager();
                int x = application.confirmDialog("The expression used in this field is not valid.\n\n" + myEmulated.getErrorMessage() + "\n\n" + "Do you want add this field anyway?", "Add invalid field", 0, 3, "_AddingInvalidField.DoYouWantAddAnyway");
                if (x == 0) {
                    ead = featureType.add(nameAttr, typeAttr, (FeatureAttributeEmulator)myEmulated).setSize(sizeAttr);
                }
            } else {
                ead = featureType.add(nameAttr, typeAttr, (FeatureAttributeEmulator)myEmulated).setSize(sizeAttr);
            }
        } else {
            defaultValueAttr = this.getJTxtDefaultValue().getText();
            if (defaultValueAttr.equals("")) {
                defaultValueAttr = null;
            }
            ead = featureType.add(nameAttr, typeAttr, sizeAttr);
            ead.setPrecision(precisionAttr);
            ead.setDefaultValue((Object)defaultValueAttr);
        }
        return ead;
    }

    public void setOkAction(ActionListener okAction) {
        this.getJPanelOkCancel().setOkButtonActionListener(okAction);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.add((Component)this.getJPnlFields(), null);
        }
        return this.jPanel;
    }

    private AcceptCancelPanel getJPanelOkCancel() {
        if (this.jPanelOkCancel == null) {
            this.jPanelOkCancel = new AcceptCancelPanel();
            this.jPanelOkCancel.setCancelButtonActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginServices.getMDIManager().closeWindow((IWindow)CreateNewAttributePanel.this);
                }
            });
            this.jPanelOkCancel.setPreferredSize(new Dimension(10, 50));
        }
        return this.jPanelOkCancel;
    }

    private JPanel getJPnlFields() {
        if (this.jPnlFields == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(8);
            gridLayout.setVgap(3);
            gridLayout.setHgap(5);
            gridLayout.setColumns(2);
            this.jPnlFields = new JPanel();
            this.jPnlFields.setLayout(gridLayout);
            this.jPnlFields.setBounds(new Rectangle(5, 12, 290, 200));
            this.jLblExpression = new JLabel();
            this.jLblExpression.setBounds(new Rectangle(14, 272, 125, 22));
            this.jLblExpression.setText(PluginServices.getText((Object)this, (String)"expression"));
            this.jLblDefaultValue = new JLabel();
            this.jLblDefaultValue.setBounds(new Rectangle(14, 200, 125, 22));
            this.jLblDefaultValue.setText(PluginServices.getText((Object)this, (String)"default_value"));
            this.jLblFieldPrecision = new JLabel();
            this.jLblFieldPrecision.setBounds(new Rectangle(14, 126, 112, 22));
            this.jLblFieldPrecision.setText(PluginServices.getText((Object)this, (String)"precision"));
            this.jLblFieldLength = new JLabel();
            this.jLblFieldLength.setBounds(new Rectangle(14, 89, 99, 22));
            this.jLblFieldLength.setText(PluginServices.getText((Object)this, (String)"field_length"));
            this.jLblFieldType = new JLabel();
            this.jLblFieldType.setBounds(new Rectangle(14, 52, 94, 22));
            this.jLblFieldType.setText(PluginServices.getText((Object)this, (String)"field_type"));
            this.jLblFieldName = new JLabel();
            this.jLblFieldName.setText(PluginServices.getText((Object)this, (String)"field_name"));
            this.jLblFieldName.setBounds(new Rectangle(14, 15, 99, 22));
            this.jPnlFields.add((Component)this.jLblFieldName, null);
            this.jPnlFields.add((Component)this.getJTxtFieldName(), null);
            this.jPnlFields.add((Component)this.jLblFieldType, null);
            this.jPnlFields.add((Component)this.getJCboFieldType(), null);
            this.jPnlFields.add((Component)this.jLblFieldLength, null);
            this.jPnlFields.add((Component)this.getJTxtFieldLength(), null);
            this.jPnlFields.add((Component)this.jLblFieldPrecision, null);
            this.jPnlFields.add((Component)this.getJTxtFieldPrecision(), null);
            this.jPnlFields.add((Component)this.getJRdbFieldReal(), null);
            this.jRdbFieldReal.addActionListener(this);
            this.jPnlFields.add((Component)new JLabel(), null);
            this.jPnlFields.add((Component)this.jLblDefaultValue, null);
            this.jPnlFields.add((Component)this.getJTxtDefaultValue(), null);
            this.jPnlFields.add((Component)this.getJRdbFieldVirtual(), null);
            this.jRdbFieldVirtual.addActionListener(this);
            this.jPnlFields.add((Component)new JLabel(), null);
            this.jPnlFields.add((Component)this.jLblExpression, null);
            JPanel panelVirtual = new JPanel();
            GridBagLayout grid = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 3;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            panelVirtual.setLayout(grid);
            panelVirtual.add((Component)this.getJTxtExpression(), gbc);
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            panelVirtual.add((Component)this.getJBtnExpression(), gbc);
            this.jPnlFields.add(panelVirtual);
            ButtonGroup defaultGroup = new ButtonGroup();
            defaultGroup.add(this.jRdbFieldReal);
            defaultGroup.add(this.jRdbFieldVirtual);
            this.jLblDefaultValue.setEnabled(true);
            this.jTxtDefaultValue.setEnabled(true);
            this.jLblExpression.setEnabled(false);
            this.jTxtExpression.setEnabled(false);
            this.jBtnExpression.setEnabled(false);
        }
        return this.jPnlFields;
    }

    public void setCurrentFieldNames(String[] fieldNames) {
        this.currentFieldNames = fieldNames;
        String newField = PluginServices.getText((Object)this, (String)"field").replaceAll(" +", "_");
        int index = 0;
        for (int i = 0; i < this.currentFieldNames.length; ++i) {
            if (!this.currentFieldNames[i].startsWith(newField)) continue;
            try {
                index = Integer.parseInt(this.currentFieldNames[i].replaceAll(newField, ""));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jTxtFieldName.setText(newField + ++index);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public void setMaxAttributeNameSize(int maxAttributeNameSize) {
        this.maxAttributeNameSize = maxAttributeNameSize;
    }

    private JTextField getJTxtExpression() {
        if (this.jTxtExpression == null) {
            this.jTxtExpression = new JTextField();
            this.jTxtExpression.setBounds(new Rectangle(147, 200, 125, 22));
            this.jTxtExpression.setColumns(4);
        }
        return this.jTxtExpression;
    }

    private JRadioButton getJRdbFieldReal() {
        if (this.jRdbFieldReal == null) {
            this.jRdbFieldReal = new JRadioButton(PluginServices.getText((Object)this, (String)"_Real_field"));
            this.jRdbFieldReal.setBounds(new Rectangle(14, 163, 125, 22));
            this.jRdbFieldReal.setSelected(true);
        }
        return this.jRdbFieldReal;
    }

    private JRadioButton getJRdbFieldVirtual() {
        if (this.jRdbFieldVirtual == null) {
            this.jRdbFieldVirtual = new JRadioButton(PluginServices.getText((Object)this, (String)"_Virtual_field"));
            this.jRdbFieldVirtual.setBounds(new Rectangle(14, 237, 125, 22));
        }
        return this.jRdbFieldVirtual;
    }

    private JButton getJBtnExpression() {
        if (this.jBtnExpression == null) {
            this.jBtnExpression = new JButton();
            this.jBtnExpression.setText("...");
        }
        return this.jBtnExpression;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jRdbFieldReal) {
            this.jLblDefaultValue.setEnabled(true);
            this.jTxtDefaultValue.setEnabled(true);
            this.jLblExpression.setEnabled(false);
            this.jTxtExpression.setEnabled(false);
            this.jBtnExpression.setEnabled(false);
        } else if (e.getSource() == this.jRdbFieldVirtual) {
            this.jLblDefaultValue.setEnabled(false);
            this.jTxtDefaultValue.setEnabled(false);
            this.jLblExpression.setEnabled(true);
            this.jTxtExpression.setEnabled(true);
            this.jBtnExpression.setEnabled(true);
        }
    }
}

