/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.QueryModel;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.runtime.AsnNull;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.z3950.QueryModel.InternalToType1ConversionRules;
import org.jzkit.z3950.QueryModel.Type1QueryModel;
import org.jzkit.z3950.QueryModel.Z3950AttrTriple;
import org.jzkit.z3950.QueryModel.Z3950QueryModel;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AttributeElement_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AttributesPlusTerm_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Operand_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Operator_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.RPNQuery_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.RPNStructure_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.StringOrNumeric_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Term_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.attributeValue_inline3_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.complex_inline4_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.rpnRpnOp_inline2_type;
import org.springframework.context.ApplicationContext;

public class Type1QueryModelBuilder {
    private static Logger log = Logger.getLogger((class$org$jzkit$z3950$QueryModel$Type1QueryModelBuilder == null ? (class$org$jzkit$z3950$QueryModel$Type1QueryModelBuilder = Type1QueryModelBuilder.class$("org.jzkit.z3950.QueryModel.Type1QueryModelBuilder")) : class$org$jzkit$z3950$QueryModel$Type1QueryModelBuilder).getName());
    static /* synthetic */ Class class$org$jzkit$z3950$QueryModel$Type1QueryModelBuilder;

    public static Z3950QueryModel buildFrom(ApplicationContext ctx, QueryModel qm, String encoding) throws InvalidQueryException {
        if (qm == null) {
            throw new InvalidQueryException("Null query model");
        }
        OIDRegister reg = (OIDRegister)ctx.getBean("OIDRegister");
        InternalToType1ConversionRules rules = (InternalToType1ConversionRules)ctx.getBean("InternalToType1ConversionRules");
        return new Type1QueryModel(Type1QueryModelBuilder.RootNodeToZRPNStructure(qm.toInternalQueryModel(ctx), encoding, rules, reg));
    }

    public static final RPNQuery_type RootNodeToZRPNStructure(InternalModelRootNode root, String encoding, InternalToType1ConversionRules rules, OIDRegister reg) throws InvalidQueryException {
        log.info("RootNodeToZRPNStructure");
        RPNQuery_type result = new RPNQuery_type();
        String qry_attrset = rules.getProperty("DefaultTargetAttrset");
        if (null != qry_attrset) {
            result.attributeSet = reg.oidByName(qry_attrset);
            if (result.attributeSet == null) {
                throw new InvalidQueryException("Unknown OID name : " + qry_attrset + ". Please add to OIDRegister");
            }
        } else {
            throw new InvalidQueryException("Query does not to have a valid default attrset");
        }
        result.rpn = Type1QueryModelBuilder.visitNode((QueryNode)root, reg, encoding, null, rules);
        return result;
    }

    public static final RPNStructure_type visitNode(QueryNode node, OIDRegister reg, String encoding, String default_namespace, InternalToType1ConversionRules rules) {
        log.info("Visit node type=" + node.getClass());
        RPNStructure_type retval = null;
        if (node instanceof InternalModelRootNode) {
            log.info("Processing root");
            retval = Type1QueryModelBuilder.visitNode(((InternalModelRootNode)node).getChild(), reg, encoding, default_namespace, rules);
        } else if (node instanceof InternalModelNamespaceNode) {
            log.info("Processing namespace");
            retval = Type1QueryModelBuilder.visitNode(((InternalModelNamespaceNode)node).getChild(), reg, encoding, ((InternalModelNamespaceNode)node).getAttrset(), rules);
        } else if (node instanceof ComplexNode) {
            log.info("Processing boolean");
            retval = new RPNStructure_type();
            retval.which = 1;
            rpnRpnOp_inline2_type t = new rpnRpnOp_inline2_type();
            retval.o = t;
            t.rpn1 = Type1QueryModelBuilder.visitNode(((ComplexNode)node).getLHS(), reg, encoding, default_namespace, rules);
            t.rpn2 = Type1QueryModelBuilder.visitNode(((ComplexNode)node).getRHS(), reg, encoding, default_namespace, rules);
            t.op = new Operator_type();
            switch (((ComplexNode)node).getOp()) {
                case 1: {
                    t.op.which = 0;
                    t.op.o = new AsnNull();
                    break;
                }
                case 2: {
                    t.op.which = 1;
                    t.op.o = new AsnNull();
                    break;
                }
                case 3: {
                    t.op.which = 2;
                    t.op.o = new AsnNull();
                    break;
                }
                default: {
                    System.err.println("Prox not yet handled");
                    break;
                }
            }
        } else if (node instanceof AttrPlusTermNode) {
            log.info("Processing attrplustermnode");
            retval = new RPNStructure_type();
            retval.which = 0;
            Operand_type t = new Operand_type();
            retval.o = t;
            t.which = 0;
            t.o = Type1QueryModelBuilder.AttrPlusTermNode2apt_type((AttrPlusTermNode)node, encoding, default_namespace, rules, reg);
        }
        log.info(" visitNode returning " + retval);
        return retval;
    }

    public static final AttributesPlusTerm_type AttrPlusTermNode2apt_type(AttrPlusTermNode node, String encoding, String default_source_tree_namespace, InternalToType1ConversionRules rules, OIDRegister reg) {
        log.info("Convert aptn");
        AttributesPlusTerm_type apt = new AttributesPlusTerm_type();
        apt.attributes = new ArrayList();
        Enumeration e = node.getAttrEnum();
        while (e.hasMoreElements()) {
            String attr_id = e.nextElement().toString();
            log.info("Lookup attribute " + attr_id);
            Object av = node.getAttr(attr_id);
            Z3950AttrTriple at = rules.convert(av, default_source_tree_namespace);
            AttributeElement_type ae = new AttributeElement_type();
            String element_attset = at.getAttrset();
            if (null != element_attset && !element_attset.equals(default_source_tree_namespace)) {
                ae.attributeSet = reg.oidByName(element_attset);
            }
            ae.attributeType = BigInteger.valueOf(at.getType());
            Object attrval = at.getValue();
            ae.attributeValue = new attributeValue_inline3_type();
            if (attrval instanceof BigInteger) {
                ae.attributeValue.which = 0;
                ae.attributeValue.o = BigInteger.valueOf(((BigInteger)attrval).intValue());
            } else if (attrval instanceof String) {
                String val = attrval.toString();
                ae.attributeValue.which = 1;
                complex_inline4_type cit = new complex_inline4_type();
                cit.list = new ArrayList();
                ae.attributeValue.o = cit;
                StringOrNumeric_type son = new StringOrNumeric_type();
                son.which = 0;
                son.o = val;
                cit.list.add(son);
            } else {
                log.warning("Unhandled type (" + attrval.getClass().getName() + ") for attribute value");
            }
            apt.attributes.add(ae);
        }
        apt.term = new Term_type();
        apt.term.which = 0;
        try {
            apt.term.o = node.getTerm().toString().getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            log.warning("Problem converting search string to requested encoding" + uee);
            apt.term.o = node.getTerm().toString().getBytes();
        }
        return apt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

