/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.z3950.util.FixedMarcField;
import org.jzkit.z3950.util.MarcRecord;
import org.jzkit.z3950.util.VariableMarcField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ISO2709Builder {
    protected static transient Logger log = Logger.getLogger((class$org$jzkit$z3950$util$ISO2709Builder == null ? (class$org$jzkit$z3950$util$ISO2709Builder = ISO2709Builder.class$("org.jzkit.z3950.util.ISO2709Builder")) : class$org$jzkit$z3950$util$ISO2709Builder).getName());
    static /* synthetic */ Class class$org$jzkit$z3950$util$ISO2709Builder;

    public static byte[] construct(Document source, String requestedSchema) {
        MarcRecord rec;
        log.fine("requestedSchema=" + requestedSchema);
        Object buffer = null;
        Element rootNode = source.getDocumentElement();
        if (rootNode == null) {
            log.log(Level.SEVERE, "Root Node is null");
            return null;
        }
        NodeList nodes = rootNode.getChildNodes();
        String elementName = rootNode.getNodeName();
        try {
            rec = new MarcRecord("usmarc");
        }
        catch (IllegalArgumentException e) {
            log.log(Level.SEVERE, "Problem", e);
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node field = nodes.item(i);
            if (field.getNodeType() == 1) {
                Node tag_node = field.getAttributes().getNamedItem("tag");
                if (tag_node == null) continue;
                int tag = Integer.parseInt(tag_node.getNodeValue());
                NodeList contents = field.getChildNodes();
                if (contents.getLength() == 1 && contents.item(0).getNodeType() != 1) {
                    rec.add(new FixedMarcField(rec, tag, contents.item(0).getNodeValue()));
                    continue;
                }
                ISO2709Builder.addField(rec, tag, contents);
                continue;
            }
            log.log(Level.SEVERE, "Unhandled node");
        }
        return rec.getBytes();
    }

    static void addField(MarcRecord rec, int tag, NodeList field) {
        VariableMarcField vmf = new VariableMarcField(rec, tag);
        for (int i = 0; i < field.getLength(); ++i) {
            Node subfield = field.item(i);
            if (subfield.getNodeName().equals("subfield")) {
                int j;
                NamedNodeMap attrs = subfield.getAttributes();
                char subtag = '!';
                for (j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (!attr.getNodeName().equals("code")) continue;
                    subtag = attr.getNodeValue().charAt(0);
                }
                NodeList contents = subfield.getChildNodes();
                for (j = 0; j < contents.getLength(); ++j) {
                    Node content = contents.item(j);
                    if (content.getNodeType() == 3) {
                        vmf.add(subtag, content.getNodeValue());
                        continue;
                    }
                    log.log(Level.SEVERE, "Unhandled node type:" + content.getNodeType());
                }
                continue;
            }
            log.log(Level.SEVERE, "Unhandled field node");
        }
        rec.add(vmf);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

