/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import org.jzkit.z3950.util.MalformedRecordException;
import org.jzkit.z3950.util.MarcDirectoryEntry;
import org.jzkit.z3950.util.MarcRecord;

class MarcLeader {
    byte[] leader;
    char recordStatus;
    char typeOfRecord;
    int headerlen;
    int lengthlen = 0;
    int localdatalen = 0;
    int offsetlen = 0;
    int reclen;

    MarcLeader() {
    }

    MarcLeader(int numFields, int datalen, String leaderData, int directoryEntryLen) throws MalformedRecordException {
        StringBuffer sb = new StringBuffer();
        this.headerlen = MarcLeader.SizeOf() + numFields * MarcDirectoryEntry.SizeOf(this.localdatalen) + 1;
        this.reclen = this.headerlen + datalen;
        if (leaderData == null) {
            sb.append(MarcRecord.intToString(this.reclen, 5)).append("     22").append(MarcRecord.intToString(this.headerlen, 5)).append("   45 0");
        } else {
            if (leaderData.length() != 8) {
                throw new MalformedRecordException("Illegal leader field in record: leader='" + leaderData + "'");
            }
            sb.append(MarcRecord.intToString(this.reclen, 5)).append(leaderData.substring(0, 5)).append("22").append(MarcRecord.intToString(this.headerlen, 5)).append(leaderData.substring(5, 8)).append("45 0");
        }
        this.leader = sb.toString().getBytes();
    }

    void reset(byte[] buffer, int offset) throws MalformedRecordException {
        this.reclen = MarcRecord.bytesToInt(buffer, offset, 5);
        if (this.reclen < 0) {
            throw new MalformedRecordException("Bad character detected in the RecordLength (bytes 0-5) field of the MARC leader");
        }
        this.recordStatus = (char)buffer[offset + 5];
        this.typeOfRecord = (char)buffer[offset + 6];
        this.headerlen = MarcRecord.bytesToInt(buffer, offset + 12, 5);
        if (this.headerlen < 0) {
            throw new MalformedRecordException("Bad character detected in the BaseAddress (bytes 12-16) field of the MARC leader");
        }
        this.lengthlen = MarcRecord.bytesToInt(buffer, offset + 20, 1);
        if (this.lengthlen < 0) {
            throw new MalformedRecordException("Bad character detected in the \"length of length-of-field\" (byte 20) field of the MARC leader");
        }
        this.offsetlen = MarcRecord.bytesToInt(buffer, offset + 21, 1);
        if (this.offsetlen < 0) {
            throw new MalformedRecordException("Bad character detected in the \"length of starting-character-position\" (byte 21) field of the MARC leader");
        }
        byte b = buffer[offset + 22];
        if (b == 32 || b == 0) {
            this.localdatalen = 0;
        } else {
            this.localdatalen = MarcRecord.bytesToInt(buffer, offset + 22, 1);
            if (this.localdatalen < 0) {
                throw new MalformedRecordException("Bad character detected in the \"length of implementation-defined\" (byte 22) field of the MARC leader");
            }
        }
    }

    static int SizeOf() {
        return 24;
    }
}

