/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.DefaultValidationStatus;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.formats.geojson.GeoJsonWriter;
import org.gvsig.fmap.geom.jts.formats.geojson.GeoJsonWriterEx;
import org.gvsig.fmap.geom.jts.operation.towkb.OGCWKBEncoder;
import org.gvsig.fmap.geom.jts.operation.towkb.PostGISEWKBEncoder;
import org.gvsig.fmap.geom.jts.operation.towkt.EWKTWriter;
import org.gvsig.fmap.geom.jts.primitive.Envelope2D;
import org.gvsig.fmap.geom.jts.primitive.Envelope3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.util.GMLUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.OrientableCurve;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.OrientableSurface;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeometry
implements GeometryJTS {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeometry.class);
    private static final long serialVersionUID = 4999326772576222293L;
    private GeometryType geometryType;
    private IProjection projection;

    public AbstractGeometry(int type, int subtype) {
        try {
            this.geometryType = GeometryLocator.getGeometryManager().getGeometryType(type, subtype);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryType = geometryType;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    protected GeometryManager getManager() {
        return GeometryLocator.getGeometryManager();
    }

    public boolean contains(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (!(geometry instanceof GeometryJTS)) {
            return false;
        }
        com.vividsolutions.jts.geom.Geometry theJTS = this.getJTS();
        if (this instanceof Aggregate) {
            theJTS = theJTS.union();
        }
        com.vividsolutions.jts.geom.Geometry otherJTS = ((GeometryJTS)geometry).getJTS();
        if (geometry instanceof Aggregate) {
            otherJTS = otherJTS.union();
        }
        return theJTS.contains(otherJTS);
    }

    public int compareTo(Object o) {
        return this.getJTS().compareTo((Object)((GeometryJTS)o).getJTS());
    }

    public boolean contains(double x, double y) {
        this.notifyDeprecated("Calling deprecated method of geometry contains from shape interface");
        Shape shp = this.getShape();
        return shp.contains(x, y);
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.notifyDeprecated("Calling deprecated method of geometry intersects from shape interface");
        Shape shp = this.getShape();
        return shp.intersects(x, y, w, h);
    }

    public boolean contains(double x, double y, double w, double h) {
        this.notifyDeprecated("Calling deprecated method of geometry contains from shape interface");
        Shape shp = this.getShape();
        return shp.contains(x, y, w, h);
    }

    public boolean contains(Point2D p) {
        this.notifyDeprecated("Calling deprecated method of geometry contains from shape interface");
        Shape shp = this.getShape();
        return shp.contains(p);
    }

    public boolean contains(Rectangle2D r) {
        this.notifyDeprecated("Calling deprecated method of geometry contains from shape interface");
        Shape shp = this.getShape();
        return shp.contains(r);
    }

    public double distance(Geometry other) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().distance(((GeometryJTS)other).getJTS());
    }

    public boolean isWithinDistance(Geometry other, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return DistanceOp.isWithinDistance((com.vividsolutions.jts.geom.Geometry)this.getJTS(), (com.vividsolutions.jts.geom.Geometry)((GeometryJTS)other).getJTS(), (double)distance);
    }

    public boolean overlaps(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().overlaps(((GeometryJTS)geometry).getJTS());
    }

    public boolean coveredBy(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().coveredBy(((GeometryJTS)geometry).getJTS());
    }

    public boolean covers(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().covers(((GeometryJTS)geometry).getJTS());
    }

    public boolean crosses(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().crosses(((GeometryJTS)geometry).getJTS());
    }

    public boolean intersects(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().intersects(((GeometryJTS)geometry).getJTS());
    }

    public boolean touches(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().touches(((GeometryJTS)geometry).getJTS());
    }

    public boolean disjoint(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().disjoint(((GeometryJTS)geometry).getJTS());
    }

    public boolean within(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().within(((GeometryJTS)geometry).getJTS());
    }

    public double area() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().getArea();
    }

    public double perimeter() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getJTS().getLength();
    }

    public boolean intersects(Rectangle2D r) {
        double x = r.getMinX();
        double y = r.getMinY();
        double w = r.getWidth();
        double h = r.getHeight();
        return this.fastIntersects(x, y, w, h);
    }

    public boolean fastIntersects(double x, double y, double w, double h) {
        Coordinate[] coord = new Coordinate[]{new Coordinate(x, y), new Coordinate(x + w, y), new Coordinate(x + w, y + w), new Coordinate(x, y + w), new Coordinate(x, y)};
        com.vividsolutions.jts.geom.Geometry rect = JTSUtils.createJTSPolygon(this.getProjection(), coord);
        return this.getJTS().intersects(rect);
    }

    public Envelope getEnvelope() {
        if (this.is3D()) {
            if (this.isEmpty()) {
                return new Envelope3D(this.getProjection());
            }
            Coordinate[] coordinates = this.getJTS().getCoordinates();
            double minx = Double.POSITIVE_INFINITY;
            double miny = Double.POSITIVE_INFINITY;
            double minz = Double.POSITIVE_INFINITY;
            double maxx = Double.NEGATIVE_INFINITY;
            double maxy = Double.NEGATIVE_INFINITY;
            double maxz = Double.NEGATIVE_INFINITY;
            for (Coordinate coordinate : coordinates) {
                double x = coordinate.x;
                double y = coordinate.y;
                double z = coordinate.z;
                minx = Math.min(x, minx);
                miny = Math.min(y, miny);
                minz = Math.min(z, minz);
                maxx = Math.max(x, maxx);
                maxy = Math.max(y, maxy);
                maxz = Math.max(z, maxz);
            }
            if (minx <= maxx && miny <= maxy && (minz <= maxz || Double.isNaN(minz) && Double.isNaN(maxz))) {
                Point3D min = new Point3D(minx, miny, minz);
                Point3D max = new Point3D(maxx, maxy, maxz);
                return new Envelope3D(min, max, this.getProjection());
            }
            return new Envelope3D(this.getProjection());
        }
        if (this.isEmpty()) {
            return new Envelope2D(this.getProjection());
        }
        try {
            com.vividsolutions.jts.geom.Envelope envelope = this.getJTS().getEnvelopeInternal();
            return new Envelope2D(envelope, this.getProjection());
        }
        catch (Exception ex) {
            try {
                MultiLine lines = this.toLines();
                return lines.getEnvelope();
            }
            catch (Exception ex2) {
                throw ex;
            }
        }
    }

    public boolean isSimple() {
        return this.getJTS().isSimple();
    }

    public boolean isCCW() throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isEmpty()) {
            return true;
        }
        try {
            return CGAlgorithms.isCCW((Coordinate[])this.getJTS().getCoordinates());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve geometry orientation", (Throwable)ex);
            throw ex;
        }
    }

    public Object invokeOperation(int index, GeometryOperationContext ctx) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getManager().invokeOperation(index, (Geometry)this, ctx);
    }

    public Object invokeOperation(String opName, GeometryOperationContext ctx) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getManager().invokeOperation(opName, (Geometry)this, ctx);
    }

    public int getType() {
        return this.getGeometryType().getType();
    }

    public Object convertTo(String format, Object ... args) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (StringUtils.isEmpty((CharSequence)format)) {
            throw new IllegalArgumentException("Can't accept null as format name.");
        }
        switch (format = format.trim().toLowerCase()) {
            case "jts": {
                return this.getJTS();
            }
            case "wkb": {
                return this.convertToWKB();
            }
            case "hexwkb": {
                return this.convertToHexWKB();
            }
            case "ewkb": {
                return this.convertToEWKB();
            }
            case "wkt": {
                return this.convertToWKT();
            }
            case "gml": {
                return GMLUtils.geometry2GML(this);
            }
            case "json": 
            case "geojson": {
                if (args != null && args.length >= 1 && args[0] instanceof Map) {
                    if (args.length >= 2 && args[1] instanceof Boolean) {
                        return this.convertToGeoJson((Map)args[0], (Boolean)args[1]);
                    }
                    return this.convertToGeoJson((Map)args[0], true);
                }
                return this.convertToGeoJson();
            }
        }
        throw new IllegalArgumentException("Format '" + format + "' not supported");
    }

    public byte[] convertToWKB() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            return new OGCWKBEncoder().encode(this);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public String convertToHexWKB() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            byte[] bytes = new OGCWKBEncoder().encode(this);
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public String convertToGeoJson() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            GeoJsonWriter writer = new GeoJsonWriter();
            writer.setEncodeCRS(true);
            return writer.write(this.getJTS());
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public String convertToGeoJson(Map<String, Object> properties, boolean encodecrs) throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            GeoJsonWriterEx writer = new GeoJsonWriterEx();
            writer.setEncodeCRS(true);
            return writer.write(this.getJTS(), properties);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public String convertToHexEWKB() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            byte[] bytes = new PostGISEWKBEncoder().encode(this);
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public byte[] convertToWKBQuietly() {
        try {
            return new OGCWKBEncoder().encode(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String convertToHexWKBQuietly() {
        try {
            byte[] bytes = new OGCWKBEncoder().encode(this);
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String convertToHexEWKBQuietly() {
        try {
            byte[] bytes = new PostGISEWKBEncoder().encode(this);
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] convertToWKB(int srs) throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            return new OGCWKBEncoder().encode(this);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public byte[] convertToWKBForcingType(int srs, int type) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AbstractGeometry geom = this;
        if (this.getType() != type) {
            com.vividsolutions.jts.geom.Geometry jts = this.getJTS();
            jts = JTSUtils.convertTypes(jts, this.getType(), type);
            geom = JTSUtils.createGeometry(this.getProjection(), jts);
        }
        try {
            return new OGCWKBEncoder().encode(geom);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public byte[] convertToEWKB() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            return new PostGISEWKBEncoder().encode(this);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public byte[] convertToEWKB(int srs) throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            return new PostGISEWKBEncoder().encode(this);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public byte[] convertToEWKBForcingType(int srs, int type) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AbstractGeometry geom = this;
        if (this.getType() != type) {
            com.vividsolutions.jts.geom.Geometry jts = this.getJTS();
            jts = JTSUtils.convertTypes(jts, this.getType(), type);
            geom = JTSUtils.createGeometry(this.getProjection(), jts);
        }
        try {
            return new PostGISEWKBEncoder().encode(geom);
        }
        catch (Exception e) {
            throw new GeometryOperationException(e);
        }
    }

    public String convertToWKT() throws GeometryOperationNotSupportedException, GeometryOperationException {
        EWKTWriter writer;
        int subType = this.getGeometryType().getSubType();
        switch (subType) {
            case 1: {
                writer = new EWKTWriter(3, false);
                break;
            }
            case 2: {
                writer = new EWKTWriter(3, true);
                break;
            }
            case 3: {
                writer = new EWKTWriter(4, true);
                break;
            }
            default: {
                writer = new EWKTWriter(2, false);
            }
        }
        com.vividsolutions.jts.geom.Geometry jts = this.getJTS();
        return writer.write(jts);
    }

    public String convertToWKTQuietly() {
        try {
            return this.convertToWKT();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Geometry buffer(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (distance == 0.0) {
            return this;
        }
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry buffer(double distance, int joinStyle, boolean capButt) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (distance == 0.0) {
            return this;
        }
        int quadrantSegments = JTSUtils.calculateQuadrantSegments(joinStyle);
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, quadrantSegments, capButt ? 2 : 1));
    }

    public Geometry snapTo(Geometry other, double snapTolerance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        GeometrySnapper snapper = new GeometrySnapper(this.getJTS());
        com.vividsolutions.jts.geom.Geometry jts_result = snapper.snapTo(((GeometryJTS)other).getJTS(), snapTolerance);
        Geometry result = JTSUtils.createGeometry(this.getProjection(), jts_result);
        return result;
    }

    public Point getInteriorPoint() throws GeometryOperationNotSupportedException, GeometryOperationException {
        com.vividsolutions.jts.geom.Geometry geometry = this.getJTS();
        com.vividsolutions.jts.geom.Point point = geometry.getInteriorPoint();
        Geometry result = JTSUtils.createGeometry(this.getProjection(), (com.vividsolutions.jts.geom.Geometry)point);
        return (Point)result;
    }

    public boolean isValid() {
        return this.getJTS().isValid();
    }

    public Geometry.ValidationStatus getValidationStatus() {
        DefaultValidationStatus status;
        block5: {
            status = new DefaultValidationStatus(0, null);
            try {
                com.vividsolutions.jts.geom.Geometry jtsgeom = this.getJTS();
                IsValidOp validOp = new IsValidOp(jtsgeom);
                if (!validOp.isValid()) {
                    status.setValidationError(validOp.getValidationError());
                }
            }
            catch (Throwable ex) {
                int vertices;
                status.setStatusCode(1);
                status.setMesage("The geometry is corrupted.");
                if (this instanceof OrientableSurface) {
                    int vertices2 = ((OrientableSurface)this).getNumVertices();
                    if (vertices2 < 3) {
                        status.setStatusCode(20);
                        status.setMesage(TopologyValidationError.errMsg[9]);
                    }
                }
                if (!(this instanceof OrientableCurve) || (vertices = ((OrientableCurve)this).getNumVertices()) >= 2) break block5;
                status.setStatusCode(20);
                status.setMesage(TopologyValidationError.errMsg[9]);
            }
        }
        return status;
    }

    public Geometry makeValid() {
        try {
            Geometry.ValidationStatus vs = this.getValidationStatus();
            if (vs.isValid()) {
                return this;
            }
            switch (vs.getStatusCode()) {
                case 18: 
                case 19: {
                    Geometry g = this.buffer(0.0);
                    if (!g.isValid()) break;
                    return g;
                }
                case 20: {
                    int vertices;
                    if (this instanceof OrientableCurve && (vertices = ((OrientableCurve)this).getNumVertices()) < 2) {
                        return null;
                    }
                    if (!(this instanceof OrientableSurface) || (vertices = ((OrientableSurface)this).getNumVertices()) >= 3) break;
                    return null;
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public Rectangle2D getBounds2D() {
        com.vividsolutions.jts.geom.Envelope envInternal = this.getJTS().getEnvelopeInternal();
        return new Rectangle2D.Double(envInternal.getMinX(), envInternal.getMinY(), envInternal.getWidth(), envInternal.getHeight());
    }

    public Rectangle getBounds() {
        return this.getShape().getBounds();
    }

    public Shape getInternalShape() {
        return this.getShape();
    }

    public void rotate(double radAngle, double basex, double basey) {
        AffineTransform at = new AffineTransform();
        at.rotate(radAngle, basex, basey);
        this.transform(at);
    }

    public void move(double dx, double dy) {
        AffineTransform at = new AffineTransform();
        at.translate(dx, dy);
        this.transform(at);
    }

    public void scale(Point basePoint, double sx, double sy) {
        AffineTransform at = new AffineTransform();
        at.setToTranslation(basePoint.getX(), basePoint.getY());
        at.scale(sx, sy);
        at.translate(-basePoint.getX(), -basePoint.getY());
        this.transform(at);
    }

    public Geometry[] closestPoints(Geometry other) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] jts_points = DistanceOp.nearestPoints((com.vividsolutions.jts.geom.Geometry)this.getJTS(), (com.vividsolutions.jts.geom.Geometry)((GeometryJTS)other).getJTS());
        Point[] points = new Point[jts_points.length];
        for (int i = 0; i < jts_points.length; ++i) {
            try {
                points[i] = JTSUtils.createPoint(this.getGeometryType(), this.getProjection(), jts_points[i]);
                continue;
            }
            catch (CreateGeometryException e) {
                throw new GeometryOperationException((Exception)((Object)e));
            }
        }
        return (Geometry[])points;
    }

    public Geometry convexHull() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().convexHull(), null);
    }

    public Geometry difference(Geometry other) throws GeometryOperationNotSupportedException, GeometryOperationException {
        com.vividsolutions.jts.geom.Geometry otherJTS = ((GeometryJTS)other).getJTS();
        if (other instanceof Aggregate) {
            otherJTS = otherJTS.union();
        }
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().difference(otherJTS), null);
    }

    public Geometry intersection(Geometry other) throws GeometryOperationNotSupportedException, GeometryOperationException {
        com.vividsolutions.jts.geom.Geometry otherJTS = ((GeometryJTS)other).getJTS();
        if (other instanceof Aggregate) {
            otherJTS = otherJTS.union();
        }
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().intersection(otherJTS), null);
    }

    public Geometry union(Geometry other) throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            com.vividsolutions.jts.geom.Geometry jts = this.getJTS();
            com.vividsolutions.jts.geom.Geometry otherJts = ((GeometryJTS)other).getJTS();
            if (jts.isValid() && otherJts.isValid()) {
                return JTSUtils.createGeometry(this.getProjection(), jts.union(otherJts), this.getGeometryType());
            }
            MultiPrimitive geom = this.getManager().createMultiPrimitive(this.geometryType);
            geom.addPrimitives((Geometry)this);
            geom.addPrimitives(other);
            return geom;
        }
        catch (CreateGeometryException ex) {
            throw new GeometryOperationException(this.getGeometryType().getType(), this.getManager().getGeometryOperationCode("Union"), (Exception)((Object)ex));
        }
    }

    public Point centroid() throws GeometryOperationNotSupportedException, GeometryOperationException {
        try {
            return JTSUtils.createPoint(this.getGeometryType(), this.getProjection(), this.getJTS().getCentroid().getCoordinate());
        }
        catch (CreateGeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    protected void notifyDeprecated(String message) {
        LOGGER.info(message);
    }

    public boolean ensureOrientation(boolean ccw) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (ccw != this.isCCW()) {
            this.flip();
            return true;
        }
        return false;
    }

    public boolean out(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryJTS otherJtsGeom = (GeometryJTS)geometry;
        return !this.contains(otherJtsGeom) && !this.intersects(otherJtsGeom);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryJTS) {
            return this.getJTS().equals(((GeometryJTS)obj).getJTS());
        }
        return false;
    }

    public String toString() {
        return this.getGeometryType().getFullName();
    }

    public IProjection getProjection() {
        return this.projection;
    }

    public void setProjectionIffNull(IProjection projection) {
        if (this.projection == null) {
            this.projection = projection;
        }
    }

    public void setProjection(IProjection projection) {
        this.projection = projection;
    }

    public void setProjection(String projection) {
        IProjection proj = CRSFactory.getCRS((String)"EPSG:4326");
        this.setProjection(proj);
    }

    public Geometry clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public Geometry boundary() {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().getBoundary(), null);
    }

    public Geometry fix() {
        try {
            Geometry fixed;
            Geometry.ValidationStatus status = this.getValidationStatus();
            if (status.isValid()) {
                return this.cloneGeometry();
            }
            int statusCode = status.getStatusCode();
            switch (statusCode) {
                case 0: {
                    return this.cloneGeometry();
                }
                case 18: 
                case 19: {
                    fixed = this.buffer(Double.MIN_VALUE);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (!fixed.isValid()) {
                return null;
            }
            if (this.getGeometryType().getType() != fixed.getGeometryType().getType()) {
                return null;
            }
            return fixed;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Geometry forceSubtype(int subtype) throws GeometryOperationNotSupportedException, GeometryOperationException {
        switch (subtype) {
            case 0: {
                return this.force2D();
            }
            case 2: {
                return this.force2DM();
            }
            case 1: {
                return this.force3D();
            }
            case 3: {
                return this.force3DM();
            }
        }
        return this;
    }

    protected abstract Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException;

    protected abstract Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException;

    protected abstract Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean isEmpty() {
        if (this instanceof Aggregate) {
            if (((Aggregate)this).getPrimitivesNumber() < 1) {
                return true;
            }
        } else if (this instanceof Complex) {
            if (((Complex)this).getPrimitivesNumber() < 1) {
                return true;
            }
        } else if (this instanceof OrientablePrimitive) {
            return ((OrientablePrimitive)this).isEmpty();
        }
        return false;
    }
}

