/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts;

import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmovableHandler
extends AbstractHandler {
    protected static final Logger logger = LoggerFactory.getLogger(UnmovableHandler.class);

    public UnmovableHandler(Point2D p) {
        this.point = p;
    }

    public UnmovableHandler(Point p) {
        this.point = new Point2D.Double(p.getX(), p.getY());
    }

    public UnmovableHandler(double x, double y) {
        this.point = new Point2D.Double(x, y);
    }

    public void move(double x, double y) {
        String message = "Can't move the coordinates of a UnmovableHandler.";
        logger.info(message);
        throw new UnsupportedOperationException(message);
    }

    public void set(double x, double y) {
        String message = "Can't change the coordinates of a UnmovableHandler.";
        logger.info(message);
        throw new UnsupportedOperationException(message);
    }
}

