/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Collections;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPrimitive;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public abstract class AbstractMultiPoint
extends AbstractMultiPrimitive
implements MultiPoint {
    private static final long serialVersionUID = 7056816718895043774L;

    public AbstractMultiPoint(int subtype) {
        super(7, subtype);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayListCoordinateSequence coordinateSequence = new ArrayListCoordinateSequence();
        for (PointJTS point : this.primitives) {
            coordinateSequence.add(point.getJTSCoordinate());
        }
        return JTSUtils.createJTSMultiPoint(this.getProjection(), coordinateSequence);
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPoint2D other = new MultiPoint2D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.force2D());
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPoint2DM other = new MultiPoint2DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)((Point)primitive).force2DM());
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPoint3D other = new MultiPoint3D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)((Point)primitive).force3D());
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPoint3DM other = new MultiPoint3DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)((Point)primitive).force3DM());
        }
        return other;
    }

    @Override
    public Geometry forceSubtype(int subtype) throws GeometryOperationNotSupportedException, GeometryOperationException {
        switch (subtype) {
            case 0: {
                return this.force2D();
            }
            case 2: {
                return this.force2DM();
            }
            case 1: {
                return this.force3D();
            }
            case 3: {
                return this.force3DM();
            }
        }
        return this;
    }

    public void addPoint(Point point) {
        point = this.fixPoint(point);
        this.primitives.add(point);
    }

    public Point getPointAt(int index) {
        return (Point)this.primitives.get(index);
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    @Override
    public Shape getShape() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        PointIterator pi = new PointIterator(at);
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Collections.reverse(this.primitives);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(joinStyle)));
    }

    protected abstract Point fixPoint(Point var1);

    protected class PointIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;
        private int index;

        public PointIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            this.done = AbstractMultiPoint.this.primitives.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            this.done = AbstractMultiPoint.this.primitives.size() == ++this.index;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            Point point = (Point)AbstractMultiPoint.this.primitives.get(this.index);
            coords[0] = point.getX();
            coords[1] = point.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }

        @Override
        public int currentSegment(float[] coords) {
            Point point = (Point)AbstractMultiPoint.this.primitives.get(this.index);
            coords[0] = (float)point.getX();
            coords[1] = (float)point.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
    }
}

