/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiSurface;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.PolygonHelper;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;

public abstract class AbstractMultiPolygon
extends AbstractMultiSurface
implements MultiPolygon {
    private static final long serialVersionUID = 6663703214829442424L;

    public AbstractMultiPolygon(int subtype) {
        super(22, subtype);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        Polygon[] polygons = new Polygon[this.primitives.size()];
        for (int i = 0; i < this.primitives.size(); ++i) {
            polygons[i] = (Polygon)((GeometryJTS)this.primitives.get(i)).getJTS();
        }
        return JTSUtils.createJTSMultiPolygon(this.getProjection(), polygons);
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPolygon2D other = new MultiPolygon2D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(0));
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPolygon2DM other = new MultiPolygon2DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(2));
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPolygon3D other = new MultiPolygon3D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(1));
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiPolygon3DM other = new MultiPolygon3DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(3));
        }
        return other;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        MultiPolygonIterator pi = new MultiPolygonIterator(at);
        return pi;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Iterator iterator = this.primitives.iterator();
        while (iterator.hasNext()) {
            ((GeometryJTS)iterator.next()).flip();
        }
        Collections.reverse(this.primitives);
    }

    public void addSurface(Surface surface) {
        GeometryType geometryType = surface.getGeometryType();
        if (geometryType.getType() == 19 && geometryType.getSubType() == this.getGeometryType().getSubType()) {
            this.primitives.add(surface);
            return;
        }
        String msg = StringUtils.replaceEach((String)"Only a polygon subtype  %(subtypeSurface)s can be added to a MultiPolygon subtype %(subtype)s", (String[])new String[]{"%(subtypeSurface)s", "%(subtype)s"}, (String[])new String[]{String.valueOf(geometryType.getSubType()), String.valueOf(this.getGeometryType().getSubType())});
        LOGGER.warn(msg);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        int capacity = 0;
        for (int i = 0; i < this.getPrimitivesNumber(); ++i) {
            org.gvsig.fmap.geom.primitive.Polygon polygon = (org.gvsig.fmap.geom.primitive.Polygon)this.getPrimitiveAt(i);
            capacity += polygon.getNumVertices();
            for (int r = 0; r < polygon.getNumInteriorRings(); ++r) {
                capacity += polygon.getInteriorRing(r).getNumVertices();
            }
        }
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0, capacity);
    }

    @Override
    public Shape getShape() {
        return this.getShape(null);
    }

    public Geometry validateCoverage(Geometry[] geoms, double gapWidth) {
        return PolygonHelper.validateCoverage(this, geoms, gapWidth);
    }

    public Geometry findGaps(double gapWidth) {
        return PolygonHelper.findGaps(this, gapWidth);
    }

    protected class MultiPolygonIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;
        private int index;
        private final List<PathIterator> iterators;

        public MultiPolygonIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            this.iterators = new ArrayList<PathIterator>(AbstractMultiPolygon.this.primitives.size());
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            for (Primitive primitive : AbstractMultiPolygon.this.primitives) {
                if (primitive.isEmpty()) continue;
                this.iterators.add(primitive.getPathIterator(at));
            }
            this.done = this.iterators.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            PathIterator pathIteratorPrimitive = this.iterators.get(this.index);
            pathIteratorPrimitive.next();
            if (pathIteratorPrimitive.isDone()) {
                ++this.index;
                this.done = this.index == AbstractMultiPolygon.this.primitives.size();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }
    }
}

