/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiCurve;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;

public class DefaultMultiCurve
extends AbstractMultiCurve {
    public DefaultMultiCurve(GeometryType geometryType) {
        super(geometryType.getSubType());
    }

    public DefaultMultiCurve(int subtype) {
        super(subtype);
    }

    public Geometry cloneGeometry() {
        DefaultMultiCurve clone = new DefaultMultiCurve(this.getGeometryType());
        for (int i = 0; i < this.primitives.size(); ++i) {
            clone.addPrimitive((Primitive)((Primitive)this.primitives.get(i)).cloneGeometry());
        }
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve other = new DefaultMultiCurve(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(0));
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve other = new DefaultMultiCurve(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(2));
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve other = new DefaultMultiCurve(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(1));
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve other = new DefaultMultiCurve(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(3));
        }
        return other;
    }

    public int getDimension() {
        switch (this.getGeometryType().getSubType()) {
            case 0: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint multipoint = null;
        for (int i = 0; i < this.getPrimitivesNumber(); ++i) {
            if (multipoint == null) {
                multipoint = this.getPrimitiveAt(i).toPoints();
                continue;
            }
            MultiPoint points = this.getPrimitiveAt(i).toPoints();
            for (int j = 0; j < points.getPrimitivesNumber(); ++j) {
                multipoint.addPrimitive(points.getPrimitiveAt(j));
            }
        }
        return multipoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine multiline = null;
        for (int i = 0; i < this.getPrimitivesNumber(); ++i) {
            if (multiline == null) {
                multiline = this.getPrimitiveAt(i).toLines();
                continue;
            }
            MultiLine lines = this.getPrimitiveAt(i).toLines();
            for (int j = 0; j < lines.getPrimitivesNumber(); ++j) {
                multiline.addPrimitive(lines.getPrimitiveAt(j));
            }
        }
        return multiline;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon multipolygon = null;
        for (int i = 0; i < this.getPrimitivesNumber(); ++i) {
            if (multipolygon == null) {
                multipolygon = this.getPrimitiveAt(i).toPolygons();
                continue;
            }
            MultiPolygon polygons = this.getPrimitiveAt(i).toPolygons();
            for (int j = 0; j < polygons.getPrimitivesNumber(); ++j) {
                multipolygon.addPrimitive(polygons.getPrimitiveAt(j));
            }
        }
        return multipolygon;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        for (int i = 0; i < this.getPrimitivesNumber(); ++i) {
            this.getPrimitiveAt(i).flip();
        }
        Collections.reverse(this.primitives);
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        int subType;
        int primitiveSubType = primitive.getGeometryType().getSubType();
        if (primitiveSubType == (subType = this.getGeometryType().getSubType())) {
            return primitive;
        }
        String message = StringUtils.replace((String)"This MultiCurve only accept subtype %(subtype)s primitives", (String)"%(subtype)s", (String)String.valueOf(subType));
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            LineString line;
            if (primitive instanceof Line) {
                line = (LineString)((GeometryJTS)primitive).getJTS();
                lineStrings.add(line);
                continue;
            }
            try {
                MultiLine multiline = primitive.toLines();
                for (int j = 0; j < multiline.getPrimitivesNumber(); ++j) {
                    line = (LineString)((GeometryJTS)multiline.getPrimitiveAt(j)).getJTS();
                    lineStrings.add(line);
                }
            }
            catch (GeometryException e) {
                GeometryType geomType = primitive.getGeometryType();
                LOGGER.warn(StringUtils.replaceEach((String)"Can't convert primitive type=%(type)s, %(subtype)s to MultiLine", (String[])new String[]{"%(type)s", "%(subtype)s"}, (String[])new String[]{String.valueOf(geomType.getType()), String.valueOf(geomType.getSubType())}));
            }
        }
        return JTSUtils.createJTSMultiLineString(this.getProjection(), lineStrings.toArray(new LineString[lineStrings.size()]));
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve result = new DefaultMultiCurve(this.getGeometryType());
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(distance);
            if (offset instanceof MultiPrimitive) {
                MultiPrimitive multiOffset = (MultiPrimitive)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            result.addPrimitive((Primitive)primitive.offset(distance));
        }
        return result;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiCurve result = new DefaultMultiCurve(this.getGeometryType());
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(joinStyle, distance);
            if (offset instanceof MultiPrimitive) {
                MultiPrimitive multiOffset = (MultiPrimitive)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            result.addPrimitive((Primitive)primitive.offset(joinStyle, distance));
        }
        return result;
    }
}

