/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiLine;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;

public class MultiLine2DM
extends AbstractMultiLine {
    private static final long serialVersionUID = 7970383739561430594L;

    public MultiLine2DM() {
        super(2);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        for (Line2DM line : this.primitives) {
            MultiPoint points = line.toPoints();
            multiPoint.ensureCapacity(multiPoint.getPrimitivesNumber() + points.getPrimitivesNumber());
            for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(points.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        return this;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        for (Line2DM line : this.primitives) {
            MultiPolygon polygons = line.toPolygons();
            multiPolygon.ensureCapacity(multiPolygon.getPrimitivesNumber() + polygons.getPrimitivesNumber());
            for (int i = 0; i < polygons.getPrimitivesNumber(); ++i) {
                multiPolygon.addSurface((Surface)((Polygon)polygons.getPrimitiveAt(i)));
            }
        }
        return multiPolygon;
    }

    public Geometry cloneGeometry() {
        MultiLine2DM clone = new MultiLine2DM();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 3;
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return null;
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Line2DM) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 2) {
            try {
                return primitive.toLines();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to lines";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 2DM primitives can be fixed to MultiLine2DM";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2DM result = new MultiLine2DM();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2DM result = new MultiLine2DM();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(joinStyle, distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(joinStyle, distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }
}

