/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPoint2D
extends AbstractMultiPoint {
    private static final long serialVersionUID = -2230359991187613190L;

    public MultiPoint2D() {
        super(0);
    }

    public Geometry cloneGeometry() {
        MultiPoint2D clone = new MultiPoint2D();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 2;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new AbstractMultiPoint.PointIterator(null), false, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        return this;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        Line2D line = new Line2D();
        line.ensureCapacity(this.primitives.size());
        for (Point2D point : this.primitives) {
            line.addVertex(point);
        }
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        Polygon2D polygon = new Polygon2D();
        polygon.ensureCapacity(this.primitives.size());
        for (Point2D point : this.primitives) {
            polygon.addVertex(point);
        }
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Point2D) {
            return primitive;
        }
        if (primitive instanceof Point) {
            Point point = (Point)primitive;
            return new Point2D(point.getX(), point.getY());
        }
        if (primitive.getGeometryType().getSubType() == 0) {
            try {
                return primitive.toPoints();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to lines";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 2D primitives can be fixed to MultiPoint2D";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2D) {
            return point;
        }
        return new Point2D(point.getX(), point.getY());
    }
}

