/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPolygon2D
extends AbstractMultiPolygon {
    private static final long serialVersionUID = -7018238332611444136L;

    public MultiPolygon2D() {
        super(0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        for (Polygon2D polygon : this.primitives) {
            MultiPoint points = polygon.toPoints();
            multiPoint.ensureCapacity(multiPoint.getPrimitivesNumber() + points.getPrimitivesNumber());
            for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(points.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        for (Polygon2D polygon : this.primitives) {
            MultiLine lines = polygon.toLines();
            multiLine.ensureCapacity(multiLine.getPrimitivesNumber() + lines.getPrimitivesNumber());
            for (int i = 0; i < lines.getPrimitivesNumber(); ++i) {
                multiLine.addPrimitive((Line2D)lines.getPrimitiveAt(i));
            }
        }
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        return this;
    }

    public Geometry cloneGeometry() {
        MultiPolygon2D clone = new MultiPolygon2D();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 2;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Polygon2D) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 0) {
            MultiPolygon polygons;
            try {
                polygons = primitive.toPolygons();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to polygons";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
            return polygons;
        }
        String message = "Only 2D primitives can be fixed to MultiPolygon2D";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(joinStyle)));
    }
}

