/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.complex;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.handler.Handler;
import org.gvsig.fmap.geom.jts.AbstractGeometry;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractAggregate;
import org.gvsig.fmap.geom.jts.complex.PrimitiveListPathIterator;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;

public class DefaultComplex
extends AbstractGeometry
implements Complex {
    private final ArrayList<Primitive> primitives = new ArrayList();

    public DefaultComplex(GeometryType geomType) {
        super(geomType.getType(), geomType.getSubType());
    }

    public DefaultComplex(int subtype) {
        super(0, subtype);
    }

    public int getPrimitivesNumber() {
        return this.primitives.size();
    }

    public Primitive getPrimitiveAt(int i) {
        return this.primitives.get(i);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        PrimitiveListPathIterator it = new PrimitiveListPathIterator(this.primitives, affineTransform);
        return it;
    }

    public Iterator<Geometry> iterator() {
        return new Iterator<Geometry>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < DefaultComplex.this.getPrimitivesNumber();
            }

            @Override
            public Geometry next() {
                return DefaultComplex.this.getPrimitiveAt(this.current++);
            }
        };
    }

    public void ensureCapacity(int capacity) {
        this.primitives.ensureCapacity(capacity);
    }

    public void reProject(ICoordTrans ct) {
        for (Primitive primitive : this.primitives) {
            primitive.reProject(ct);
        }
    }

    public void transform(AffineTransform at) {
        for (Primitive primitive : this.primitives) {
            primitive.transform(at);
        }
    }

    @Override
    public boolean is3D() {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (!geometryJTS.is3D()) continue;
            return true;
        }
        return false;
    }

    public Shape getShape(AffineTransform affineTransform) {
        if (this.isEmpty()) {
            return new GeneralPath();
        }
        boolean empty = true;
        Iterator<Geometry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Geometry primitive = iterator.next();
            if (primitive.isEmpty()) continue;
            empty = false;
            break;
        }
        if (empty) {
            return new GeneralPath();
        }
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AbstractAggregate)) return false;
        AbstractAggregate other = (AbstractAggregate)obj;
        if (other.getPrimitivesNumber() != this.getPrimitivesNumber()) return false;
        for (int j = 0; j < this.getPrimitivesNumber(); ++j) {
            if (this.getPrimitiveAt(j).equals(other.getPrimitiveAt(j))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.primitives);
        return hash;
    }

    public boolean canBeTransformed(AffineTransform at) {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (geometryJTS.canBeTransformed(at)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (geometryJTS.canBeReprojected(ct)) continue;
            return false;
        }
        return true;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Iterator<Primitive> iterator = this.primitives.iterator();
        while (iterator.hasNext()) {
            ((GeometryJTS)iterator.next()).flip();
        }
        Collections.reverse(this.primitives);
    }

    public void addPrimitive(Primitive primitive) {
        Geometry geom = this.fixPrimitive(primitive);
        if (geom != null) {
            if (geom instanceof MultiPrimitive) {
                for (int i = 0; i < ((MultiPrimitive)geom).getPrimitivesNumber(); ++i) {
                    this.addPrimitive(((MultiPrimitive)geom).getPrimitiveAt(i));
                }
            } else {
                this.primitives.add((Primitive)geom);
            }
        }
    }

    public void addPrimitives(Aggregate aggregate) {
        for (Geometry primitive : aggregate) {
            this.addPrimitive((Primitive)primitive);
        }
    }

    public void addPrimitives(Geometry geometry) {
        if (geometry instanceof Primitive) {
            this.addPrimitive((Primitive)geometry);
        } else {
            this.addPrimitives((Aggregate)geometry);
        }
    }

    private Geometry fixPrimitive(Primitive primitive) {
        return primitive;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(0));
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(2));
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(1));
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(3));
        }
        return other;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.offset(distance));
        }
        return other;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.offset(joinStyle, distance));
        }
        return other;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<com.vividsolutions.jts.geom.Geometry> geometries = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
        for (Primitive primitive : this.primitives) {
            geometries.add(((GeometryJTS)primitive).getJTS());
        }
        GeometryCollection col = gf.createGeometryCollection(geometries.toArray(new com.vividsolutions.jts.geom.Geometry[geometries.size()]));
        return col;
    }

    public Geometry cloneGeometry() {
        DefaultComplex other = new DefaultComplex(this.getGeometryType().getSubType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.cloneGeometry());
        }
        return other;
    }

    public int getDimension() {
        return this.getGeometryType().getDimension();
    }

    public Handler[] getHandlers(int type) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (Primitive primitive : this.primitives) {
            Handler[] primitiveHandlers = primitive.getHandlers(type);
            handlers.addAll(Arrays.asList(primitiveHandlers));
        }
        return handlers.toArray(new Handler[handlers.size()]);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint res = GeometryLocator.getGeometryManager().createMultiPoint(this.getGeometryType().getSubType());
        res.setProjection(this.getProjection());
        for (Primitive primitive : this.primitives) {
            MultiPoint points = primitive.toPoints();
            for (Geometry point : points) {
                res.addPrimitives(point);
            }
        }
        return res;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine res = GeometryLocator.getGeometryManager().createMultiLine(this.getGeometryType().getSubType());
        res.setProjection(this.getProjection());
        for (Primitive primitive : this.primitives) {
            MultiLine geometries = primitive.toLines();
            for (Geometry geom : geometries) {
                res.addPrimitives(geom);
            }
        }
        return res;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon res = GeometryLocator.getGeometryManager().createMultiPolygon(this.getGeometryType().getSubType());
        res.setProjection(this.getProjection());
        for (Primitive primitive : this.primitives) {
            MultiPolygon geometries = primitive.toPolygons();
            for (Geometry geom : geometries) {
                res.addPrimitives(geom);
            }
        }
        return res;
    }

    public Collection<? extends Geometry> getElements() {
        return this.primitives;
    }

    public Iterator<Geometry> iterator(final Predicate<Geometry> filter) {
        final Iterator<Geometry> it = this.iterator();
        return new Iterator<Geometry>(){
            Geometry next = null;

            @Override
            public boolean hasNext() {
                while (it.hasNext()) {
                    this.next = (Geometry)it.next();
                    if (!filter.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Geometry next() {
                return this.next;
            }
        };
    }

    public Aggregate createAggregate(int type, Predicate<Geometry> filter) throws CreateGeometryException {
        MultiPrimitive aggregate = (MultiPrimitive)GeometryLocator.getGeometryManager().create(type, this.getGeometryType().getSubType());
        for (Primitive primitive : this.primitives) {
            if (!filter.test((Geometry)primitive)) continue;
            aggregate.addPrimitives((Geometry)primitive);
        }
        return aggregate;
    }

    @Override
    public boolean isEmpty() {
        return this.getPrimitivesNumber() < 1;
    }

    public int size() {
        return this.getPrimitivesNumber();
    }

    public Geometry get(int position) {
        return this.getPrimitiveAt(position);
    }
}

