/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.complex;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;

class PrimitiveListPathIterator
extends GeneralPathXIterator {
    private final AffineTransform at;
    private boolean done;
    private int index = 0;
    private final List<PathIterator> iterators;
    private final List<Geometry> geometries;

    public PrimitiveListPathIterator(List<Geometry> geometries, AffineTransform at) {
        super((IGeneralPathX)new GeneralPathX());
        this.geometries = geometries;
        this.iterators = new ArrayList<PathIterator>(geometries.size());
        if (at == null) {
            at = new AffineTransform();
        }
        this.at = at;
        for (Primitive primitive : geometries) {
            if (primitive.isEmpty()) continue;
            this.iterators.add(primitive.getPathIterator(at));
        }
        this.done = this.iterators.isEmpty();
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public void next() {
        PathIterator pathIteratorPrimitive = this.iterators.get(this.index);
        pathIteratorPrimitive.next();
        if (pathIteratorPrimitive.isDone()) {
            ++this.index;
            this.done = this.index == this.geometries.size();
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public int currentSegment(double[] coords) {
        return this.iterators.get(this.index).currentSegment(coords);
    }

    @Override
    public int currentSegment(float[] coords) {
        return this.iterators.get(this.index).currentSegment(coords);
    }
}

