/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.gputils;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIteratorSimple;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.jdk.GeomUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeneralPathX
extends GeneralPathX
implements Shape,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGeneralPathX.class);
    protected static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private List pointTypes = new ArrayList();
    private List pointCoords = new ArrayList();
    private final Byte[] SEG_TYPES = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10};
    int windingRule;
    private boolean isSimple = true;
    private boolean is2Dz = false;
    private double zValue = 0.0;

    private DefaultGeneralPathX() {
        super(false);
        this.setWindingRule(0);
    }

    public DefaultGeneralPathX(int rule) {
        super(false);
        this.setWindingRule(rule);
    }

    public DefaultGeneralPathX(PathIterator piter, boolean is2Dz, double zValue) {
        this(piter, is2Dz, zValue, 10);
    }

    public DefaultGeneralPathX(PathIterator piter, boolean is2Dz, double zValue, int capacity) {
        this(0);
        this.is2Dz = is2Dz;
        this.zValue = zValue;
        this.setWindingRule(piter.getWindingRule());
        this.pointCoords = new ArrayList(capacity);
        this.pointTypes = new ArrayList(capacity);
        this.append(piter, false);
    }

    private void needRoom(int newTypes, int newCoords, boolean needMove) {
        if (needMove && this.getNumTypes() == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
    }

    public synchronized void moveTo(double x, double y) {
        int numtypes = this.getNumTypes();
        if (numtypes > 0 && this.getTypeAt(numtypes - 1) == 0) {
            Point point = this.getPointAt(this.getNumCoords() - 1);
            point.setX(x);
            point.setY(y);
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes.add(this.SEG_TYPES[0]);
            this.addPoint(x, y);
        }
    }

    public synchronized void moveTo(Point point) {
        int numtypes = this.getNumTypes();
        if (numtypes > 0 && this.getTypeAt(numtypes - 1) == 0) {
            this.pointCoords.remove(this.getNumCoords() - 1);
            this.addPoint(point);
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes.add(this.SEG_TYPES[0]);
            this.addPoint(point);
        }
    }

    public synchronized void lineTo(double x, double y) {
        this.needRoom(1, 2, true);
        this.pointTypes.add(this.SEG_TYPES[1]);
        this.addPoint(x, y);
    }

    public synchronized void lineTo(Point point) {
        this.needRoom(1, 2, true);
        this.pointTypes.add(this.SEG_TYPES[1]);
        this.addPoint(point);
    }

    public synchronized void addSegment(Point[] segment) {
        if (segment != null && segment.length > 0) {
            this.needRoom(segment.length, 2 * segment.length, true);
            for (Point segment1 : segment) {
                this.pointTypes.add(this.SEG_TYPES[1]);
                this.addPoint(segment1);
            }
        }
    }

    private void addPoint(double x, double y) {
        Point p = this.createPoint(x, y);
        this.pointCoords.add(p);
    }

    private Point createPoint(double x, double y) {
        Point p;
        try {
            if (this.is2Dz) {
                p = geomManager.createPoint(x, y, 1);
                p.setCoordinateAt(2, this.zValue);
            } else {
                p = geomManager.createPoint(x, y, 0);
            }
        }
        catch (CreateGeometryException e) {
            LOG.warn("Error creating a point", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return p;
    }

    private void addPoint(Point point) {
        if (this.is2Dz) {
            this.pointCoords.add(this.createPoint(point.getX(), point.getY()));
            return;
        }
        if (point instanceof Point2D) {
            this.pointCoords.add(point);
            return;
        }
        this.pointCoords.add(this.createPoint(point.getX(), point.getY()));
    }

    public synchronized void quadTo(double x1, double y1, double x2, double y2) {
        this.needRoom(1, 4, true);
        this.pointTypes.add(this.SEG_TYPES[2]);
        this.addPoint(x1, y1);
        this.addPoint(x2, y2);
        this.isSimple = false;
    }

    public synchronized void quadTo(Point point1, Point point2) {
        this.needRoom(1, 4, true);
        this.pointTypes.add(this.SEG_TYPES[2]);
        this.addPoint(point1);
        this.addPoint(point2);
        this.isSimple = false;
    }

    public synchronized void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.needRoom(1, 6, true);
        this.pointTypes.add(this.SEG_TYPES[3]);
        this.addPoint(x1, y1);
        this.addPoint(x2, y2);
        this.addPoint(x3, y3);
        this.isSimple = false;
    }

    public synchronized void curveTo(Point point1, Point point2, Point point3) {
        this.needRoom(1, 6, true);
        this.pointTypes.add(this.SEG_TYPES[3]);
        this.addPoint(point1);
        this.addPoint(point2);
        this.addPoint(point3);
        this.isSimple = false;
    }

    public synchronized void closePath() {
        if (this.getNumTypes() == 0 || this.getTypeAt(this.getNumTypes() - 1) != 4) {
            this.needRoom(1, 0, true);
            this.pointTypes.add(this.SEG_TYPES[4]);
        }
    }

    public boolean isClosed() {
        PathIterator theIterator = this.getPathIterator(null, geomManager.getFlatness());
        double[] theData = new double[6];
        double xFinal = 0.0;
        double yFinal = 0.0;
        double xIni = 0.0;
        double yIni = 0.0;
        boolean first = true;
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    xIni = theData[0];
                    yIni = theData[1];
                    if (!first) break;
                    first = false;
                    break;
                }
                case 1: {
                    xFinal = theData[0];
                    yFinal = theData[1];
                    break;
                }
                case 4: {
                    return true;
                }
            }
            theIterator.next();
        }
        return xFinal == xIni && yFinal == yIni;
    }

    public void append(PathIterator pi, boolean connect) {
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (!connect || this.getNumTypes() < 1 || this.getNumCoords() < 2) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.getTypeAt(this.getNumTypes() - 1) != 4 && this.getPointAt(this.getNumCoords() - 1).getX() == coords[0] && this.getPointAt(this.getNumCoords() - 1).getY() == coords[1]) break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pi.next();
            connect = false;
        }
    }

    public void append(GeneralPathX gp) {
        for (int i = 0; i < gp.getNumCoords(); ++i) {
            byte type = gp.getTypeAt(i);
            Point point = gp.getPointAt(i);
            this.pointTypes.add(this.SEG_TYPES[type]);
            this.addPoint(point);
        }
    }

    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = rule;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Point2D getCurrentPoint() {
        if (this.getNumTypes() < 1) return null;
        if (this.getNumCoords() < 1) {
            return null;
        }
        int index = this.getNumCoords();
        if (this.getTypeAt(this.getNumTypes() - 1) != 4) return new Point2D.Double(this.getPointAt(index - 1).getX(), this.getPointAt(index - 1).getY());
        int i = this.getNumTypes() - 2;
        while (i > 0) {
            switch (this.getTypeAt(i)) {
                case 0: {
                    return new Point2D.Double(this.getPointAt(index - 1).getX(), this.getPointAt(index - 1).getY());
                }
                case 1: {
                    index -= 2;
                    break;
                }
                case 2: {
                    index -= 4;
                    break;
                }
                case 3: {
                    index -= 6;
                }
            }
            --i;
        }
        return new Point2D.Double(this.getPointAt(index - 1).getX(), this.getPointAt(index - 1).getY());
    }

    public synchronized void reset() {
        this.pointCoords.clear();
        this.pointTypes.clear();
    }

    public void transform(AffineTransform at) {
        for (int i = 0; i < this.getNumCoords(); ++i) {
            this.getPointAt(i).transform(at);
        }
    }

    public void reProject(ICoordTrans ct) {
        for (int i = 0; i < this.getNumCoords(); ++i) {
            this.getPointAt(i).reProject(ct);
        }
    }

    public synchronized Shape createTransformedShape(AffineTransform at) {
        DefaultGeneralPathX gp = (DefaultGeneralPathX)this.clone();
        if (at != null) {
            gp.transform(at);
        }
        return gp;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public synchronized Rectangle2D getBounds2D() {
        double x1;
        double x2;
        double y1;
        double y2;
        int i = this.getNumCoords();
        if (i > 0) {
            y1 = y2 = this.getPointAt(--i).getY();
            x1 = x2 = this.getPointAt(i).getX();
            while (i > 0) {
                double y = this.getPointAt(--i).getY();
                double x = this.getPointAt(i).getX();
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.pointTypes.size() < 2) {
            return false;
        }
        int cross = GeomUtilities.pointCrossingsForPath((PathIterator)this.getPathIterator(null), (double)x, (double)y);
        if (this.windingRule == 1) {
            return cross != 0;
        }
        return (cross & 1) != 0;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return GeomUtilities.contains((PathIterator)this.getPathIterator(null), (double)x, (double)y, (double)(x + w), (double)(y + h));
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return GeomUtilities.intersects((PathIterator)this.getPathIterator(null), (double)x, (double)y, (double)w, (double)h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        if (this.isSimple) {
            return new GeneralPathXIteratorSimple((IGeneralPathX)this, at);
        }
        return new GeneralPathXIterator((IGeneralPathX)this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        int i;
        DefaultGeneralPathX copy = new DefaultGeneralPathX();
        copy.windingRule = this.windingRule;
        copy.isSimple = this.isSimple;
        for (i = 0; i < this.getNumTypes(); ++i) {
            copy.pointTypes.add(this.pointTypes.get(i));
        }
        for (i = 0; i < this.getNumCoords(); ++i) {
            copy.addPoint(this.getPointAt(i).cloneGeometry());
        }
        return copy;
    }

    DefaultGeneralPathX(int windingRule, byte[] pointTypes, int numTypes, double[] pointCoords, int numCoords) {
        super(false);
        this.windingRule = windingRule;
        this.setPointTypes(pointTypes);
        this.setNumTypes(numTypes);
        this.setPointCoords(pointCoords);
        this.setNumCoords(numCoords);
    }

    public void setNumTypes(int numTypes) {
    }

    public int getNumTypes() {
        return this.pointTypes.size();
    }

    public int setNumCoords(int numCoords) {
        return this.pointCoords.size();
    }

    public int getNumCoords() {
        return this.pointCoords.size();
    }

    public byte getTypeAt(int index) {
        return (Byte)this.pointTypes.get(index);
    }

    public void setPointTypes(byte[] pointTypes) {
        this.pointTypes.clear();
        for (int i = 0; i < pointTypes.length; ++i) {
            this.pointTypes.add(this.SEG_TYPES[pointTypes[i]]);
        }
    }

    public byte[] getPointTypes() {
        byte[] bytes = new byte[this.pointTypes.size()];
        for (int i = 0; i < this.pointTypes.size(); ++i) {
            bytes[i] = (Byte)this.pointTypes.get(i);
        }
        return bytes;
    }

    public void setPointCoords(double[] pointCoords) {
        this.pointCoords.clear();
        for (int i = 0; i < pointCoords.length; i += 2) {
            this.addPoint(pointCoords[i], pointCoords[i + 1]);
        }
    }

    public double[] getPointCoords() {
        double[] doubles = new double[this.pointCoords.size() * 2];
        for (int i = 0; i < this.getNumCoords(); ++i) {
            doubles[i * 2] = this.getPointAt(i).getX();
            doubles[i * 2 + 1] = this.getPointAt(i).getY();
        }
        return doubles;
    }

    public Point getPointAt(int index) {
        return (Point)this.pointCoords.get(index);
    }

    public double[] getCoordinatesAt(int index) {
        return this.getPointAt(index).getCoordinates();
    }

    public double[] get3DCoordinatesAt(int index) {
        Point p = this.getPointAt(index);
        if (p instanceof Point3D) {
            return p.getCoordinates();
        }
        double[] coords = new double[]{p.getX(), p.getY(), 0.0};
        return coords;
    }

    public void flip() {
        PathIterator theIterator = this.getPathIterator(null, geomManager.getFlatness());
        double[] theData = new double[6];
        CoordinateList coordList = new CoordinateList();
        DefaultGeneralPathX newGp = new DefaultGeneralPathX();
        ArrayList<CoordinateList> listOfParts = new ArrayList<CoordinateList>();
        while (!theIterator.isDone()) {
            int type = theIterator.currentSegment(theData);
            switch (type) {
                case 0: {
                    coordList = new CoordinateList();
                    listOfParts.add(coordList);
                    Coordinate c1 = new Coordinate(theData[0], theData[1]);
                    coordList.add(c1, true);
                    break;
                }
                case 1: {
                    Coordinate c1 = new Coordinate(theData[0], theData[1]);
                    coordList.add(c1, true);
                    break;
                }
                case 4: {
                    coordList.add((Object)coordList.getCoordinate(0));
                }
            }
            theIterator.next();
        }
        for (int i = listOfParts.size() - 1; i >= 0; --i) {
            coordList = (CoordinateList)listOfParts.get(i);
            Coordinate[] coords = coordList.toCoordinateArray();
            CoordinateArraySequence seq = new CoordinateArraySequence(coords);
            CoordinateSequences.reverse((CoordinateSequence)seq);
            coords = seq.toCoordinateArray();
            newGp.moveTo(coords[0].x, coords[0].y);
            for (int j = 1; j < coords.length; ++j) {
                newGp.lineTo(coords[j].x, coords[j].y);
            }
        }
        this.reset();
        this.append(newGp.getPathIterator(null), false);
    }

    public boolean isCCW() {
        PathIterator theIterator = this.getPathIterator(null, geomManager.getFlatness());
        double[] theData = new double[6];
        Coordinate first = null;
        CoordinateList coordList = new CoordinateList();
        boolean bFirst = true;
        while (!theIterator.isDone()) {
            int type = theIterator.currentSegment(theData);
            switch (type) {
                case 0: {
                    Coordinate c1 = new Coordinate(theData[0], theData[1]);
                    if (!bFirst) break;
                    if (bFirst) {
                        bFirst = false;
                        first = c1;
                    }
                    coordList.add(c1, true);
                    break;
                }
                case 1: {
                    Coordinate c1 = new Coordinate(theData[0], theData[1]);
                    coordList.add(c1, true);
                }
            }
            theIterator.next();
        }
        coordList.add(first, true);
        return CGAlgorithms.isCCW((Coordinate[])coordList.toCoordinateArray());
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void ensureCapacity(int capacity) {
    }
}

