/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.gputils;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;

public class GeneralPathXIterator
implements PathIterator {
    protected int typeIdx = 0;
    protected int pointIdx = 0;
    protected IGeneralPathX path;
    protected AffineTransform affine;
    private static final int[] curvesize = new int[]{1, 1, 2, 3, 0};

    public GeneralPathXIterator(IGeneralPathX path) {
        this(path, null);
    }

    public GeneralPathXIterator(IGeneralPathX path, AffineTransform at) {
        this.path = path;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.typeIdx >= this.path.getNumTypes();
    }

    @Override
    public void next() {
        byte type = this.path.getTypeAt(this.typeIdx++);
        this.pointIdx += curvesize[type];
    }

    @Override
    public int currentSegment(float[] coords) {
        byte type = this.path.getTypeAt(this.typeIdx);
        int numPoints = curvesize[type];
        int offset = 0;
        for (int i = 0; i < numPoints; ++i) {
            double[] coordinates = this.path.getCoordinatesAt(this.pointIdx + i);
            if (this.affine != null) {
                this.affine.transform(coordinates, 0, coords, offset, 1);
            } else {
                coords[offset] = (float)coordinates[0];
                coords[offset + 1] = (float)coordinates[1];
            }
            offset += 2;
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        byte type = this.path.getTypeAt(this.typeIdx);
        int numPoints = curvesize[type];
        int offset = 0;
        for (int i = 0; i < numPoints; ++i) {
            double[] coordinates = this.path.getCoordinatesAt(this.pointIdx + i);
            if (this.affine != null) {
                this.affine.transform(coordinates, 0, coords, offset, 1);
            } else {
                System.arraycopy(coordinates, 0, coords, offset, 2);
            }
            offset += 2;
        }
        return type;
    }

    public int currentSegment3D(double[] coords) {
        byte type = this.path.getTypeAt(this.typeIdx);
        int numPoints = curvesize[type];
        int offset = 0;
        for (int i = 0; i < numPoints; ++i) {
            double[] coordinates = this.path.get3DCoordinatesAt(this.pointIdx + i);
            if (this.affine != null) {
                this.affine.transform(coordinates, 0, coords, offset, 1);
            } else {
                System.arraycopy(coordinates, 0, coords, offset, 3);
            }
            offset += 3;
        }
        return type;
    }
}

