/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.fromwkb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.type.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostGISEWKBParser {
    private boolean gHaveM;
    private boolean gHaveZ;
    private boolean gHaveS;
    private static final Logger LOG = LoggerFactory.getLogger(PostGISEWKBParser.class);
    private final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private final GeometryType[] pointGeometryTypes = new GeometryType[]{this.loadPointGeometryType(0, "2D"), this.loadPointGeometryType(1, "3D"), this.loadPointGeometryType(2, "2DM"), this.loadPointGeometryType(3, "3DM")};

    private GeometryType loadPointGeometryType(int subtype, String subTypeName) {
        try {
            return this.geomManager.getGeometryType(1, subtype);
        }
        catch (Exception e) {
            LOG.info("Unable to get a reference to the geometry type Point{}, to be cached", (Object)subTypeName);
            return null;
        }
    }

    public synchronized Geometry parse(byte[] value) throws CreateGeometryException {
        ByteBuffer buf = ByteBuffer.wrap(value);
        return this.parseGeometry(buf);
    }

    protected Geometry parseGeometry(ByteBuffer data) throws CreateGeometryException {
        int realtype = this.parseTypeAndSRID(data);
        MultiPrimitive result1 = null;
        switch (realtype) {
            case 1: {
                result1 = this.parsePoint(data, this.gHaveZ, this.gHaveM);
                break;
            }
            case 2: {
                result1 = this.parseLineString(data, this.gHaveZ, this.gHaveM);
                break;
            }
            case 3: {
                result1 = this.parsePolygon(data, this.gHaveZ, this.gHaveM);
                break;
            }
            case 4: {
                result1 = this.parseMultiPoint(data, this.gHaveZ, this.gHaveM);
                break;
            }
            case 5: {
                result1 = this.parseMultiLineString(data, this.gHaveZ, this.gHaveM);
                return result1;
            }
            case 6: {
                result1 = this.parseMultiPolygon(data, this.gHaveZ, this.gHaveM);
                break;
            }
            case 7: {
                result1 = this.parseCollection(data);
                break;
            }
        }
        return result1;
    }

    protected int parseTypeAndSRID(ByteBuffer data) {
        byte endian = data.get();
        if (endian == 1) {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        this.gHaveZ = (typeword & Integer.MIN_VALUE) != 0;
        this.gHaveM = (typeword & 0x40000000) != 0;
        this.gHaveS = (typeword & 0x20000000) != 0;
        int srid = -1;
        if (this.gHaveS) {
            srid = data.getInt();
        }
        if (realtype >= 3000) {
            this.gHaveM = true;
            this.gHaveZ = true;
            this.gHaveS = false;
            realtype -= 3000;
        } else if (realtype >= 2000) {
            this.gHaveM = true;
            this.gHaveZ = false;
            this.gHaveS = false;
            realtype -= 2000;
        } else if (realtype >= 1000) {
            this.gHaveM = false;
            this.gHaveZ = true;
            this.gHaveS = false;
            realtype -= 1000;
        }
        return realtype;
    }

    private Point parsePoint(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        double x = data.getDouble();
        double y = data.getDouble();
        int subtype = this.getSubType(haveZ, haveM);
        Point point = this.pointGeometryTypes[subtype] == null ? (Point)this.geomManager.create(1, subtype) : (Point)this.pointGeometryTypes[subtype].create();
        point.setX(x);
        point.setY(y);
        if (haveZ) {
            point.setCoordinateAt(2, data.getDouble());
        }
        if (haveM) {
            point.setCoordinateAt(point.getDimension() - 1, data.getDouble());
        }
        return point;
    }

    private int getSubType(boolean haveZ, boolean haveM) {
        int subtype = haveZ ? (haveM ? 3 : 1) : (haveM ? 2 : 0);
        return subtype;
    }

    private MultiPrimitive parseMultiLineString(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int subType = this.getSubType(haveZ, haveM);
        MultiLine multiline = this.geomManager.createMultiLine(subType);
        int count = data.getInt();
        for (int i = 0; i < count; ++i) {
            this.parseTypeAndSRID(data);
            Point[] points = this.parsePointArray(data, haveZ, haveM);
            Line line = this.geomManager.createLine(this.getSubType(haveZ, haveM));
            line.ensureCapacity(points.length);
            for (Point point : points) {
                line.addVertex(point);
            }
            multiline.addPrimitive((Primitive)line);
        }
        return multiline;
    }

    private MultiPrimitive parseMultiPolygon(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        int subType = this.getSubType(haveZ, haveM);
        MultiPolygon multipolygon = this.geomManager.createMultiPolygon(subType);
        for (int i = 0; i < count; ++i) {
            this.parseTypeAndSRID(data);
            Polygon polygon = this.geomManager.createPolygon(subType);
            int countRings = data.getInt();
            for (int nring = 0; nring < countRings; ++nring) {
                Object ring = nring == 0 ? polygon : (Ring)this.geomManager.create(20, subType);
                Point[] points = this.parsePointsAsPointsArray(data, haveZ, haveM);
                ring.ensureCapacity(points.length);
                int lastPoint = points.length - 1;
                for (int k = 0; k <= lastPoint; ++k) {
                    ring.addVertex(points[k]);
                }
                if (nring == 0) continue;
                polygon.addInteriorRing((Ring)ring);
            }
            multipolygon.addPrimitive((Primitive)polygon);
        }
        return multipolygon;
    }

    private Point[] parsePointsAsPointsArray(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        Point[] points = new Point[count];
        int subtype = this.getSubType(haveZ, haveM);
        block5: for (int i = 0; i < count; ++i) {
            points[i] = this.geomManager.createPoint(data.getDouble(), data.getDouble(), subtype);
            switch (subtype) {
                case 1: {
                    points[i].setCoordinateAt(2, data.getDouble());
                    continue block5;
                }
                case 2: {
                    points[i].setCoordinateAt(points[i].getDimension() - 1, data.getDouble());
                    continue block5;
                }
                case 3: {
                    points[i].setCoordinateAt(2, data.getDouble());
                    points[i].setCoordinateAt(points[i].getDimension() - 1, data.getDouble());
                    continue block5;
                }
            }
        }
        return points;
    }

    private MultiPrimitive parseCollection(ByteBuffer data) throws CreateGeometryException {
        int count = data.getInt();
        Geometry[] geoms = new Geometry[count];
        this.parseGeometryArray(data, geoms);
        MultiPrimitive multiPrimitive = (MultiPrimitive)this.geomManager.create(6, 0);
        for (Geometry geom : geoms) {
            multiPrimitive.addPrimitive((Primitive)geom);
        }
        return multiPrimitive;
    }

    private void parseGeometryArray(ByteBuffer data, Geometry[] container) throws CreateGeometryException {
        for (int i = 0; i < container.length; ++i) {
            container[i] = this.parseGeometry(data);
        }
    }

    private Line parseLineString(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        Line line = this.geomManager.createLine(this.getSubType(haveZ, haveM));
        line.ensureCapacity(points.length);
        for (Point point : points) {
            line.addVertex(point);
        }
        return line;
    }

    private Point[] parsePointArray(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        Point[] result = new Point[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.parsePoint(data, haveZ, haveM);
        }
        return result;
    }

    private Polygon parsePolygon(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        int subType = this.getSubType(haveZ, haveM);
        Polygon polygon = this.geomManager.createPolygon(subType);
        this.fillLinearRing(data, (OrientablePrimitive)polygon, haveZ, haveM);
        for (int i = 1; i < count; ++i) {
            Ring ring = (Ring)this.geomManager.create(20, subType);
            this.fillLinearRing(data, (OrientablePrimitive)ring, haveZ, haveM);
            polygon.addInteriorRing(ring);
        }
        return polygon;
    }

    private void fillLinearRing(ByteBuffer data, OrientablePrimitive ring, boolean haveZ, boolean haveM) throws CreateGeometryException {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        int lastPoint = points.length - 1;
        ring.ensureCapacity(points.length);
        for (int i = 0; i <= lastPoint; ++i) {
            ring.addVertex(points[i]);
        }
    }

    private MultiPoint parseMultiPoint(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int subType = this.getSubType(haveZ, haveM);
        MultiPoint multipoint = this.geomManager.createMultiPoint(subType);
        int points = data.getInt();
        multipoint.ensureCapacity(points);
        for (int i = 0; i < points; ++i) {
            this.parseTypeAndSRID(data);
            multipoint.addPoint(this.parsePoint(data, haveZ, haveM));
        }
        return multipoint;
    }
}

