/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.fromwkt;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.tools.exception.BaseException;

public class WKTParser {
    private GeometryManager manager = GeometryLocator.getGeometryManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geometry geometry = this.read(reader);
            return geometry;
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        try {
            return this.readGeometryTaggedText(tokenizer);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        catch (CreateGeometryException e) {
            throw new ParseException(e.toString());
        }
    }

    private Coordinate[] getCoordinates(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate(tokenizer));
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(",")) {
            coordinates.add(this.getPreciseCoordinate(tokenizer));
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private Coordinate getPreciseCoordinate(StreamTokenizer tokenizer) throws IOException, ParseException {
        Coordinate coord = new Coordinate();
        coord.x = this.getNextNumber(tokenizer);
        coord.y = this.getNextNumber(tokenizer);
        if (this.isNumberNext(tokenizer)) {
            coord.z = this.getNextNumber(tokenizer);
        }
        return coord;
    }

    private boolean isNumberNext(StreamTokenizer tokenizer) throws IOException {
        try {
            boolean bl = tokenizer.nextToken() == -2;
            return bl;
        }
        finally {
            tokenizer.pushBack();
        }
    }

    private double getNextNumber(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -1: {
                throw new ParseException("Expected number but encountered end of stream");
            }
            case 10: {
                throw new ParseException("Expected number but encountered end of line");
            }
            case -2: {
                return tokenizer.nval;
            }
            case -3: {
                throw new ParseException("Expected number but encountered word: " + tokenizer.sval);
            }
            case 40: {
                throw new ParseException("Expected number but encountered '('");
            }
            case 41: {
                throw new ParseException("Expected number but encountered ')'");
            }
            case 44: {
                throw new ParseException("Expected number but encountered ','");
            }
        }
        return 0.0;
    }

    private String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals("EMPTY") || nextWord.equals("(")) {
            return nextWord;
        }
        throw new ParseException("Expected 'EMPTY' or '(' but encountered '" + nextWord + "'");
    }

    private String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals(",") || nextWord.equals(")")) {
            return nextWord;
        }
        throw new ParseException("Expected ')' or ',' but encountered '" + nextWord + "'");
    }

    private String getNextCloser(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals(")")) {
            return nextWord;
        }
        throw new ParseException("Expected ')' but encountered '" + nextWord + "'");
    }

    private String getNextWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -1: {
                throw new ParseException("Expected word but encountered end of stream");
            }
            case 10: {
                throw new ParseException("Expected word but encountered end of line");
            }
            case -2: {
                throw new ParseException("Expected word but encountered number: " + tokenizer.nval);
            }
            case -3: {
                return tokenizer.sval.toUpperCase();
            }
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 44: {
                return ",";
            }
        }
        return null;
    }

    private Geometry readGeometryTaggedText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        String type = this.getNextWord(tokenizer);
        if (type.equals("POINT")) {
            return this.readPointText(tokenizer);
        }
        if (type.equals("LINESTRING")) {
            return this.readLineStringText(tokenizer);
        }
        if (type.equals("LINEARRING")) {
            return this.readLinearRingText(tokenizer);
        }
        if (type.equals("POLYGON")) {
            return this.readPolygonText(tokenizer);
        }
        if (type.equals("MULTIPOINT")) {
            return this.readMultiPointText(tokenizer);
        }
        if (type.equals("MULTILINESTRING")) {
            return this.readMultiLineStringText(tokenizer);
        }
        if (type.equals("MULTIPOLYGON")) {
            return this.readMultiPolygonText(tokenizer);
        }
        System.err.println("Unknown type: " + type);
        throw new ParseException("Unknown type: " + type);
    }

    private Geometry readPointText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return null;
        }
        Coordinate c = this.getPreciseCoordinate(tokenizer);
        Point point = (Point)this.manager.create(1, 0);
        point.setX(c.x);
        point.setY(c.y);
        this.getNextCloser(tokenizer);
        return point;
    }

    private Curve readLineStringText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        Coordinate[] arrayC = this.getCoordinates(tokenizer);
        GeneralPathX gp = new GeneralPathX();
        gp.moveTo(arrayC[0].x, arrayC[0].y);
        for (int i = 1; i < arrayC.length; ++i) {
            gp.lineTo(arrayC[i].x, arrayC[i].y);
        }
        Curve curve = (Curve)this.manager.create(2, 0);
        curve.setGeneralPath(gp);
        return curve;
    }

    private Surface readLinearRingText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        Coordinate[] arrayC = this.getCoordinates(tokenizer);
        GeneralPathX gp = new GeneralPathX();
        gp.moveTo(arrayC[0].x, arrayC[0].y);
        for (int i = 1; i < arrayC.length; ++i) {
            gp.lineTo(arrayC[i].x, arrayC[i].y);
        }
        Surface surface = (Surface)this.manager.create(3, 0);
        surface.setGeneralPath(gp);
        return surface;
    }

    private Geometry readMultiPointText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        Coordinate[] coords = this.getCoordinates(tokenizer);
        MultiPoint multiPoint = (MultiPoint)this.manager.create(7, 0);
        for (int i = 0; i < coords.length; ++i) {
            Point point = (Point)this.manager.create(1, 0);
            point.setX(coords[i].x);
            point.setY(coords[i].y);
            multiPoint.addPoint(point);
        }
        return multiPoint;
    }

    private Surface readPolygonText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return null;
        }
        Surface shell = this.readLinearRingText(tokenizer);
        Surface hole = null;
        nextToken = this.getNextCloserOrComma(tokenizer);
        try {
            while (nextToken.equals(",")) {
                hole = this.readLinearRingText(tokenizer);
                if (!shell.contains((Geometry)hole)) {
                    throw new CreateGeometryException(3, 0, (Throwable)new Exception("Hole not in shell."));
                }
                shell = (Surface)shell.difference((Geometry)hole);
                nextToken = this.getNextCloserOrComma(tokenizer);
            }
        }
        catch (BaseException ge) {
            throw new CreateGeometryException(3, 0, (Throwable)ge);
        }
        return shell;
    }

    private Geometry readMultiLineStringText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return null;
        }
        MultiCurve mcu = this.manager.createMultiCurve(0);
        Curve lineString = this.readLineStringText(tokenizer);
        mcu.addCurve(lineString);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(",")) {
            lineString = this.readLineStringText(tokenizer);
            mcu.addCurve(lineString);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return mcu;
    }

    private Geometry readMultiPolygonText(StreamTokenizer tokenizer) throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return null;
        }
        MultiSurface msu = this.manager.createMultiSurface(0);
        Surface polygon = this.readPolygonText(tokenizer);
        msu.addSurface(polygon);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(",")) {
            polygon = this.readPolygonText(tokenizer);
            msu.addSurface(polygon);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return msu;
    }
}

