/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.arc;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.AbstractArc;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public class Arc2D
extends AbstractArc {
    private static final long serialVersionUID = 3414562338763885954L;

    public Arc2D() {
        super(0);
    }

    public void setPoints(Point center, double radius, double startAngle, double angleExt) {
        this.init = new Point2D(center.getX() + radius * Math.cos(startAngle), center.getY() + radius * Math.sin(startAngle));
        double midAngle = startAngle + angleExt / 2.0;
        this.middle = new Point2D(center.getX() + radius * Math.cos(midAngle), center.getY() + radius * Math.sin(midAngle));
        this.end = new Point2D(center.getX() + radius * Math.cos(startAngle + angleExt), center.getY() + radius * Math.sin(startAngle + angleExt));
    }

    public Point getCenterPoint() {
        ((PointJTS)this.init).getJTS();
        Point2D center = new Point2D(this.getProjection(), JTSUtils.getCircumcentre(this.init, this.middle, this.end));
        return center;
    }

    public Geometry cloneGeometry() {
        Arc2D other = new Arc2D();
        other.setProjection(this.getProjection());
        Point clonedInit = this.init.cloneGeometry();
        Point clonedMiddle = this.middle.cloneGeometry();
        Point clonedEnd = this.end.cloneGeometry();
        other.setPoints(clonedInit, clonedMiddle, clonedEnd);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2D) {
            return point;
        }
        return new Point2D(point.getX(), point.getY());
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    break;
                }
                case 1: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    coordinates.add(new Coordinate(coords[2], coords[3]));
                    break;
                }
                case 3: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    coordinates.add(new Coordinate(coords[2], coords[3]));
                    coordinates.add(new Coordinate(coords[4], coords[5]));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        return JTSUtils.createJTSLineString(this.getProjection(), coordinates);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point2D(this.getProjection(), coordinates[i]));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        Line2D line = new Line2D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        Polygon2D polygon = new Polygon2D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

