/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.arc;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.AbstractArc;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public class Arc2DZM
extends AbstractArc {
    private static final long serialVersionUID = -5691008010954470053L;
    private double zValue = Double.NaN;
    private double mValue = Double.NaN;

    public Arc2DZM() {
        super(1);
    }

    public void setPoints(Point center, double radius, double startAngle, double angleExt) {
        center = this.fixPoint(center);
        this.init = new Point3D(center.getX() + radius * Math.cos(startAngle), center.getY() + radius * Math.sin(startAngle), ((Point3D)center).getZ());
        double midAngle = startAngle + angleExt / 2.0;
        this.middle = new Point3D(center.getX() + radius * Math.cos(midAngle), center.getY() + radius * Math.sin(midAngle), ((Point3D)center).getZ());
        this.end = new Point3D(center.getX() + radius * Math.cos(startAngle + angleExt), center.getY() + radius * Math.sin(startAngle + angleExt), ((Point3D)center).getZ());
    }

    public Point getCenterPoint() {
        ((PointJTS)this.init).getJTS();
        Point3D center = new Point3D(this.getProjection(), JTSUtils.getCircumcentre(this.init, this.middle, this.end));
        return center;
    }

    public Geometry cloneGeometry() {
        Arc2DZM arc2D = new Arc2DZM();
        arc2D.setPoints(this.init.cloneGeometry(), this.middle.cloneGeometry(), this.end.cloneGeometry());
        arc2D.setProjection(this.getProjection());
        return arc2D;
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3DM) {
            Point3DM point3DM = (Point3DM)point;
            if (Double.isNaN(this.zValue) && !Double.isNaN(point3DM.getZ())) {
                this.zValue = point3DM.getZ();
                if (this.init != null) {
                    ((Point3DM)this.init).setZ(this.zValue);
                }
                if (this.middle != null) {
                    ((Point3DM)this.middle).setZ(this.zValue);
                }
                if (this.end != null) {
                    ((Point3DM)this.end).setZ(this.zValue);
                }
            }
            if (Double.isNaN(this.mValue) && !Double.isNaN(point3DM.getM())) {
                this.mValue = point3DM.getM();
                if (this.init != null) {
                    ((Point2DM)this.init).setM(this.mValue);
                }
                if (this.middle != null) {
                    ((Point2DM)this.middle).setM(this.mValue);
                }
                if (this.end != null) {
                    ((Point2DM)this.end).setM(this.mValue);
                }
            }
        }
        return new Point3DM(point.getX(), point.getY(), Double.isNaN(this.zValue) ? 0.0 : this.zValue, Double.isNaN(this.mValue) ? 0.0 : this.mValue);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    break;
                }
                case 1: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    break;
                }
                case 2: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], this.zValue, this.mValue));
                    break;
                }
                case 3: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[4], coords[5], this.zValue, this.mValue));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        return JTSUtils.createJTSLineString(this.getProjection(), coordinates);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point3DM(this.getProjection(), coordinates[i].x, coordinates[i].y, this.zValue, this.mValue));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        Line3DM line = new Line3DM(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3DM multiPolygon = new MultiPolygon3DM();
        Polygon3DM polygon = new Polygon3DM(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

