/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseLine2D
extends AbstractLine {
    private static final long serialVersionUID = -4703049397260763325L;

    public BaseLine2D(int type) {
        super(type, 0);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseLine2D(int type, Coordinate[] coordinates) {
        super(type, 0);
        this.initializeCoordinates(coordinates);
    }

    public BaseLine2D(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 0);
        this.coordinates = coordinates;
    }

    private void initializeCoordinates(Coordinate[] coordinates) {
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point2D(x, y));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Can't add x,y,z coordinate to Line2D.";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2D) {
            return point;
        }
        return new Point2D(point.getX(), point.getY());
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        multiPoint.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            multiPoint.addPoint(new Point2D(this.getProjection(), coordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        multiLine.addPrimitive(this);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        Polygon2D polygon = new Polygon2D(this.coordinates.toCoordinateArray());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    public Point getVertex(int index) {
        Point2D vertex = new Point2D(this.getProjection(), (Coordinate)this.coordinates.get(index));
        return vertex;
    }
}

