/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseLine2DM
extends AbstractLine {
    private static final long serialVersionUID = -2009183729409385543L;

    public BaseLine2DM(int type) {
        super(type, 2);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseLine2DM(int type, Coordinate[] coordinates) {
        super(type, 2);
        this.initializeCoordinates(coordinates);
    }

    public BaseLine2DM(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 2);
        this.coordinates = coordinates;
    }

    private void initializeCoordinates(Coordinate[] coordinates) {
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point2DM(x, y, 0.0));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Can't add x,y,z coordinate to Polygon2DM.";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2DM) {
            return point;
        }
        return new Point2DM(point.getX(), point.getY(), 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        multiPoint.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            multiPoint.addPoint(new Point2DM(this.getProjection(), coordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2DM multiLine = new MultiLine2DM();
        multiLine.addPrimitive(this);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        Polygon2DM polygon = new Polygon2DM(this.coordinates.toCoordinateArray());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    public Point getVertex(int index) {
        Point2DM vertex = new Point2DM(this.getProjection(), (Coordinate)this.coordinates.get(index));
        return vertex;
    }

    @Override
    public double getCoordinateAt(int index, int dimension) {
        if (dimension == 2) {
            return super.getCoordinateAt(index, 3);
        }
        return super.getCoordinateAt(index, dimension);
    }

    @Override
    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        if (dimension == 2) {
            return super.setCoordinateAt(index, 3, value);
        }
        return super.setCoordinateAt(index, dimension, value);
    }
}

