/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseLine3DM
extends AbstractLine {
    private static final long serialVersionUID = 1765763899814153661L;

    public BaseLine3DM(int type, Coordinate[] coordinates) {
        super(type, 3);
        this.initializeCoordinates(coordinates);
    }

    public BaseLine3DM(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 3);
        this.coordinates = coordinates;
    }

    private void initializeCoordinates(Coordinate[] coordinates) {
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
    }

    public BaseLine3DM(int type) {
        super(type, 3);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(x, y, 0.0);
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        Point3DM point = new Point3DM(x, y, z, 0.0);
        return this.addVertex(point);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3DM) {
            return point;
        }
        if (point instanceof Point3D) {
            return new Point3DM(point.getX(), point.getY(), ((Point3D)point).getZ(), 0.0);
        }
        return new Point3DM(point.getX(), point.getY(), 0.0, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3DM multiPoint = new MultiPoint3DM();
        multiPoint.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            multiPoint.addPoint(new Point3DM(this.getProjection(), coordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        multiLine.addPrimitive(this);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3DM multiPolygon = new MultiPolygon3DM();
        Polygon3DM polygon = new Polygon3DM(this.coordinates.toCoordinateArray());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    public Point getVertex(int index) {
        Point3DM vertex = new Point3DM(this.getProjection(), (Coordinate)this.coordinates.get(index));
        return vertex;
    }
}

