/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.ring;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.GeometryJTS2;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Ring;

public class Ring2DM
extends BaseLine2DM
implements Ring,
GeometryJTS2 {
    public Ring2DM() {
        super(20);
    }

    public Ring2DM(Coordinate[] coordinates) {
        super(20, coordinates);
        this.closePrimitive();
    }

    public Ring2DM(ArrayListCoordinateSequence coordinates) {
        super(20, coordinates);
    }

    public Geometry cloneGeometry() {
        Ring2DM clone = new Ring2DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public MultiLine toLines() throws GeometryException {
        MultiLine2DM multiLine = new MultiLine2DM();
        multiLine.addPrimitive(new Line2DM(this.coordinates.toCoordinateArray()));
        return multiLine;
    }

    @Override
    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        multiPolygon.addPrimitive(new Polygon2DM(this.coordinates.toCoordinateArray()));
        return multiPolygon;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSLinearRing(this.getProjection(), this.coordinates);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters();
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring2DM(coords);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring2DM(coords);
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        if (this.coordinates.size() >= 2 && !this.isClosed()) {
            this.closePrimitive();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Ring2DM) {
            Ring2DM other = (Ring2DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                if (((Coordinate)other.coordinates.get(i)).getOrdinate(3) == ((Coordinate)this.coordinates.get(i)).getOrdinate(3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Ring2D ring = new Ring2D(coordinates2D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, 0.0));
        }
        Ring2DM ring = new Ring2DM(coordinates2DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, 0.0));
        }
        Ring3D ring = new Ring3D(coordinates3D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, 0.0, 0.0));
        }
        Ring3DM ring = new Ring3DM(coordinates3DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public org.locationtech.jts.geom.Geometry getJTS2() {
        this.closePrimitive();
        return JTSUtils2.createJTSLinearRing(this.getProjection(), this.coordinates);
    }
}

