/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.ring;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.GeometryJTS2;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine3DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Ring;

public class Ring3DM
extends BaseLine3DM
implements Ring,
GeometryJTS2 {
    private static final long serialVersionUID = 1826148807887112314L;

    public Ring3DM() {
        super(20);
    }

    public Ring3DM(Coordinate[] coordinates) {
        super(20, coordinates);
        this.closePrimitive();
    }

    public Ring3DM(ArrayListCoordinateSequence coordinates) {
        super(20, coordinates);
    }

    public Geometry cloneGeometry() {
        Ring3DM clone = new Ring3DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        multiLine.addPrimitive(new Line3DM(this.coordinates.toCoordinateArray()));
        return multiLine;
    }

    @Override
    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3DM multiPolygon = new MultiPolygon3DM();
        multiPolygon.addPrimitive(new Polygon3DM(this.coordinates.toCoordinateArray()));
        return multiPolygon;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSLinearRing(this.getProjection(), this.coordinates);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters();
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring3DM(coords);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring3DM(coords);
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        if (this.coordinates.size() >= 2 && !this.isClosed()) {
            this.closePrimitive();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Ring3DM) {
            Ring3DM other = (Ring3DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) != coordinate.getOrdinate(2)) {
                    return false;
                }
                if (otherCoordinate.getOrdinate(3) == coordinate.getOrdinate(3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Ring2D ring = new Ring2D(coordinates2D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, 0.0));
        }
        Ring2DM ring = new Ring2DM(coordinates2DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, 0.0));
        }
        Ring3D ring = new Ring3D(coordinates3D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, 0.0, 0.0));
        }
        Ring3DM ring = new Ring3DM(coordinates3DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public org.locationtech.jts.geom.Geometry getJTS2() {
        this.closePrimitive();
        return JTSUtils2.createJTSLinearRing(this.getProjection(), this.coordinates);
    }
}

