/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.AbstractCircle;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseCircle2D
extends AbstractCircle {
    private static final long serialVersionUID = -6981603729327501715L;

    public BaseCircle2D(int type, int subtype, Point center, double radius) {
        super(type, subtype, center, radius);
    }

    public BaseCircle2D(int type, int subtype) {
        super(type, subtype);
    }

    public void setPoints(Point p1, Point p2, Point p3) {
        this.center = new Point2D(p1.getProjection(), JTSUtils.getCircumcentre(p1, p2, p3));
        this.radius = ((PointJTS)this.center).getJTS().distance(((PointJTS)p1).getJTS());
        this.setProjection(this.center.getProjection());
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2D) {
            return point;
        }
        return new Point2D(point.getX(), point.getY());
    }

    protected ArrayListCoordinateSequence getJTSCoordinates() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    break;
                }
                case 1: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    coordinates.add(new Coordinate(coords[2], coords[3]));
                    break;
                }
                case 3: {
                    coordinates.add(new Coordinate(coords[0], coords[1]));
                    coordinates.add(new Coordinate(coords[2], coords[3]));
                    coordinates.add(new Coordinate(coords[4], coords[5]));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        if (!((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates.add((Coordinate)((Coordinate)coordinates.get(0)).clone());
        }
        return coordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point2D(this.getProjection(), coordinates[i]));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        Line2D line = new Line2D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        Polygon2D polygon = new Polygon2D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

